/*-----------------------------------------------------------------------------
  THIS IS A TCA TUTORIAL EXERCISE ON WIRETAPS.
  IT IMPLEMENTS A SIMPLE DEAD-RECKONING MODULE
  MODIFY THIS FILE AND wiretapsExercise.c
  
  SEARCH THE FILE FOR THE STRING /**.
  THE COMMENT THERE DESCRIBES WHAT CODE NEEDS TO BE ADDED.
  
  TO COMPILE THE MODULE, DO: make wiretapsExercise
  TO RUN THE SYSTEM, START 1) central
  2) simulator/simulator sim.parm
  3) wiretapsExercise (wiretapsExercise -h gives help)
  
  ---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
  
  File:		wiretapsExercise.h
  
  Programmer:	Reid Simmons
  
  Description:	Header file containing type definitions and
  TCA message definitions for the TCA wiretaps usage example.
  
  The example implements a simple dead-reckoning module that
  wiretaps the move and turn commands handled by the simulator.
  
  The following messages are available:
  DEAD_RECK_TURN_CONSTRAINT
  DEAD_RECK_MOVE_GOAL
  DEAD_RECK_LOCATION_QUERY
  
  ---------------------------------------------------------------------------*/

#ifndef WIRETAP_H
#define WIRETAP_H

#ifndef M_PI
#define M_PI		3.14159265358979323846
#endif

/* Type definition and message definition for the "deadReckTurn" wiretap */
/* After every turn command has been achieved, increment the dead-reckoned
   angle by the amount of the turn */

#define DEAD_RECK_TURN_CONSTRAINT  	"deadReckTurnWiretap"
#define	DEAD_RECK_TURN_FORM	 	HERO_TURN_FORM
typedef HERO_TURN_DATA DEAD_RECK_TURN_TYPE;
typedef HERO_TURN_PTR  DEAD_RECK_TURN_PTR;

/* Type definition and message definition for the "deadReckMove" wiretap */
/* When each move command (bounded, unbounded, guarded) is achieved, 
   find out the distance travelled and update the dead-reckoned position
   by the appropriate amount. */

#define DEAD_RECK_MOVE_GOAL  	"deadReckMoveWiretap"
#define	DEAD_RECK_MOVE_FORM 	""

/* Type definition and message definition for the "deadReckLocation" query */
typedef struct { float x;
		 float y;
	       } POSITION_TYPE, *POSITION_PTR;
/** Add the format string for the "position" formatter **/
#define POSITION_FORM 

typedef float ORIENTATION_TYPE, *ORIENTATION_PTR;
#define ORIENTATION_FORM /** Add the format for the "orientation" formatter **/

typedef struct { POSITION_TYPE position;
		 ORIENTATION_TYPE orientation;
	       } LOCATION_TYPE, *LOCATION_PTR;

#define DEAD_RECK_LOCATION_QUERY	"deadReckLocation"
#define DEAD_RECK_LOCATION_QUERY_FORM	""
#define DEAD_RECK_LOCATION_REPLY_FORM	/** This format string is composed of
					  a position and an orientation **/

typedef LOCATION_TYPE DEAD_RECK_LOCATION_REPLY_TYPE;
typedef LOCATION_PTR DEAD_RECK_LOCATION_REPLY_PTR;

/* The simulator has orientation 0 along y-axis and angles running clockwise;
   The trig functions expect 0 along the x-axis and angles running CCW. */
#define SIM_DEG_TO_RAD(d) ((90.0-(d))*M_PI/180.0)
#define RAD_TO_SIM_DEG(r) ((90.0-(r))*180.0/M_PI)

/* The defaults used for the initial dead-reckoned location are:
   x=150.0, y=100.0, angle=0.0 (this is where the simulator starts the robot)
   */
#define X_DEFAULT 150.0
#define Y_DEFAULT 100.0
#define ANGLE_DEFAULT 0.0


#endif
