/*-----------------------------------------------------------------------------
  THIS IS A TCA TUTORIAL EXERCISE ON TASK TREES.
  MODIFY THIS FILE AND taskTreesExercise.c

  SEARCH THE FILE FOR THE STRING /**.
  THE COMMENT THERE DESCRIBES WHAT CODE NEEDS TO BE ADDED.

  TO COMPILE THE MODULE, DO: make taskTreesExercise
  TO RUN THE SYSTEM, START 1) central
                           2) simulator/simulator sim.parm
			   3) taskTreesExercise (taskTreesExercise -h gives help)

-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------

File:		taskTreesExercise.h

Programmer:	Reid Simmons

Description:	Header file containing type definitions and
                TCA message definitions for the TCA task tree example.

		The specific example is to create a goal message that 
		moves the robot in a given polygonal shape.

		The following messages are available:

		  MOVE_TURN_GOAL
		  SHAPE_GOAL

-----------------------------------------------------------------------------*/

#ifndef TASK_TREES_H
#define TASK_TREES_H

/* Type definition and message definition for the "move_turn" goal */

typedef struct { CMS distance;
		 DEGREES angle;
	       } MOVE_TURN_TYPE, *MOVE_TURN_PTR;

#define MOVE_TURN_GOAL "move_turn_g"
#define MOVE_TURN_FORM /** Add the format string for the move_turn message **/


/* Type definition and message definition for the "shape" goal */

typedef struct { int numSides;
		 CMS length;
	       } SHAPE_TYPE, *SHAPE_PTR;

#define SHAPE_GOAL "shape_g"
#define	SHAPE_FORM /** Add the format string for the shape message **/

/* Defaults used for the command line options */
#define NUMSIDES_DEFAULT 3
#define LENGTH_DEFAULT   100.0 /* cms */
#define RANGE_DEFAULT     30.0 /* cms */

#endif /* TASK_TREES_H */
