/*-----------------------------------------------------------------------------

File:		taskTrees.h

Programmer:	Reid Simmons

Description:	Header file containing type definitions and
                TCA message definitions for the TCA task tree example.

		The specific example is to create a goal message that 
		moves the robot in a given polygonal shape.

		The following messages are available:

		  MOVE_TURN_GOAL
		  SHAPE_GOAL

-----------------------------------------------------------------------------*/

#ifndef TASK_TREES_H
#define TASK_TREES_H

/* Type definition and message definition for the "move_turn" goal */

typedef struct { CMS distance;
		 DEGREES angle;
	       } MOVE_TURN_TYPE, *MOVE_TURN_PTR;

#define MOVE_TURN_GOAL "move_turn_g"
#define	MOVE_TURN_FORM "{cms, degrees}"


/* Type definition and message definition for the "shape" goal */

typedef struct { int numSides;
		 CMS length;
	       } SHAPE_TYPE, *SHAPE_PTR;

#define SHAPE_GOAL "shape_g"
#define	SHAPE_FORM "{int, cms}"

/* Defaults used for the command line options */
#define NUMSIDES_DEFAULT 3
#define LENGTH_DEFAULT   100.0 /* cms */
#define RANGE_DEFAULT     30.0 /* cms */

#endif /* TASK_TREES_H */
