/*****************************************************************************
 * PROJECT: TCA Tutorial
 *
 * (c) Copyright 1994 Richard Goodwin & Reid Simmons. All rights reserved.
 *
 * FILE: updates.h
 *
 * ABSTRACT:
 *
 * This file contains the constants that defines the interface to the update
 * routines.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tutorial/simulator/updates.h,v $ 
 * $Revision: 1.3 $
 * $Date: 1996/08/05 16:10:26 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: updates.h,v $
 * Revision 1.3  1996/08/05  16:10:26  rich
 * Added comments to endifs.
 *
 * Revision 1.2  1995/04/07  05:10:15  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Moved global variables into the c files and got rid of #define DECLARE_...
 *
 * Revision 1.1  1994/05/24  21:24:21  rich
 * Checking in Reid's tutorial code, with some fixes to the simulator.
 * Mostly problems with X11.
 *
 *
 *****************************************************************************/

#ifndef INCLUDED_UPDATES
#define INCLUDED_UPDATES

#define CTRL_CONT 1
#define CTRL_STEP 0

#define NEXT_PAUSE 1
#define NEXT_CONT  0

extern unsigned long timeScale;		/* in msec */
extern unsigned long currentTime;
extern unsigned long timeIncrement;
extern int refreshRate;
extern int continuallyUpdateLasers;

void updatePosition(unsigned long tMsec);
void forceUpdate(void);
unsigned long getTime(void);		/* get current time in msecs */
void resetTime(void);
void refreshSimDisplay(int force);
void simUpdate(void);

#endif /* INCLUDED_UPDATES */
