/*****************************************************************
 *
 * File: simInterface.h
 *
 * Abstract: Interface between simulator and TCA.
 *
 *****************************************************************/

#ifndef SIM_INTERFACE_H
#define SIM_INTERFACE_H

#define DEF_TRANS_VELOCITY  15.0
#define DEF_ROT_VELOCITY    30.0

extern void simBoundedMove (CMS distance);
extern void simUnboundedMove (void);
extern CMS simGuardedMove (CMS distance, CMS stopRange);
extern void simTurn (DEGREES turn);
extern void simStop (void);
extern void simSetVelocity(double transVelocity, double rotVelocity);
extern void simVelocity(double *transVelocity, double *rotVelocity);
extern void simTalk(char *message);
extern void sonarScan(CMS sonarData[24]);
extern int simInMotion(void);
extern CMS simLastMoveDistance(void);

#endif /* SIM_INTERFACE_H */
