/*****************************************************************************
 * PROJECT: TCA Tutorial
 *
 * (c) Copyright 1994 Richard Goodwin & Reid Simmons. All rights reserved.
 *
 * FILE: sensor.h
 *
 * ABSTRACT:
 *
 * Interface to the sensor.c routines.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tutorial/simulator/sensors.h,v $ 
 * $Revision: 1.4 $
 * $Date: 1996/08/05 16:10:19 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: sensors.h,v $
 * Revision 1.4  1996/08/05  16:10:19  rich
 * Added comments to endifs.
 *
 * Revision 1.3  1995/04/07  05:09:57  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Moved global variables into the c files and got rid of #define DECLARE_...
 *
 * Revision 1.2  1995/01/25  00:07:20  rich
 * Release of tca 7.9.  Mostly speed improvements.
 * The cvs binaries may now be located in /usr/local.
 * Formatting changes.
 *
 * Revision 1.1  1994/05/24  21:23:51  rich
 * Checking in Reid's tutorial code, with some fixes to the simulator.
 * Mostly problems with X11.
 *
 *
 *****************************************************************************/

#include "files.h"

#ifndef INCLUDED_SENSORS
#define INCLUDED_SENSORS

#define CMPERFOOT 30.48

/* sensor variables for the head sonar */
extern int n_sensors;
extern int n_sensors_fact;

extern double sensors_distance;
extern double sensors_range;

extern double sensor[50];
extern double sensor2[200];

extern double sensor_noise_level;
extern double sensor_zero;

void sensors(void);
void sensors1(int s1, int s2);

#endif /* INCLUDED_SENSORS */

