/*****************************************************************************
 * PROJECT: TCA Tutorial
 *
 * (c) Copyright 1994 Richard Goodwin & Reid Simmons. All rights reserved.
 *
 * FILE: draw_env.h
 *
 * ABSTRACT:
 *
 * Interface to the environment drawing routines.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tutorial/simulator/draw_env.h,v $ 
 * $Revision: 1.4 $
 * $Date: 1996/08/05 16:10:16 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: draw_env.h,v $
 * Revision 1.4  1996/08/05  16:10:16  rich
 * Added comments to endifs.
 *
 * Revision 1.3  1995/04/07  05:09:47  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Moved global variables into the c files and got rid of #define DECLARE_...
 *
 * Revision 1.2  1995/01/25  00:07:11  rich
 * Release of tca 7.9.  Mostly speed improvements.
 * The cvs binaries may now be located in /usr/local.
 * Formatting changes.
 *
 * Revision 1.1  1994/05/24  21:23:13  rich
 * Checking in Reid's tutorial code, with some fixes to the simulator.
 * Mostly problems with X11.
 *
 *
 *****************************************************************************/

#ifndef INCLUDED_DRAW_ENV
#define INCLUDED_DRAW_ENV

#include "tca/ezx.h"

#define DRAW_LINE(window, x1, y1, x2, y2)\
EZX_DrawLine\
(window, ((int)(x1 * scale)), bm_h-((int)(y1 * scale)),\
 ((int)(x2 * scale)), bm_h-((int)(y2 * scale)))

#define DRAW_CIRCLE(window, xc, yc, radius)\
EZX_DrawCircle\
(window, ((int)(xc * scale)), bm_h-((int)(yc * scale)),\
 ((int)(radius * scale)))

#define SONAR_ON 1
#define SONAR_OFF 0

extern char env_name[DEFAULT_LINE_LENGTH];
extern double scale;
extern int displayp;
/* if true, then robot leaves a "slime" trail */
extern BOOLEAN DISPLAY_TRAIL; 

extern Drawable w_env;
extern Pixmap bitmap;
extern int bm_w, bm_h;
extern BOOLEAN useColor;

extern int mapWidth, mapHeight;

extern int robotColour;
extern int backColour;
extern int obstColour;
extern int roomColour;
extern int corrColour;
extern int doorColour;
extern int textColour;
extern int fovColour;

extern char *textFont;
extern char *buttonFont;

extern int sonarState;
extern int sonarWwidth;
extern int posWwidth;
extern int posWheight;
extern int rotation_mode;

void DrawMapOnBitmap(void);
void DisplayBitmap(int x, int y, int w, int h);
void RedrawMap(Widget w, XExposeEvent *ev, String *parm, Cardinal *n);

void plot_robot(int modus);
void plot_object(int i);

void RedrawWholeMap(void);
void RedrawSonar(Widget widget, XExposeEvent *ev, String *parm, 
		 Cardinal *n);
void RedrawPosition(Widget widget, XExposeEvent *ev,
		    String *parm, Cardinal *n);
void ResetTime(void);
void UpdateElapsedTime(void);
void RedrawTime(void);

#endif /* INCLUDED_DRAW_ENV */
