/*****************************************************************************
 * PROJECT: TCA Tutorial
 *
 * (c) Copyright 1994 Richard Goodwin & Reid Simmons. All rights reserved.
 *
 * FILE: common.h
 *
 * ABSTRACT:
 * 
 * This file provides some common type and macro definitions.
 * Also provides ANSI C definitions for standard library routines.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tutorial/simulator/common.h,v $ 
 * $Revision: 1.6 $
 * $Date: 1996/08/05 16:10:14 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 * $Log: common.h,v $
 * Revision 1.6  1996/08/05  16:10:14  rich
 * Added comments to endifs.
 *
 * Revision 1.5  1996/01/12  00:54:44  rich
 * Simplified GNUmakefiles. Removed define of BOOLEAN.
 *
 * Revision 1.4  1995/04/07  05:09:43  rich
 * Fixed GNUmakefiles to find the release directory.
 * Moved all system includes into libc.h
 * Moved global variables into the c files and got rid of #define DECLARE_...
 *
 * Revision 1.3  1995/01/25  00:07:06  rich
 * Release of tca 7.9.  Mostly speed improvements.
 * The cvs binaries may now be located in /usr/local.
 * Formatting changes.
 *
 * Revision 1.2  1994/11/02  21:41:21  rich
 * Now works for linux machines (i486).
 * Uses tca/libc.h.
 *
 * Revision 1.1  1994/05/24  21:22:41  rich
 * Checking in Reid's tutorial code, with some fixes to the simulator.
 * Mostly problems with X11.
 *
 *
 *****************************************************************************/

#ifndef COMMON_LOADED
#define COMMON_LOADED

#include "tca/libc.h"

#ifdef __GNUC__
#define INLINE __inline__
#else
#define INLINE
#endif

#define EXTERN extern
#define PRIVATE static
#define PUBLIC

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

typedef double DEGREES;
typedef double RADIANS;
typedef double METERS;
typedef double CMS;
typedef double FEET;

#define DEGREES_NAME   "degrees" /* for TCA usage */
#define DEGREES_FORMAT "double" /* for TCA usage */

#define CMS_NAME       "cms" /* for TCA usage */
#define CMS_FORMAT     "double" /* for TCA usage */

#define ABS(x)	  ((x) >= 0 ? (x) : -(x))
#define FABS(x)	  ((x) >= 0.0 ? (x) : -(x))
#undef MAX
#define MAX(x,y)  ((x) > (y) ? (x) : (y))
#undef MIN
#define MIN(x,y)  ((x) > (y) ? (y) : (x))
#define SQR(x)    ((x) * (x))

#define NEAR(x1,x2,eps) (ABS((x1)-(x2))<=(eps))

#define IRINT(x)  ((int) rint(x))

#ifndef PI
#define PI 3.1415926535897932384626433
#endif

#define SQRT2 1.4142135
#define TWO_PI (2 * PI)

#define RAD_TO_DEG(r)   ((r) * 180.0 / PI)
#define DEG_TO_RAD(d)   ((d) * PI / 180.0)

#define FT2M (12.0/39.37)
#define FEET_TO_METERS(ft) ((ft)*FT2M)
#define METERS_TO_FEET(ms) ((ms)/FT2M)

#define INCHES_TO_CMS(in) (100.0*FEET_TO_METERS((in)/12.0))
#define CMS_TO_INCHES(cm) (12.0*METERS_TO_FEET((cm)/100.0))

#define DEFAULT_LINE_LENGTH 80

#define RAND() (random() / (double) INT_MAX)

#define ALMOST_ZERO  0.000000001

#endif /* COMMON_LOADED */
