/*-----------------------------------------------------------------------------

File:		resources1.c

Programmer:	Reid Simmons

Description:	TCA module that illustrates example 1 in the use of resources.
                Send a move, talk, and stop command
		-- show how the timing changes when multiple resources
		   are defined.

		This is a stand-alone module.  
		Command line options are: resources1 <-s>,
		where "-s" indicates to query for motion status.

		To run this example:
		  1. central 3 -lmdsi
		  2. simulator/simulator sim.param -r
		  3. taskTrees
		  4. resources1 -s

                Compare with the performance in running:
		  1. central 3 -lmdsi
		  2. simulator/simulator sim.param
		  3. taskTrees
		  4. resources1

-----------------------------------------------------------------------------*/

#include "tca/libc.h"
#include "tca.h"
#include "simMessages.h"
#include "resources.h"

int getbool(char *prompt, int ret_default)
{
  char input[80];
  printf("%s",prompt);
  fflush(stdout);
  gets(input);
  if ((input[0] == 'y') || (input[0] == 'Y')) 
    return TRUE;
  if ((input[0] == 'n') || (input[0] == 'N')) 
    return FALSE;
  return ret_default;
}

static void queryForMotionStatus (void)
{
  MOTION_REPLY_TYPE inMotion;

  tcaQuery(MOTION_QUERY, NULL, (void *)&inMotion);
  fprintf(stderr, "  Robot is%s moving\n", (inMotion ? "" : " not"));
  fflush(stdout);
}

/*----------------------- main ------------------------
  RESOURCES1 module: Example in using multiple resources.

  For this example, run the simulator first as regularly, then run in
  "multiple resource mode" (command line option -r).

  Command line options are: resources1 <-s>,
  where "-s" indicates to query for motion status (should be used only 
  when simulator is running in -r mode).

----------------------------------------------------------------------------*/
void main (int argc, char **argv)
{
  BOUNDED_MOVE_COMMAND_TYPE move;
  TALK_COMMAND_TYPE talk;
  int queryForStatus;
  DISTANCE_MOVED_REPLY_TYPE distMoved;

  queryForStatus = (argc >= 2 && !strcmp(argv[1],"-s"));

  tcaConnectModule("RESOURCCES", tcaServerMachine());

  tcaWaitUntilReady();

  move = DEFAULT_MOVE;
  fprintf(stderr, "  Commanding move of %3.1f cms\n", move);
  tcaExecuteCommand(BOUNDED_MOVE_COMMAND, (void *)&move);

  talk = "Hi Y'all";
  fprintf(stderr, "  Saying '%s'\n", talk);
  tcaExecuteCommandWithConstraints(NULL, TALK_COMMAND, (void *)&talk,
				   NO_TPLCONSTR);

  if (queryForStatus) queryForMotionStatus();
  while (!getbool("Stop motion?", TRUE)) {
    if (queryForStatus) queryForMotionStatus();
  }
  tcaWaitForCommandWithConstraints(NULL, STOP_COMMAND, NULL, NO_TPLCONSTR);
  fprintf(stderr, "  Stop command completed\n");
  tcaQuery(DISTANCE_MOVED_QUERY, NULL, (void *)&distMoved);
  fprintf(stderr, "  Moved total of %3.1f cms\n", distMoved);
}
