/*-----------------------------------------------------------------------------

File:		monitors.h

Programmer:	Reid Simmons

Description:	Header file containing type definitions and
                TCA message definitions for the TCA monitors usage example.
		The following messages are available:

		  RANGE_QUERY
		  STOP_ACTION_COMMAND

		A polling interval monitor is available:

		  GUARDED_MOVE_MONITOR

-----------------------------------------------------------------------------*/

#ifndef MONITOR_H
#define MONITOR_H

/* Type definition and message definition for the "rangeQuery" query */
/* Take sonar readings from +/- 90 degrees: if readings are less than
   the "range" argument, return the closest reading; otherwise NullReply */

typedef CMS RANGE_QUERY_TYPE, *RANGE_QUERY_PTR;

typedef CMS RANGE_QUERY_REPLY_TYPE, *RANGE_QUERY_REPLY_PTR;

#define RANGE_QUERY		  "rangeQuery"
#define	RANGE_QUERY_FORM	  "cms"
#define	RANGE_QUERY_REPLY_FORM	  "cms"


/* Type definition and message definition for the "stopAction" command */
/* Stop all current motions and return a failure (the data is the distance
   traveled so far). */

typedef RANGE_QUERY_REPLY_TYPE STOP_ACTION_TYPE;
typedef RANGE_QUERY_REPLY_PTR  STOP_ACTION_PTR;

#define STOP_ACTION_COMMAND	"stopAction_c"
#define	STOP_ACTION_FORM  	RANGE_QUERY_REPLY_FORM

/* Message definition for the "guardedMoveMonitor" monitor */

#define GUARDED_MOVE_MONITOR	"guardedMoveMonitor"
#define PERIOD_DEFAULT 		1 /* second */

#endif /* MONITOR_H */
