/*-----------------------------------------------------------------------------
  
  File:		exceptions.h
  
  Programmer:	Reid Simmons
  
  Description:	Header file containing type definitions and
  TCA message definitions for the TCA exceptions usage example.
  
  The example handles the "GuardedMoveFailure" exception
  issued by the GUARDED_MOVE_COMMAND message.  
  Very simple recovery strategy: turn left or right 90 degrees,
  move a distance to the side, continue the rest of the original
  commanded distance, and then turn back to the original goal.
  If one of the detour moves encounters an obstacle, the
  exception handler can be invoked recursively.
  VERY SIMPLE: ALMOST DEFINITELY WILL BREAK IN COMPLEX SITUATIONS,
  BUT SUITABLE TO DEMONSTRATE EXCEPTION HANDLING.
  
  The following messages are available:
  GUARDED_MOVE_EXCEPTION
  
  ---------------------------------------------------------------------------*/

#ifndef EXCEPTION_H
#define EXCEPTION_H

#define ROBOT_RADIUS    30.0
#define DETOUR_DISTANCE (2*ROBOT_RADIUS)

/* Type definition and message definition for the "guardedMoveFailure"
   exception */

/* Distance moved when exception was detected */
typedef CMS GUARDED_MOVE_EXCEPTION_TYPE, *GUARDED_MOVE_EXCEPTION_PTR;

#define GUARDED_MOVE_EXCEPTION	 	"guardedMoveFailure"
#define	GUARDED_MOVE_EXCEPTION_FORM	"cms"

#define GUARDED_MOVE_EXCEPTION_HANDLER 	"guardedMoveExceptionHandler"

#endif /* EXCEPTION_H */
