/*-----------------------------------------------------------------------------
  THIS IS A TCA TUTORIAL EXERCISE ON REGISTERING MESSAGES AND HANDLERS.
  MODIFY THIS FILE AND billBoardExercise.h

  SEARCH THE FILE FOR THE STRING /**.
  THE COMMENT THERE DESCRIBES WHAT CODE NEEDS TO BE ADDED.
  You can do the exercise in stages. Fill in the /**1 comments for stage 1, 
  the /**2 for stage 2...

  TO COMPILE THE MODULE, DO: make billBoardExercise
  TO RUN THE SYSTEM, START 1) central
                           2) billBoardExercise
			   3) artist <your name>

-----------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------

File:		billBoard.h

Programmer:	Richard Goodwin

Description:	TCA module that provides a graphics server.  It is used to
                illustrate how to register messages and handlers.

		Message handlers for the following message are implemented:

		This is a header file for use with billBoard.c

		To run this example:
		  1. central 2 -lmdsi
		  2. billBoard
		  3. artist <your name>

-----------------------------------------------------------------------------*/

#ifndef INC_BBMSG
#define INC_BBMSG

#define BB_WIDTH  300
#define BB_HEIGHT 300

/* Define constants for registering messages */

/* Simple messages */

/**1 Define format,  command takes no parameters **/
#define BB_CLEAR_CMD         "C_bb_clear"
#define BB_CLEAR_CMD_FORMAT  

/**1 Define format,  command takes no parameters **/
#define BB_FLASH_CMD         "C_bb_flash"
#define BB_FLASH_CMD_FORMAT  

/**2 Define format,  command takes a string. **/
#define BB_FILL_CMD         "C_bb_fill"
#define BB_FILL_CMD_FORMAT  

/* Messages to draw using structure formats */

typedef struct square {
  int top;
  int left;
  int size;
  char *colour;
} SQUARE_TYPE, *SQUARE_PTR;

/**3 Define format,  command takes a SQUARE_TYPE. **/
#define BB_DRAW_SQUARE_CMD         "C_bb_drawSquare"
#define BB_DRAW_SQUARE_CMD_FORMAT  

typedef struct point {
  int x;
  int y;
} POINT_TYPE, *POINT_PTR;

/**3 Define format for "POINT". **/
#define BB_POINT_NAME         "POINT"
#define BB_POINT_NAME_FORMAT  

typedef struct circle {
  POINT_TYPE center;
  int radius;
  char *colour;
  BOOLEAN filled;
} CIRCLE_TYPE, *CIRCLE_PTR;

/**3 Define format,  command takes a CIRCLE_TYPE. **/
#define BB_DRAW_CIRCLE_CMD         "C_bb_drawCircle"
#define BB_DRAW_CIRCLE_CMD_FORMAT  

/* Messages to draw using array formats */

typedef POINT_TYPE LINE_TYPE[2];
typedef LINE_TYPE *LINE_PTR;

/**4 Define format,  command takes a LINE_TYPE, 
  a fixed array of two points. **/
#define BB_DRAW_LINE_CMD         "C_bb_drawLine"
#define BB_DRAW_LINE_CMD_FORMAT  

/* Messages to draw using variable array formats. lines is really a
   variable array of lines. */

typedef struct _lines {
  int num_lines;
  LINE_PTR lines;
} LINES_TYPE, *LINES_PTR;

/**5 Define format,  command takes a LINES_TYPE. **/
#define BB_DRAW_LINES_CMD         "C_bb_drawLines"
#define BB_DRAW_LINES_CMD_FORMAT  

/* Messages to draw using linked lists */

typedef struct _point {
  POINT_TYPE point;
  struct _point *next;
} POINT_ELEMENT, *POINT_LIST;

/**6 Define format,  command takes a POINT_LIST. **/
#define BB_CONNECT_DOTS_CMD         "C_bb_connectDots"
#define BB_CONNECT_DOTS_CMD_FORMAT  

#endif /* INC_BBMSG */
