/*-----------------------------------------------------------------------------
  THIS IS A TCA TUTORIAL EXERCISE ON REGISTERING MESSAGES AND HANDLERS.
  MODIFY THIS FILE AND billBoardExercise.h

  SEARCH THE FILE FOR THE STRING /**.
  THE COMMENT THERE DESCRIBES WHAT CODE NEEDS TO BE ADDED.
  You can do the exercise in stages. Fill in the /**1 comments for stage 1, 
  the /**2 for stage 2...

  TO COMPILE THE MODULE, DO: make billBoardExercise
  TO RUN THE SYSTEM, START 1) central
                           2) billBoardExercise
			   3) artist <your name>

-----------------------------------------------------------------------------*/
/*-----------------------------------------------------------------------------

File:		billBoard.c

Programmer:	Richard Goodwin

Description:	TCA module that provides a graphics server.  It is used to
                illustrate how to register messages and handlers.

		Very little error checking is done, X may crash if you use 
                unreasonable parameter values.

		Message handlers for the following message are implemented:

		This is a stand-alone module.  It does not take any 
		command-line options.

		To run this example:
		  1. central 2 -lmdsi
		  2. billBoard
		  3. artist <your name>

-----------------------------------------------------------------------------*/

#include "tca/libc.h"
#include "tca.h"
#include "tca/ezx.h"
#include "billBoardExercise.h"

/* Global Definitions */
#define BILLBOARD_MODULE_NAME "billBoard"

/* Global Variables */
Window theWindow;

/* Utility routines. */
static void setColour(char *colour)
{
  int theColour = C_RED;
  if (strstr(colour,"red")) {
    printf("Red Fill\n");
    theColour = C_RED;
  } else if (strstr(colour,"white")) {
    printf("White Fill\n");
    theColour = C_WHITE;
  } else if (strstr(colour,"blue")) {
    printf("Blue Fill\n");
    theColour = C_BLUE;
  } else if (strstr(colour,"green")) {
    printf("Green Fill\n");
    theColour = C_LAWNGREEN;
  } else if (strstr(colour,"yellow")) {
    printf("Yellow Fill\n");
    theColour = C_YELLOW;
  } else {
    printf("Unknown Colour\n");
  }
  fflush(stdout);
  EZX_SetColor(theColour);
}

/* Message Handlers */

static void bb_clearHnd(TCA_REF_PTR ref, void *empty)
{
  EZX_ClearWindow(theWindow); 

  /**1 Indicate that the command completed successfully **/

}

static void bb_flashHnd(TCA_REF_PTR ref, void *empty)
{
  EZX_ClearWindow(theWindow); 
  EZX_Flush();
  sleep(1);
  EZX_SetColor(C_RED);
  EZX_FillRectangle(theWindow, 0, 0, BB_WIDTH, BB_HEIGHT);
  EZX_Flush();
  sleep(1);
  EZX_SetColor(C_YELLOW);
  EZX_FillRectangle(theWindow, 0, 0, BB_WIDTH, BB_HEIGHT);
  EZX_Flush();
  sleep(1);
  EZX_ClearWindow(theWindow); 
  EZX_Flush();

  /**1 Indicate that the command completed successfully **/
}

static void bb_fillHnd(TCA_REF_PTR ref, char **colour)
{

  setColour(*colour);
  EZX_FillRectangle(theWindow, 0, 0, BB_WIDTH, BB_HEIGHT);
  /**2 Indicate that the command completed successfully **/

  /**2 Free the data from the message.**/
  EZX_Flush();
}

static void bb_drawSquareHnd(TCA_REF_PTR ref, SQUARE_PTR sqr)
{
  setColour(sqr->colour);
  
  EZX_FillRectangle(theWindow, sqr->left, sqr->top, sqr->size, sqr->size);

  /**3 Indicate that the command completed successfully **/

  /**3 Free the data from the message.**/

  EZX_Flush();
}

static void bb_drawCircleHnd(TCA_REF_PTR ref, CIRCLE_PTR crl)
{
  setColour(crl->colour);
  if (crl->filled)
    EZX_FillCircle(theWindow, crl->center.x, crl->center.y, crl->radius);
  else
    EZX_DrawCircle(theWindow, crl->center.x, crl->center.y, crl->radius);

  /**3 Indicate that the command completed successfully **/

  /**3 Free the data from the message.**/

  EZX_Flush();
}

static void bb_drawLineHnd(TCA_REF_PTR ref, LINE_PTR line)
{
  EZX_DrawLine(theWindow, (*line)[0].x, (*line)[0].y, 
	       (*line)[1].x, (*line)[1].y);

  /**4 Indicate that the command completed successfully **/

  /**4 Free the data from the message.**/

  EZX_Flush();
}

static void bb_drawLinesHnd(TCA_REF_PTR ref, LINES_PTR lines)
{
  int i;

  for ( i=0; i<lines->num_lines; i++) {
    /**5 Execute the command to draw the ith line in the lines array. **/
  }

  /**5 Indicate that the command completed successfully **/

  /**5 Free the data from the message.**/

  EZX_Flush();
}

static void bb_connectDotsHnd(TCA_REF_PTR ref, POINT_LIST *list)
{
  LINE_TYPE line;
  POINT_LIST next;
  
  if(*list != NULL) {
    line[1] = (*list)->point;
    next = (*list)->next;
    while (next != NULL) {
      line[0] = line[1];
      line[1] = next->point;
      /**6 Execute the command to draw "line". **/
      next = next->next;
    }
  }

  /**6 Indicate that the command completed successfully **/

  /**6 Free the data from the message.**/

  EZX_Flush();
}

static void registerAll()
{
  /**3 Register any named format BB_POINT_NAME. **/

  /** Register messages and handlers. (all command messages) **/
  /** The formats are defined in the header file. */
  /**1
    Message Name,        Format,                     handler.
    1 BB_CLEAR_CMD,        BB_CLEAR_CMD_FORMAT,        bb_clearHnd
    1 BB_FLASH_CMD,        BB_FLASH_CMD_FORMAT,        bb_flashHnd
    2 BB_FILL_CMD,         BB_FILL_CMD_FORMAT,         bb_fillHnd
    3 BB_DRAW_SQUARE_CMD,  BB_DRAW_SQUARE_CMD_FORMAT,  bb_drawSquareHnd
    3 BB_DRAW_CIRCLE_CMD,  BB_DRAW_CIRCLE_CMD_FORMAT,  bb_drawCircleHnd
    4 BB_DRAW_LINE_CMD,    BB_DRAW_LINE_CMD_FORMAT,    bb_drawLineHnd
    5 BB_DRAW_LINES_CMD,   BB_DRAW_LINES_CMD_FORMAT,   bb_drawLinesHnd
    6 BB_CONNECT_DOTS_CMD, BB_CONNECT_DOTS_CMD_FORMAT, bb_connectDotsHnd
    **/
}

void main(int argc, char *argv[])
{

  /* Initialize X11. */
  EZX_InitGraphics(getenv("DISPLAY"),BILLBOARD_MODULE_NAME);

  /* Create the window */
  theWindow = EZX_MakeWindow(BILLBOARD_MODULE_NAME,
			     BB_WIDTH, BB_HEIGHT,
			     "+20+20");
  
  /**1 Connect to TCA as BILLBOARD_MODULE_NAME */

  /* Register messages and handlers */
  registerAll();
  
  /**1 Wait until the system has started. **/

  /**1 Enter the main loop for handling messages. **/
}
