/*-----------------------------------------------------------------------------

File:		billBoard.h

Programmer:	Richard Goodwin

Description:	TCA module that provides a graphics server.  It is used to
                illustrate how to register messages and handlers.

		Message handlers for the following message are implemented:

		This is a header file for use with billBoard.c

		To run this example:
		  1. central 2 -lmdsi
		  2. billBoard
		  3. artist <your name>

-----------------------------------------------------------------------------*/

#ifndef INC_BBMSG
#define INC_BBMSG

#define BB_WIDTH  300
#define BB_HEIGHT 300

/* Define constants for registering messages */

/* Simple messages */

#define BB_CLEAR_CMD         "C_bb_clear"
#define BB_CLEAR_CMD_FORMAT  NULL

#define BB_FLASH_CMD         "C_bb_flash"
#define BB_FLASH_CMD_FORMAT  NULL

#define BB_FILL_CMD         "C_bb_fill"
#define BB_FILL_CMD_FORMAT  "string"

/* Messages to draw using structure formats */

typedef struct square {
  int top;
  int left;
  int size;
  char *colour;
} SQUARE_TYPE, *SQUARE_PTR;

#define BB_DRAW_SQUARE_CMD         "C_bb_drawSquare"
#define BB_DRAW_SQUARE_CMD_FORMAT  "{int,int,int,string}"

typedef struct point {
  int x;
  int y;
} POINT_TYPE, *POINT_PTR;

#define BB_POINT_NAME         "POINT"
#define BB_POINT_NAME_FORMAT  "{int,int}"

typedef struct circle {
  POINT_TYPE center;
  int radius;
  char *colour;
  BOOLEAN filled;
} CIRCLE_TYPE, *CIRCLE_PTR;

#define BB_DRAW_CIRCLE_CMD         "C_bb_drawCircle"
#define BB_DRAW_CIRCLE_CMD_FORMAT  "{POINT,int,string,boolean}"

/* Messages to draw using array formats */

typedef POINT_TYPE LINE_TYPE[2];
typedef LINE_TYPE *LINE_PTR;

#define BB_DRAW_LINE_CMD         "C_bb_drawLine"
#define BB_DRAW_LINE_CMD_FORMAT  "[POINT:2]"

/* Messages to draw using variable array formats */

typedef struct _lines {
  int num_lines;
  LINE_PTR lines;
} LINES_TYPE, *LINES_PTR;

#define BB_DRAW_LINES_CMD         "C_bb_drawLines"
#define BB_DRAW_LINES_CMD_FORMAT  "{int,<[POINT:2]:1>}"

/* Messages to draw using linked lists */

typedef struct _point {
  POINT_TYPE point;
  struct _point *next;
} POINT_ELEMENT, *POINT_LIST;

#define BB_CONNECT_DOTS_CMD         "C_bb_connectDots"
#define BB_CONNECT_DOTS_CMD_FORMAT  "*{POINT,*!}"

#endif  /* INC_BBMSG */
