/*-----------------------------------------------------------------------------

File:		artist.c

Programmer:	Richard Goodwin

Description:	TCA module that provides a graphics server.  It is used to
                illustrate how to register messages and handlers.

		Very little error checking is done, X may crash if you use 
                unreasonable parameter values.

		Message handlers for the following message are implemented:

		This is a stand-alone module.  It does not take any 
		command-line options.

		To run this example:
		  1. central 2 -lmdsi
		  2. billBoard
		  3. artist <your name>

-----------------------------------------------------------------------------*/

#include "tca/libc.h"		
#include "tca/basics.h"		

#include "tca.h"
#include "billBoard.h"

/* Global Definitions */
#define ARTIST_MODULE_NAME "artist"

/* Global Variables */

LINE_TYPE ticArray[] = {
  {{ 30, 60},{150, 60}},
  {{ 30,120},{150,120}},
  {{ 60, 30},{ 60,150}},
  {{120, 30},{120,150}},
};

LINES_TYPE tictactoe = {
  4, ticArray
};

POINT_TYPE houseArray[] = {
  {200,200},
  {200,240},
  {240,240},
  {200,200},
  {240,200},
  {240,240},
  {220,260},
  {200,240},
  {240,200},
  {0,0},
};

POINT_LIST theHouse =NULL;

static void makeHouse(void)
{
  int i;

  POINT_LIST point=NULL, next=NULL;
  
  for (i=0; houseArray[i].x != 0; i++) {
    point = malloc(sizeof(POINT_ELEMENT));
    point->point = houseArray[i];
    point->next = next;
    next = point;
  }
  theHouse = next;
}

static void printCmdSummary(void)
{
  printf("Commands:  clear, flash, fill, square, circle, line, tictactoe, house\n");
  printf(">");
  fflush(stdout);
  fflush(stdout);
}

void main(int argc, char *argv[])
{
  char inputLine[80];
  char *inputPtr = &(inputLine[0]);
  /* Variables to use as message parameters. */
  SQUARE_TYPE theSquare;
  CIRCLE_TYPE theCircle;
  LINE_TYPE theLine;

  /* Set up the data structures. */
  makeHouse();

  /* Connect to TCA */
  if (argc >= 2)
    tcaConnectModule(argv[1], tcaServerMachine());
  else
    tcaConnectModule(ARTIST_MODULE_NAME, tcaServerMachine());
  
  /* No messages or handlers to register */
  
  /* Wait until the system has started. */
  tcaWaitUntilReady();
  
  while (1) {
    printCmdSummary();
    gets(inputLine);
    if (strstr(inputLine,"clear")) {
      printf("Clearing...\n");
      tcaExecuteCommand(BB_CLEAR_CMD,NULL);
    } else if (strstr(inputLine,"flash")) {
      printf("Flashing...\n");
      tcaExecuteCommand(BB_FLASH_CMD,NULL);
    } else if (strstr(inputLine,"fill")) {
      printf("Enter Colour (red, white, blue, green, yellow) > ");
      fflush(stdout);
      gets(inputLine);
      tcaExecuteCommand(BB_FILL_CMD,&inputPtr);
    } else if (strstr(inputLine,"square")) {
      printf("Enter top left size > ");
      fflush(stdout);
      gets(inputLine);
      sscanf(inputLine,"%d %d %d",&(theSquare.top), &(theSquare.left),
	    &(theSquare.size));
      printf("\nEnter colour (red, white, blue, green, yellow) > ");
      fflush(stdout);
      gets(inputLine);
      theSquare.colour = inputPtr;
      tcaExecuteCommand(BB_DRAW_SQUARE_CMD,&theSquare);
    } else if (strstr(inputLine,"circle")) {
      printf("Enter center x, center y, radius, fill (0,1) >");
      fflush(stdout);
      gets(inputLine);
      sscanf(inputLine,"%d %d %d %d", 
	    &(theCircle.center.x), 
	    &(theCircle.center.y),
	    &(theCircle.radius), 
	    &(theCircle.filled));
      printf("\nEnter colour (red, white, blue, green, yellow) > ");
      fflush(stdout);
      gets(inputLine);
      theCircle.colour = inputPtr;
      tcaExecuteCommand(BB_DRAW_CIRCLE_CMD,&theCircle);
    } else if (strstr(inputLine,"line")) {
      printf("Enter x1, y1, x2, y2 >");
      fflush(stdout);
      gets(inputLine);
      sscanf(inputLine,"%d %d %d %d",&(theLine[0].x), &(theLine[0].y), 
	    &(theLine[1].x), &(theLine[1].y));
      tcaExecuteCommand(BB_DRAW_LINE_CMD,&theLine);
    } else if (strstr(inputLine,"tictactoe")) {
      tcaExecuteCommand(BB_DRAW_LINES_CMD,&tictactoe);
    } else if (strstr(inputLine,"house")) {
      tcaExecuteCommand(BB_CONNECT_DOTS_CMD,&theHouse);
    } else if (strstr(inputLine,"quit")) {
      exit(0);
    } else {
      printf("Unknown command %s:\n", inputPtr);
    }
    fflush(stdout);
  }
}

