/*****************************************************************
 * File: tview.c
 * Author: Domingo Gallardo, CMU
 * Purpose: main application
 *
 * $Revision: 1.4 $
 * $Date: 1996/02/13 21:32:05 $
 * $Author: rich $
 *
 * REVISION HISTORY
 *
 * $Log: tview.c,v $
 * Revision 1.4  1996/02/13  21:32:05  rich
 * Fixed linux header problems.
 *
 * Revision 1.3  1996/01/31  22:56:03  reids
 * Added automatic updating of (micro) version control numbers.
 * Also, removed dependence in makefile on libtca.a
 *
 * Revision 1.2  1995/12/15  01:26:38  rich
 * Fixed the includes.
 *
 * Revision 1.1  1995/04/05  18:32:39  rich
 * Moved tview files to a subdirectory.
 *
 * Revision 1.1  1994/05/31  03:26:46  rich
 * Moved Domingo's tview tool into the main tca module.
 *
 * Revision 1.5  1994/05/27  05:35:07  rich
 * Can now read from file that is being written to.
 * Fixed Menu and button names.
 * Fixed Indentation.
 * Added menu item to change orientation of the tree.
 *
 * Revision 1.4  1993/09/13  04:12:36  domingo
 * Added two set of options to the tree menu:
 *
 * - Erase queries (on/off) : activate/deactivate the deletion of queries
 *      from the task tree. Erase queries by default.
 *
 * - Display constraints (on/off) : activate/deactivate the display of
 *      constraints messages. No display by default.
 *
 * Revision 1.3  1993/09/07  00:24:53  domingo
 * Fixed almost all the warnings
 *
 * Revision 1.2  1993/08/13  02:09:35  domingo
 * Updated function declarations for compilation under gcc in ANSI C (still
 * a lot of warnings to fix).
 * Added automatic logging.
 *
 * Jan 11 1993 - Domingo Gallardo at School of Computer Science, CMU
 * Created.
 *
 *****************************************************************/

#include "tca/libc.h"
#include <X11/Xaw/Cardinals.h>

#include "tview.h"
#include "tools/Standard.h"
#include "tools/List.h"
#include "tools/Array.h"
#include "tools/MsgData.h"
#include "tools/TaskTree.h"
#include "tools/MsgData.h"
#include "tools/Parser.h"
#include "MDialog.h"
#include "Widgets.h"
#include "TreeGUI.h"
#include "Top.h"

Widget        top_level;
XtAppContext  app_con;

String fallback_resources[] = {
  "*shapeStyle:                      Rectangle",
  "*beNiceToColorMap:                False",
  "*input:                           True",
  "*Dialog*value.translations: #override \\n <Key>Return: OkDialog()",
  "*Paned.width:                     800",
  "*menuBox.preferredPaneSize:       30",
  "*porthole.preferredPaneSize:      250",
  "*porthole.showGrip:               False",
  "*porthole*font: -adobe-helvetica-medium-r-normal--*-120-*-*-*-*-iso*-*",
  "*commandBox.preferredPaneSize:    30",
  "*commandBox.max:                  30",
  "*commandBox.showGrip:             False",
  "*commandBox.taskInfo.font:  -adobe-helvetica-medium-r-normal--*-80-*-*-*-*-iso*-*",
  "*panner.preferredPaneSize:        40",
  "*panner.max:                      40",
  "*panner.showGrip:                 False",
  "*panner.backgroundStipple:        grid2",
  "*viewport.preferredPaneSize:      50",
  "*viewport.max:                    50",
  "*viewport.showGrip:               False",
  "*formList.max:                    90",
  "*formList.orientation:   	  vertical",
  "*list.font: -adobe-helvetica-medium-r-normal--*-120-*-*-*-*-iso*-*",
  "*List.height:                     60",
  "*List.max:                        60",
  NULL
};

XtActionsRec actionTable[] = {
  {"OkDialog", (XtActionProc) OkDialog}
};

/*****************************************************************************
 *
 * FUNCTION: void displayTviewVersion()
 *
 * DESCRIPTION: Displays the version information for the program.
 *
 * INPUTS: none.
 *
 * OUTPUTS: void
 *
 *****************************************************************************/

static void displayVersion(void)
{
  printf("tview %d.%d.%d (log parser %d.%d.%d)\n",
	 TVIEW_VERSION_MAJOR, TVIEW_VERSION_MINOR, TVIEW_VERSION_MICRO,
	 TPARSER_VERSION_MAJOR, TPARSER_VERSION_MINOR, TPARSER_VERSION_MICRO);
  printf(" Released : %s\n", TVIEW_VERSION_DATE);
  printf(" Commited : %s\n", TVIEW_COMMIT_DATE);
  printf(" Compiled : %s %s\n", __DATE__, __TIME__);
  fflush(stdout);
}

static void printHelp(void)
{
  printf("-h : Print this message\n");
  printf("-v : Print version information\n");
  printf("-f <logfile>: View the logfile\n");
  printf("-m : Display inform messages (default is not to display them)\n");
}

static void parseCommandLineOptions (int argc, char **argv)
{
  int i;

  for (i=1; i<argc; i++) {
    if (!strcmp(argv[i], "-h")) {
      printHelp();
      exit(0);
    } else if (!strcmp(argv[i], "-v")) {
      displayVersion();
      exit(0);
    } else if (!strcmp(argv[i], "-f")) {
      i++;
      if (!OpenFile(argv[i])) {
	fprintf(stderr, "File %s doesn't exist\n", argv[i]);
	exit(-1);
      }
    } else if (!strcmp(argv[i],"-m")) {
      _process_info_msg = TRUE;
    } else {
      fprintf(stderr, "Unknown option %s\n", argv[i]);
    }
  }
}

static void Initialize (void)
{
  TreeGuiInitialize();
  TaskTreeInitialize(0);
}

void main (int argc, char **argv)
{
  parseCommandLineOptions(argc, argv);

  top_level = XtAppInitialize(&app_con, "tview", NULL, ZERO,
			      &argc, argv, fallback_resources,
			      NULL, ZERO);

  XtAppAddActions(app_con, actionTable, XtNumber(actionTable));
  
  BuildWidgets(top_level);
  XtRealizeWidget(top_level);
  
  Initialize();
  
  XtAppMainLoop(app_con);
}
