/*
 * File: Widgets.c
 * Author: Domingo Gallardo, CMU
 * Purpose: Widgets builder
 *
 * REVISION HISTORY
 *
 * $Log: Widgets.c,v $
 * Revision 1.5  1996/02/29  15:21:00  reids
 * Ignore the MODULE_CONNECT and MODULE_DISCONNECT types.
 *
 * Revision 1.4  1996/02/13  21:31:58  rich
 * Fixed linux header problems.
 *
 * Revision 1.3  1996/02/07  15:40:03  reids
 * Cleaned up a bit of the code -- removing extraneous arguments, adding some
 *   "define"s for string constants.  Fixed the initialization of menu items so
 *   that their labels depend on global variables, rather than being hard-coded
 *
 * Revision 1.2  1995/04/07  05:07:45  rich
 * Fixed GNUmakefiles to find the release directory.
 * Fixed problems found by sgi cc compiler.  It would not compile.
 *
 * Revision 1.1  1995/04/05  18:32:27  rich
 * Moved tview files to a subdirectory.
 *
 * Revision 1.3  1995/01/25  00:04:40  rich
 * Release of tca 7.9.  Mostly speed improvements.
 * The cvs binaries may now be located in /usr/local.
 * Formatting changes.
 *
 * Revision 1.2  1994/11/02  21:39:10  rich
 * Now works for linux machines (i486).
 * Got afs to work on alpha (and hopefully other vendor OS's)
 * Added generic Makefile and asynchronous sender/receiver.
 * Renamed some X11 files and modified routines so we don't get library
 * conflicts.
 *
 * Revision 1.1  1994/05/31  03:26:43  rich
 * Moved Domingo's tview tool into the main tca module.
 *
 * Revision 1.5  1994/05/27  05:35:05  rich
 * Can now read from file that is being written to.
 * Fixed Menu and button names.
 * Fixed Indentation.
 * Added menu item to change orientation of the tree.
 *
 * Revision 1.4  1993/09/13  04:12:34  domingo
 * Added two set of options to the tree menu:
 *
 * - Erase queries (on/off) : activate/deactivate the deletion of queries
 *      from the task tree. Erase queries by default.
 *
 * - Display constraints (on/off) : activate/deactivate the display of
 *      constraints messages. No display by default.
 *
 * Revision 1.3  1993/09/07  00:24:52  domingo
 * Fixed almost all the warnings
 *
 * Revision 1.2  1993/08/13  02:09:33  domingo
 * Updated function declarations for compilation under gcc in ANSI C (still
 * a lot of warnings to fix).
 * Added automatic logging.
 *
 * Jan 11 1993 - Domingo Gallardo at School of Computer Science, CMU
 * Created.
 *
 */

#include "tca/libc.h"
#include <X11/Intrinsic.h>

#include <X11/Xaw/Box.h>	
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/MenuButton.h>	
#include <X11/Xaw/Label.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Paned.h>	
#include <X11/Xaw/SimpleMenu.h>	
#include <X11/Xaw/SmeBSB.h>	
#include <X11/Xaw/SmeLine.h>	
#include <X11/Xaw/Toggle.h>

#include <X11/Xaw/Porthole.h>	
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Tree.h>

#include "tcaPanner.h"
#include "MList.h"
#include "Widgets.h"
#include "Handler.h"
#include "TreeGUI.h"
#include "Top.h"

MList global_list;
Widget global_porthole, _msg_label;
Widget _layout, _refresh, _center, _erase_queries, _display_informs;
MDialog file_dialog, center_dialog, pause_when_dialog;

static void CreateFileMenu(Widget parent);
static void CreateTreeMenu(Widget parent);
static void CreateDialogs(Widget parent);


/*	Function Name: BuildWidgets
 *	Description: Creates all widgets for tcatool
 *	Arguments: parent - the shell to put them into.
 *	Returns: none.
 */

void BuildWidgets(Widget parent)
{
  Widget paned, box, panner, button, form;
  
  /* 
   *  Paned. Parent of the rest of widgets
   */
  paned = XtCreateManagedWidget("paned", panedWidgetClass, parent,
				NULL, ZERO);
  
  /* 
   *  Menus in a box
   */
  box = XtCreateManagedWidget("menuBox", boxWidgetClass, paned, NULL, ZERO);
  CreateFileMenu(box);
  CreateTreeMenu(box);
  
  /* 
   *  Porthole for tree 
   */
  global_porthole = XtCreateManagedWidget("porthole", portholeWidgetClass,
					  paned, NULL, ZERO);
  
  /* 
   *  Tree inside porthole 
   */
  
  CreateTree (global_porthole);
  
  /*
   *  Commands in a box
   */
  
  box = XtCreateManagedWidget("commandBox", boxWidgetClass, paned, NULL, ZERO);
  button = XtCreateManagedWidget("Step",commandWidgetClass,box, NULL, ZERO);
  XtAddCallback(button, XtNcallback, Step, NULL);
  button = XtCreateManagedWidget("...Paused",commandWidgetClass,box, NULL, 
				 ZERO);
  XtAddCallback(button, XtNcallback, PauseContinue, NULL);
  button = XtCreateManagedWidget("Pause when",commandWidgetClass,box, 
				 NULL, ZERO);
  XtAddCallback(button, XtNcallback, PauseWhen, NULL);
  
  /* 
   *  Panner to scroll the tree display area 
   */

  pannerWidgetClass = (WidgetClass) &tcaPannerClassRec;
  panner = XtCreateManagedWidget("panner", pannerWidgetClass, 
				 paned, NULL, ZERO);
  
  /*
   *  Allow the panner and porthole to talk to each other.
   */
  XtAddCallback(global_porthole, 
		XtNreportCallback, PortholeCallback, (XtPointer) panner);
  XtAddCallback(panner, 
		XtNreportCallback, PannerCallback, (XtPointer) global_porthole);
  
  /* 
   *  Messages area
   */
  
  form = XtCreateManagedWidget("formList", panedWidgetClass,
			       paned, NULL, ZERO);
  global_list = MListCreate(form);
  
  box = XtCreateManagedWidget("boxList", boxWidgetClass, form, NULL, ZERO);
  
  button = XtCreateManagedWidget("<<", commandWidgetClass, box, NULL, ZERO);
  XtAddCallback(button, XtNcallback, MessageMove, (XtPointer)-10);
  button = XtCreateManagedWidget(">>", commandWidgetClass, box, NULL, ZERO);
  XtAddCallback(button, XtNcallback, MessageMove, (XtPointer)10);
  _msg_label = XtCreateManagedWidget("Msg no: ", labelWidgetClass, box,
				     NULL, ZERO);
  
  CreateDialogs(parent);
}


/*	Function Name: CreateCommandMenu
 *	Description: Creats the command menu.
 *	Arguments: parent - widget to put this menu into.
 *	Returns: none.
 */

static void CreateFileMenu(Widget parent)
{
  Arg args[1];
  Widget menu, entry, button;
  
  XtSetArg(args[0], XtNmenuName, "FileMenu");
  button = XtCreateManagedWidget("File", menuButtonWidgetClass, parent,
				 args, ONE);
  menu = XtCreatePopupShell("FileMenu", simpleMenuWidgetClass, button,
			    NULL, ZERO);
  entry = XtCreateManagedWidget("Connect to file", smeBSBObjectClass, menu,
				NULL, ZERO);
  XtAddCallback(entry, XtNcallback, LoadFile, NULL);
  
  entry = XtCreateManagedWidget("Quit", smeBSBObjectClass, menu,
				NULL, ZERO);
  XtAddCallback(entry, XtNcallback, Quit, NULL);    
}

/*	Function Name: CreateTreeCommandMenu
 *	Description: Creats the command menu.
 *	Arguments: parent - widget to put this menu into.
 *	Returns: none.
 */

static void CreateTreeMenu(Widget parent)
{
  Arg args[1];
  Widget menu, button, entry;
  char *dispMsg;
  
  XtSetArg(args[0], XtNmenuName, "TreeMenu");
  button = XtCreateManagedWidget("Tree", menuButtonWidgetClass,
				 parent, args, ONE);
  menu = XtCreatePopupShell("TreeMenu", simpleMenuWidgetClass, button,
			    NULL, ZERO);
  
  dispMsg = (_tree_horizontal ? LAYOUT_HORIZONTAL_MSG : LAYOUT_VERTICAL_MSG);
  _layout = XtCreateManagedWidget(dispMsg, smeBSBObjectClass, menu, args, ONE);
  XtAddCallback(_layout, XtNcallback, layoutToggle, NULL);
  
  entry = XtCreateManagedWidget("line1", smeLineObjectClass, menu, NULL, ZERO);
  
  dispMsg = (global_display_tree ? AUTO_REFRESH_ON_MSG : AUTO_REFRESH_OFF_MSG);
  _refresh = XtCreateManagedWidget(dispMsg, smeBSBObjectClass, menu, args, ONE);
  XtAddCallback(_refresh, XtNcallback, AutoRefreshToggle, NULL);
  
  dispMsg = (isDisplayedInTaskTree(task_INFORM) ? 
	     INFORMS_ON_MSG : INFORMS_OFF_MSG);
  _display_informs = XtCreateManagedWidget(dispMsg, smeBSBObjectClass, menu,
					   NULL, ZERO);
  XtAddCallback(_display_informs, XtNcallback, 
		DisplayInformsToggle, NULL);
  
  dispMsg = (isDisplayedWhenFinished(task_QUERY)
	     ? ERASE_QUERIES_ON_MSG : ERASE_QUERIES_OFF_MSG);
  _erase_queries = XtCreateManagedWidget(dispMsg, smeBSBObjectClass, menu,
					 args, ONE);
  XtAddCallback(_erase_queries, XtNcallback, EraseQueriesToggle, NULL);
  
  dispMsg = (_center_tree ? AUTO_CENTER_ON_MSG : AUTO_CENTER_OFF_MSG);
  _center = XtCreateManagedWidget(dispMsg, smeBSBObjectClass, menu, NULL, ZERO);
  XtAddCallback(_center, XtNcallback, AutoCenterToggle, NULL);
  
  entry = XtCreateManagedWidget("line2", smeLineObjectClass, menu,
				NULL, ZERO);
  
  entry = XtCreateManagedWidget("Refresh", smeBSBObjectClass, menu,
				NULL, ZERO);
  
  XtAddCallback(entry, XtNcallback, TreeRefresh, NULL);
  entry = XtCreateManagedWidget("Center in task", smeBSBObjectClass, menu,
				NULL, ZERO);
  XtAddCallback(entry, XtNcallback, CenterInTask, NULL); 
}


static void CreateDialogs(Widget parent)
{
  file_dialog = (MDialog)malloc(sizeof(_MDialog));
  DialogInitStrings(file_dialog, "Introduce log file's name: ", 
		    "File doesn't exist!", "");
  DialogInitFuncs(file_dialog, OpenFile, (StrFunction)OpenFile,
		  (DIALOG_FUNCTION_TYPE)NULL, NULL);
  DialogCreate(file_dialog, parent, TRANSIENT, NULL);
  
  pause_when_dialog = (MDialog)malloc(sizeof(_MDialog));
  DialogInitStrings(pause_when_dialog,
		    "Introduce condition \n(TaskName [TaskId] [SENT]) ", 
		    NULL, NULL);
  DialogInitFuncs(pause_when_dialog, NULL, ProcessCondition, NULL, NULL);
  DialogCreate(pause_when_dialog, parent, TRANSIENT, NULL);
  
  center_dialog = (MDialog)malloc(sizeof(_MDialog));
  DialogInitStrings(center_dialog, "Introduce message's name: ", NULL, NULL);
  DialogInitFuncs(center_dialog, (BOOLEAN (*)(char *))CenterTreeName,
		  NULL, NULL, NULL);
  DialogCreate(center_dialog, parent, TRANSIENT, NULL);
}



