/*
 * File: TreeGUI.h
 * Author: Domingo Gallardo, CMU
 * Purpose: Graphical User Interface for the task tree
 *
 * REVISION HISTORY
 *
 * $Log: TreeGUI.h,v $
 * Revision 1.6  1996/08/05  16:09:06  rich
 * Added comments to endifs.
 *
 * Revision 1.5  1996/02/07  15:40:02  reids
 * Cleaned up a bit of the code -- removing extraneous arguments, adding some
 *   "define"s for string constants.  Fixed the initialization of menu items so
 *   that their labels depend on global variables, rather than being hard-coded
 *
 * Revision 1.4  1995/12/15  01:26:32  rich
 * Fixed the includes.
 *
 * Revision 1.3  1995/04/10  14:25:20  reids
 * Changed colors for the task states, and added support for statically
 * linked versions of tview.
 *
 * Revision 1.2  1995/04/07  05:07:44  rich
 * Fixed GNUmakefiles to find the release directory.
 * Fixed problems found by sgi cc compiler.  It would not compile.
 *
 * Revision 1.1  1995/04/05  18:32:26  rich
 * Moved tview files to a subdirectory.
 *
 * Revision 1.1  1994/05/31  03:26:41  rich
 * Moved Domingo's tview tool into the main tca module.
 *
 * Revision 1.4  1994/05/27  05:33:35  rich
 * Can now read from file that is being written to.
 * Fixed Menu and button names.
 * Fixed Indentation.
 * Added menu item to change orientation of the tree.
 *
 * Revision 1.3  1993/09/13  04:14:27  domingo
 *  Added two set of options to the tree menu:
 *
 *  - Erase queries (on/off) : activate/deactivate the deletion of queries
 *       from the task tree. Erase queries by default.
 *
 *  - Display constraints (on/off) : activate/deactivate the display of
 *       constraints messages. No display by default.
 *
 * Revision 1.2  1993/08/13  01:43:19  domingo
 * Updated function declarations for compilation under gcc in ANSI C (still
 * a lot of warnings to fix).
 * Added automatic logging.
 *
 *
 * Jan 11 1993 - Domingo Gallardo at School of Computer Science, CMU
 * Created.
 *
 */

#ifndef _TREEGUI_H
#define _TREEGUI_H

#include "tools/Standard.h"
#include "tools/List.h"
#include "tools/Array.h"
#include "tools/MsgData.h"
#include "tools/TaskTree.h"
#include <X11/Intrinsic.h>

#define ACTIVE_TASK_COLOR    "green"
#define DEFAULT_TASK_COLOR   "turquoise"
#define ON_HOLD_TASK_COLOR   "white"
#define KILLED_TASK_COLOR    "light slate gray"
#define PENDING_TASK_COLOR   "orange"
#define WAITING_TASK_COLOR   "yellow"
#define COMPLETED_TASK_COLOR "salmon1"
#define WILL_BE_KILLED_TASK_COLOR "purple"

#define GUI_TASK_DATA(task) ((GUI_Task_Additional)(task->additional))

typedef struct { BOOLEAN   expanded;          /* Label description in widget */
		 Widget widget;
		 Widget expanded_widget;
	       } _GUI_Task_Additional, *GUI_Task_Additional;

typedef struct _DisplayFlag {
  taskType type;
  BOOLEAN     flag;
} _DisplayFlag;


extern Widget global_tree_widget;
extern BOOLEAN   global_tree_modified;
extern BOOLEAN   global_display_tree;
extern BOOLEAN   _center_tree;
extern BOOLEAN   _tree_horizontal;

extern _DisplayFlag  task_display_flag_table[MAX_TASK_TYPES];
extern _DisplayFlag  task_display_when_finished[MAX_TASK_TYPES];

void TreeGuiInitialize(void);
void DisplayWhenFinished(taskType task_type, BOOLEAN flag);
BOOLEAN isDisplayedWhenFinished(taskType task_type);
void DisplayInTaskTree(taskType task_type, BOOLEAN flag);
BOOLEAN isDisplayedInTaskTree(taskType task_type);
void CreateTree(Widget widget_parent);
void TreeRefresh(Widget w, XtPointer client_data, XtPointer call_data);
void CenterTreeName(char *task_name);
void CenterTree(Task task);

#endif /* _TREEGUI_H */
