
/*
 * File: MList.h
 * Author: Domingo Gallardo, CMU
 * Purpose: Implementation of module that manages xwindow lists
 * 
 *
 * REVISION HISTORY
 *
 * $Log: MList.h,v $
 * Revision 1.5  1996/08/05  16:09:04  rich
 * Added comments to endifs.
 *
 * Revision 1.4  1995/12/15  01:26:29  rich
 * Fixed the includes.
 *
 * Revision 1.3  1995/05/31  21:00:12  rich
 * Fixed conflict with tca declarations.
 *
 * Revision 1.2  1995/04/07  05:07:36  rich
 * Fixed GNUmakefiles to find the release directory.
 * Fixed problems found by sgi cc compiler.  It would not compile.
 *
 * Revision 1.1  1995/04/05  18:32:12  rich
 * Moved tview files to a subdirectory.
 *
 * Revision 1.2  1995/01/25  00:04:17  rich
 * Release of tca 7.9.  Mostly speed improvements.
 * The cvs binaries may now be located in /usr/local.
 * Formatting changes.
 *
 * Revision 1.1  1994/05/31  03:26:07  rich
 * Moved Domingo's tview tool into the main tca module.
 *
 * Revision 1.4  1994/05/27  05:33:15  rich
 * Can now read from file that is being written to.
 * Fixed Menu and button names.
 * Fixed Indentation.
 * Added menu item to change orientation of the tree.
 *
 * Revision 1.3  1993/09/07  00:26:53  domingo
 * Deleted files Reports.h Tree.h TreeP.h (they are not part of the
 * program)
 * Almost fixed all the warnings
 *
 * Revision 1.2  1993/08/13  01:43:03  domingo
 * Updated function declarations for compilation under gcc in ANSI C (still
 * a lot of warnings to fix).
 * Added automatic logging.
 *
 *
 * Dec 23 1992 - Domingo Gallardo at School of Computer Science, CMU
 * Created.
 *
 */

#ifndef _MLIST_H
#define _MLIST_H

#include "tools/Standard.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/List.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Scrollbar.h>

typedef void 
(*VoidFunction)(void);

typedef void 
(*StrFunction)(char *);

typedef struct _MList {
  String *strings;
  StrFunction *funcs;
  int num_items;
  int allocated_items;
  Widget widget;
  Widget viewport;
} _MList, *MList;


MList MListCreate(Widget parent);
int MListAddItem(MList list, 
		 String item, 
		 StrFunction func_callback,
		 BOOLEAN display);
int MListRefresh(MList list);
int MListJump(MList list, int num);

     
#endif /* _MLIST_H */
