
/*
 * File: MDialog.h
 * Author: Domingo Gallardo, CMU
 * Purpose: Implementation of module that manages dialogs
 * 
 *
 * REVISION HISTORY
 *
 * $Log: MDialog.h,v $
 * Revision 1.5  1996/08/05  16:09:02  rich
 * Added comments to endifs.
 *
 * Revision 1.4  1995/12/15  01:26:28  rich
 * Fixed the includes.
 *
 * Revision 1.3  1995/05/31  21:00:10  rich
 * Fixed conflict with tca declarations.
 *
 * Revision 1.2  1995/04/07  05:07:33  rich
 * Fixed GNUmakefiles to find the release directory.
 * Fixed problems found by sgi cc compiler.  It would not compile.
 *
 * Revision 1.1  1995/04/05  18:32:09  rich
 * Moved tview files to a subdirectory.
 *
 * Revision 1.2  1995/01/25  00:04:13  rich
 * Release of tca 7.9.  Mostly speed improvements.
 * The cvs binaries may now be located in /usr/local.
 * Formatting changes.
 *
 * Revision 1.1  1994/05/31  03:26:02  rich
 * Moved Domingo's tview tool into the main tca module.
 *
 * Revision 1.4  1994/05/27  05:33:13  rich
 * Can now read from file that is being written to.
 * Fixed Menu and button names.
 * Fixed Indentation.
 * Added menu item to change orientation of the tree.
 *
 * Revision 1.3  1993/09/07  00:26:51  domingo
 * Deleted files Reports.h Tree.h TreeP.h (they are not part of the
 * program)
 * Almost fixed all the warnings
 *
 * Revision 1.2  1993/08/13  01:43:01  domingo
 * Updated function declarations for compilation under gcc in ANSI C (still
 * a lot of warnings to fix).
 * Added automatic logging.
 *
 *
 * Dec 23 1992 - Domingo Gallardo at School of Computer Science, CMU
 * Created.
 *
 */


#ifndef _MDIALOG_H
#define _MDIALOG_H

#include "tools/Standard.h"
#include "MList.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Dialog.h>

#define TOP_LEVEL 1
#define TRANSIENT 2

typedef void 
(*DIALOG_FUNCTION_TYPE)(char *);

typedef struct _MDialog {
  String header;
  String error_msg;
  String last_value;
  BOOLEAN   (*test_function)(char *);  /* may be NULL */
  DIALOG_FUNCTION_TYPE ok_function;
  DIALOG_FUNCTION_TYPE error_function; /* may be NULL */
  DIALOG_FUNCTION_TYPE cancel_function; /* may be NULL */
  Widget widget;
  Widget popup;
} _MDialog, *MDialog;


void DialogInitStrings(MDialog dialog, String header, 
		       String error_msg, String default_value);
void DialogInitFuncs(MDialog dialog, BOOLEAN (*test)(char *), 
		     DIALOG_FUNCTION_TYPE ok, DIALOG_FUNCTION_TYPE error, 
		     DIALOG_FUNCTION_TYPE cancel);
void DialogCreate(MDialog dialog, Widget parent, int type, String name);
void DialogFire(MDialog dialog, BOOLEAN use_last_value);
void OkDialog(Widget widget, XEvent event, String params, Cardinal num_params);


#endif /* _MDIALOG_H */
