/*
 * File: Handler.c
 * Author: Domingo Gallardo, CMU
 * Purpose: Handlers for X events 
 *
 * REVISION HISTORY
 *
 * $Log: Handler.c,v $
 * Revision 1.6  1996/05/07  16:51:49  rich
 * Changes for clisp.
 *
 * Revision 1.5  1996/02/29  15:19:44  reids
 * Fixed the "paused"/"running" button to start immediately when pressed.
 *
 * Revision 1.4  1996/02/07  15:39:55  reids
 * Cleaned up a bit of the code -- removing extraneous arguments, adding some
 *   "define"s for string constants.  Fixed the initialization of menu items so
 *   that their labels depend on global variables, rather than being hard-coded
 *
 * Revision 1.3  1995/12/15  01:26:26  rich
 * Fixed the includes.
 *
 * Revision 1.2  1995/04/07  05:07:30  rich
 * Fixed GNUmakefiles to find the release directory.
 * Fixed problems found by sgi cc compiler.  It would not compile.
 *
 * Revision 1.1  1995/04/05  18:31:55  rich
 * Moved tview files to a subdirectory.
 *
 * Revision 1.1  1994/05/31  03:25:53  rich
 * Moved Domingo's tview tool into the main tca module.
 *
 * Revision 1.5  1994/05/27  05:34:34  rich
 * Can now read from file that is being written to.
 * Fixed Menu and button names.
 * Fixed Indentation.
 * Added menu item to change orientation of the tree.
 *
 * Revision 1.4  1993/09/13  04:12:24  domingo
 * Added two set of options to the tree menu:
 *
 * - Erase queries (on/off) : activate/deactivate the deletion of queries
 *      from the task tree. Erase queries by default.
 *
 * - Display constraints (on/off) : activate/deactivate the display of
 *      constraints messages. No display by default.
 *
 * Revision 1.3  1993/09/07  00:24:31  domingo
 * Fixed almost all the warnings
 *
 * Revision 1.2  1993/08/13  02:09:10  domingo
 * Updated function declarations for compilation under gcc in ANSI C (still
 * a lot of warnings to fix).
 * Added automatic logging.
 *
 *
 * Jan 11 1993 - Domingo Gallardo at School of Computer Science, CMU
 * Created.
 *
 */

#include "tools/Standard.h"
#include "tools/MsgData.h"
#include "tools/MyString.h"
#include "tools/MsgData.h"
#include "tools/Parser.h"

#include "Handler.h"
#include "Widgets.h"
#include "Top.h"
#include "TreeGUI.h"

#include <X11/Intrinsic.h>
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Tree.h>

static msgStatus ParseStatus(String msg);

/*	Function Name: Quit
 *	Description: Destroy application.
 *	Arguments: w - ** UNUSED **
 *                 call_data - ** UNUSED **
 *                 client_data - ** UNUSED **
 *	Returns: none
 */

void Quit(Widget w, XtPointer client_data, XtPointer call_data)
{
  fclose(global_log_file);
  exit(0);
}


void LoadFile(Widget w, XtPointer client_data, XtPointer call_data)
{
  BOOLEAN use_last_value = True;
  
  DialogFire(file_dialog, use_last_value);
}

void layoutToggle(Widget w, XtPointer client_data, XtPointer call_data)
{
  Arg args[1];
  
  _tree_horizontal = !_tree_horizontal;
  
  XtSetArg(args[0], XtNlabel, 
	   (_tree_horizontal ? LAYOUT_HORIZONTAL_MSG : LAYOUT_VERTICAL_MSG));
  XtSetValues(w, args, ONE);
  XtSetArg(args[0], XtNgravity,(_tree_horizontal ? NorthGravity : WestGravity));
  XtSetValues(global_tree_widget, args, ONE);
}

void AutoRefreshToggle(Widget w, XtPointer client_data, XtPointer call_data)
{
  Arg args[1];
  
  global_display_tree = !global_display_tree;

  XtSetArg(args[0], XtNlabel,
	   (global_display_tree ? AUTO_REFRESH_ON_MSG : AUTO_REFRESH_OFF_MSG));
  XtSetValues(w, args, ONE);
}

void EraseQueriesToggle(Widget w, XtPointer client_data, XtPointer call_data)
{
  Arg args[1];
  BOOLEAN newValue;
  
  newValue = !isDisplayedWhenFinished(task_QUERY);
  
  DisplayWhenFinished(task_QUERY, newValue);

  XtSetArg(args[0], XtNlabel,
	   (newValue ? ERASE_QUERIES_ON_MSG : ERASE_QUERIES_OFF_MSG));
  XtSetValues(w, args, ONE);
}

void DisplayInformsToggle(Widget w, XtPointer client_data, XtPointer call_data)
{
  Arg args[1];
  BOOLEAN newValue;
  
  newValue = !isDisplayedInTaskTree(task_INFORM);
  
  DisplayInTaskTree(task_INFORM, newValue);
  XtSetArg(args[0], XtNlabel, (newValue ? INFORMS_ON_MSG : INFORMS_OFF_MSG));
  XtSetValues(w, args, ONE);
}


void AutoCenterToggle(Widget w, XtPointer client_data, XtPointer call_data)
{
  Arg args[1];
  
  _center_tree = !_center_tree;
  
  XtSetArg(args[0], XtNlabel, 
	   (_center_tree ? AUTO_CENTER_ON_MSG : AUTO_CENTER_OFF_MSG));
  XtSetValues(w, args, ONE);
}

void CenterInTask(Widget w, XtPointer client_data, XtPointer call_data)
{
  BOOLEAN use_last_value = True;
  
  DialogFire(center_dialog, use_last_value);
}


void Restart(Widget w, XtPointer call_data, XtPointer client_data)
{
}

void PauseWhen(Widget w, XtPointer client_data, XtPointer call_data)
{
  BOOLEAN use_last_value = True;
  
  DialogFire(pause_when_dialog, use_last_value);
}

void PauseContinue(Widget w, XtPointer client_data, XtPointer call_data)
{
  Arg args[10];
  
  _pause = !_pause;
  
  if (! _pause) SetNextStep();

  XtSetArg(args[0], XtNlabel, (_pause ? PAUSED_MSG : RUNNING_MSG));
  XtSetValues(w, args, ONE);
}

static void PushInMessage(char *message)
{
  MsgData msgData;
  Task task;
  BOOLEAN aux;
  
  /* skip five spaces */
  message += 5;
  msgData = ParseMsg(message);
  task = FindTask(msgData->name, msgData->id, (taskState) task_NULL);
  if (task) {
    aux = _center_tree;
    _center_tree = True;
    CenterTree(task);
    _center_tree = aux;
  }
}


void PortholeCallback(Widget w, XtPointer panner_ptr, XtPointer report_ptr)
{
  Arg args[10];
  Cardinal n = 0;
  XawPannerReport *report = (XawPannerReport *) report_ptr;
  Widget panner = (Widget) panner_ptr;
  
  
  XtSetArg (args[n], XtNsliderX, report->slider_x); n++;
  XtSetArg (args[n], XtNsliderY, report->slider_y); n++;
  if (report->changed != (XawPRSliderX | XawPRSliderY)) {
    XtSetArg (args[n], XtNsliderWidth, report->slider_width); n++;
    XtSetArg (args[n], XtNsliderHeight, report->slider_height); n++;
    XtSetArg (args[n], XtNcanvasWidth, report->canvas_width); n++;
    XtSetArg (args[n], XtNcanvasHeight, report->canvas_height); n++;
  }
  XtSetValues (panner, args, n);
  
}


/*	Function Name: PannerCallback
 *	Description: called when the panner has moved.
 *	Arguments: panner - the panner widget.
 *                 client_data - *** NOT USED ***.
 *                 report_ptr - the panner record.
 *	Returns: none.
 */

void PannerCallback(Widget  w, XtPointer client_data, XtPointer report_ptr)
{
  Arg args[2];
  XawPannerReport *report = (XawPannerReport *) report_ptr;
  
  XtSetArg (args[0], XtNx, -report->slider_x);
  XtSetArg (args[1], XtNy, -report->slider_y);
  
  XtSetValues(global_tree_widget, args, TWO);
}


void Step(Widget widget, XtPointer client_data, XtPointer call_data)
{
  static char buffer_char[600];
  static char buffer2[40];
  char msg[MAX_LONG_MESSAGE];
  Arg args[1];
  int n_msg;
  
  if (OneStepFromFile(global_log_file, msg)) {
    strcpy(buffer_char, "     ");
    strncat(buffer_char, msg,600-1-strlen(buffer_char));
    n_msg = MListAddItem(global_list, buffer_char,
			 (StrFunction)PushInMessage, True);
    sprintf(buffer2, "Msg no: %d", n_msg);
    XtSetArg(args[0], XtNlabel, buffer2);
    XtSetValues(_msg_label, args, 1);
  }
}

void MessageMove(Widget widget, XtPointer client_data, XtPointer call_data)
{
  int num;
  int n_msg;
  Arg args[1];
  char buffer2[40];
  
  num = (int) client_data;
  n_msg = MListJump(global_list, num);
  sprintf(buffer2, "Msg no: %d", n_msg);
  XtSetArg(args[0], XtNlabel, buffer2);
  XtSetValues(_msg_label, args, 1);
}

void ProcessCondition(String condition)
{ 
  
  _pause_condition.active = True;
  _pause_condition.name = DupUntil(condition, ' ');
  if (StringEqual(_pause_condition.name, ""))
    /* only the name is defined */
    _pause_condition.name = strdup(condition);
  else {
    condition = SkipUntilSubString(condition, " ");
    condition = SkipUntilSubString(condition, "(");
    if (*(condition-1) == '(') {
      sscanf(condition, "(%d", &_pause_condition.id);
      condition = SkipUntilSubString(condition, ")");
      condition++;
    }
    else
      _pause_condition.id = -1;
    _pause_condition.status = ParseStatus(condition);
  }
  SetNextStep();
  _pause = False;
}


static msgStatus ParseStatus(String msg)
{
  
  static _msgStatusRec status_table[] = {
    {"Sent",          SENT},
    {"Pending",       PENDING},
    {"Inactive",      INACTIVE},
    {"Completed",     COMPLETED},
    {"Created",       STATUS_NULL},
  };
  
  int index;
  String aux_msg;
  
  msg = SkipSpaces(msg);
  aux_msg = msg;
  for (index = 0; index < sizeArray(status_table, _msgStatusRec); index++)
    if (BeginsWith(aux_msg, status_table[index].string)) {
      msg = msg + strlen(status_table[index].string) + 1;
      return(status_table[index].type);
    }
  return (STATUS_NULL);
}
