/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: runControl.c
 *
 * ABSTRACT:
 *
 * stole from xconsole the ability to create widgets for the management of the
 * text - this stops us having to deal with several screens...
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/xtUtil.h,v $
 * $Revision: 1.3 $
 * $Date: 1996/08/05 16:08:18 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: xtUtil.h,v $
 * Revision 1.3  1996/08/05  16:08:18  rich
 * Added comments to endifs.
 *
 * Revision 1.2  1996/03/29  15:57:51  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *   xRunConsole and xfRunConsole.
 * Added a way to add macro definitions to resource files ("define: <x> <y>").
 * Fixed a bug that was causing the xfRunConsole to crash when a task was
 *   restarted.
 *
 * Revision 1.1  1995/12/17  20:26:06  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.7  1995/07/13  11:10:00  josullvn
 * Two bugs were present. a) syscalls were being interrupted, and b) the
 * processes button management got screwy after a while. The first is due
 * to Devutils, second fixed by removing a reliance on xclient data. Also
 * added features to newProcess whereby it is now menu driven.
 * Added tca.rc, removing those processes from the Simulator resource files.
 *
 * Revision 1.6  1995/07/04  05:46:42  josullvn
 * The latest update. Some stuff vanished (???), but recovered a bit.
 * Now have improved notification of whats happening between runConsole
 * and nanny, and better starting off of processes.
 *
 * Revision 1.5  1995/06/25  01:03:54  rich
 * Moved devUtils to tca.
 *
 * Revision 1.4  1995/05/15  17:07:43  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 * fs checkservers
 *****************************************************************************/
#ifndef XTUTIL_H_INCLUDED
#define XTUTIL_H_INCLUDED
#include "tca/libc.h"

#include "tca/ezx.h"

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/cursorfont.h>
#include <X11/Xatom.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

Widget MakeCommandButton(Widget box, char *name, XtCallbackProc function);
Widget MakeStringBox(Widget parent, String name, String string);
String GetString(Widget w);

#endif /* XTUTIL_H_INCLUDED */
