
/* $XConsortium: util.c,v 1.16 92/08/12 16:46:22 converse Exp $ */

/*
 *			  COPYRIGHT 1987
 *		   DIGITAL EQUIPMENT CORPORATION
 *		       MAYNARD, MASSACHUSETTS
 *			ALL RIGHTS RESERVED.
 *
 * THE INFORMATION IN THIS SOFTWARE IS SUBJECT TO CHANGE WITHOUT NOTICE AND
 * SHOULD NOT BE CONSTRUED AS A COMMITMENT BY DIGITAL EQUIPMENT CORPORATION.
 * DIGITAL MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR
 * ANY PURPOSE.  IT IS SUPPLIED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY.
 *
 * IF THE SOFTWARE IS MODIFIED IN A MANNER CREATING DERIVATIVE COPYRIGHT RIGHTS,
 * APPROPRIATE LEGENDS MAY BE PLACED ON THE DERIVATIVE WORK IN ADDITION TO THAT
 * SET FORTH ABOVE.
 *
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Digital Equipment Corporation not be 
 * used in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 */
#include "tca/libc.h"

#include "xtUtil.h"
#include "xRunConsole.h"
#include "xCallbacks.h"

#include <X11/Xos.h>		/* for types.h */
#include <X11/Xaw/Command.h>
#include <sys/stat.h>

void MessagePrintf(char * str)
{
  XawTextBlock text;
  Arg arg; 
  static XawTextPosition pos = 0;

  text.length = strlen(str);
  text.ptr = str;
  text.firstPos = 0;
  text.format = FMT8BIT;

  {
    /* Make the widget writeable */
    XtSetArg(arg, XtNeditType, XawtextAppend); 
    XtSetValues (messwidget, &arg, ONE);
  }

  XawTextReplace( messwidget, pos, pos, &text);

  pos += text.length;
  XawTextSetInsertionPoint(messwidget, 
			   MIN(pos,TextLength(messwidget)));

  {
    /* Make the widget back to just readable */
    XtSetArg(arg, XtNeditType, XawtextRead);
    XtSetValues (messwidget, &arg, ONE);
  }
}

Widget MakeCommandButton(Widget box, char *name, XtCallbackProc function)
{
  Widget w = XtVaCreateManagedWidget(name, commandWidgetClass, box, 
/*				     XtNshapeStyle, XawShapeRoundedRectangle,*/
/*				     XtNhighlightThickness, 2,*/
/*				     XtCShapeStyle, XawShapeRoundedRectangle,*/
/*				     XtRShapeStyle, XawShapeRoundedRectangle,*/
				     NULL);
  if (function != NULL)
    XtAddCallback(w, XtNcallback, function, (XtPointer) name);
  return w;
}

Widget MakeStringBox(Widget parent, String name, String string)
{
  Arg args[5];
  Cardinal numargs = 0;
  Widget StringW;

  XtSetArg(args[numargs], XtNeditType, XawtextEdit); numargs++;
  XtSetArg(args[numargs], XtNstring, string); numargs++;

  StringW = XtCreateManagedWidget(name, asciiTextWidgetClass, 
				  parent, args, numargs);
  return(StringW);  
}
 
/*	Function Name: GetString
 *	Description: retrieves the string from a asciiText widget.
 *	Arguments: w - the ascii text widget.
 *	Returns: the filename.
 */
String GetString(Widget w)
{
  String str;
  Arg arglist[1];
  
  XtSetArg(arglist[0], XtNstring, &str);
  XtGetValues( w, arglist, ONE);
  return(str);
}

/*	Function Name: Feep
 *	Description: feeps the bell.
 *	Arguments: none.
 *	Returns: none.
 */

void Feep(void)
{
  XBell(CurDpy, 0);
}


void WFlush(void)
{
  XFlush(CurDpy);
}

