/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: runConsole.h
 *
 * ABSTRACT:
 *
 * stole from xconsole the ability to create widgets for the management of the
 * text - this stops us having to deal with several screens...
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/xfRunMiniConsole.h,v $
 * $Revision: 1.1 $
 * $Date: 1996/07/29 05:03:30 $
 * $Author: josullvn $
 *
 * REVISION HISTORY:
 *
 * $Log: xfRunMiniConsole.h,v $
 * Revision 1.1  1996/07/29  05:03:30  josullvn
 * Bloody hell. This commiting is a bit different than under Xavier. Short
 * story is cleaned up some purify bugs, and also made changes to nanny
 * which should make it a bit better - Improving performance over multiple
 * machines, explict quietening of nondisplayed processes, replacing of
 * runConsole with xfMiniConsole, which is multithreaded, vt102 compilant,
 * adds a uniform emacs-like command line editing feature, better on small
 * screens and otherwise fab.
 *
 * Revision 1.2  1996/03/29  15:57:47  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *   xRunConsole and xfRunConsole.
 * Added a way to add macro definitions to resource files ("define: <x> <y>").
 * Fixed a bug that was causing the xfRunConsole to crash when a task was
 *   restarted.
 *
 * Revision 1.1  1996/02/20  11:40:48  josullvn
 * Made extensive changes:
 *    added xfRunConsole, an xforms based interface which was quick
 *    To change the interface, from the nanny dir run
 *    /afs/cs/user/josullvn/xforms/DESIGN/fdesign xfConsole
 *    to get going, and made debugging easier.
 *    added tons of comments.
 *    Debug spews a lot more info back, so just compile
 *    with DEBUG=DEBUG if you really need it.
 *    I've added some timeouts to the code, which will
 *    probably be tweaked later. There are in xfCallbacks.c
 *    Its become better at keeping processes going, and
 *    so its harder to quit. Using shutdown can be
 *    painful. Killing the processes individually is
 *    probably better. Need to do a reverse dependancy when quitting.
 *    Multiple machines are again poor. It doesn't wait sufficently
 *    for dependencies - so you need to run things explicitly...
 *
 * Revision 1.5  1996/02/01  04:04:18  rich
 * Generalized updateVersion and added recursion.
 *
 * Revision 1.4  1996/02/01  02:03:23  reids
 * Cleaned up/standardized command line option parsing and help messages.
 *
 * Revision 1.3  1996/01/31  22:51:58  reids
 * Added automatic updating of (micro) version control numbers
 *
 * Revision 1.2  1996/01/22  21:31:15  reids
 * Fixed the way stdout is handled, using pseudo-terminals, so that it preserves
 *   the line-buffering mode of the real TTY.
 * Added support for running scripts (not really integrated, yet, but initial
 *   tests are working).
 *
 * Revision 1.1  1995/12/17  20:25:57  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.7  1995/07/15  07:13:22  josullvn
 * ProcessDevices is _not_ reentrant - this was causing lots of problems as it
 * turns out. Restructing my blocking code fixed it.
 * Also, added a notion of dead - that is telling when something has
 * finally died.
 *
 * Revision 1.6  1995/07/13  17:04:44  josullvn
 * Added version info
 *
 * Revision 1.5  1995/07/11  01:06:40  josullvn
 * Whesh. OK, fixed a bug in parsing lines, where by if messages get corrupted,
 * we can recover. Added a -clean option to nanny. Discovered that the old
 * double newProcess bug has returned to haunt me.
 *
 * Revision 1.4  1995/05/15  17:07:29  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 * fs checkservers
 *****************************************************************************/
#ifndef XFRUNCONSOLE_H_INCLUDED
#define XFRUNCONSOLE_H_INCLUDED

#include "forms.h"
#include "xfMiniConsole.h"

extern void ProcessXFHandler(Pointer call_back, Pointer client_data);

FD_xfMiniConsole *xfConsole;

typedef struct _CONSOLE_GRAPHICS {
  FL_OBJECT        *button;
} CONSOLE_GRAPHICS_TYPE, *CONSOLE_GRAPHICS_PTR;

void close_xterm();
extern int      xterm_socket;
extern DEV_PTR  xterm_device;
void inputCallback(int fd, long chars_available);

#include "runConsole.h"

#endif
