/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: xfRunConsole.c
 *
 * ABSTRACT:
 *
 * Arrrgh. Couldn't stand runConsole. Rewrote, and simplfied.
 * use fdesign to redesign
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/xfRunMiniConsole.c,v $
 * $Revision: 1.1 $
 * $Date: 1996/07/29 05:03:28 $
 * $Author: josullvn $
 *
 * REVISION HISTORY:
 * $Log: xfRunMiniConsole.c,v $
 * Revision 1.1  1996/07/29  05:03:28  josullvn
 * Bloody hell. This commiting is a bit different than under Xavier. Short
 * story is cleaned up some purify bugs, and also made changes to nanny
 * which should make it a bit better - Improving performance over multiple
 * machines, explict quietening of nondisplayed processes, replacing of
 * runConsole with xfMiniConsole, which is multithreaded, vt102 compilant,
 * adds a uniform emacs-like command line editing feature, better on small
 * screens and otherwise fab.
 *
 * Revision 1.4  1996/06/28  14:07:43  reids
 * Fixed quite a few bugs -- with graphics, interaction with script, and
 *   killing processes
 *
 * Revision 1.3  1996/03/29  15:57:45  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *   xRunConsole and xfRunConsole.
 * Added a way to add macro definitions to resource files ("define: <x> <y>").
 * Fixed a bug that was causing the xfRunConsole to crash when a task was
 *   restarted.
 *
 *****************************************************************************/
#include "tca/libc.h"
#include "tca/stdinDev.h"

#include "xfRunMiniConsole.h"
#include "callbacks.h"
#include "messages.h"

int     xterm_socket = -1;
int     xterm_pid;
DEV_PTR xterm_device = NULL;


/* DESCRIPTION:
 * 
 * Now create an xterm for program display. Use cat of a socket to 
 * write data to that xterm, use bin/readline to read users input
 * 
 * PRECONDS:
 *
 * POSTCONDS:
 * 
 */
int xterm_comm_socket(struct sockaddr *name)
{
  int  s; 

  if ((s = socket(PF_UNIX,SOCK_STREAM,0)) == -1) {
    perror("socket");
    exit(1);
  }

  if (bind(s,name,sizeof(* name)) == -1) {
    perror("bind");
    exit(1);
  }

  /* backlogs?  one client at a time, so no pending connections */
  if (listen(s,0) == -1) {
    perror("listen");
    exit(1);
  }

  return s;
}


/* DESCRIPTION:
 * 
 * PRECONDS:
 *
 * POSTCONDS:
 * 
 */
void close_xterm()
{
  char   name[14];  /* This is all the bytes we get... */
  int    pid;

  pid = getpid();
  sprintf(name,"/tmp/.xc%d", pid);
  unlink(name);
  kill (xterm_pid, 9);
}

/* DESCRIPTION: 
 * 
 * PRECONDS:
 * 
 * POSTCONDS:
 *  
 */
void mungeReadlineBinary(char *binary, char *argv0)
{
  int i,fd;
  BOOLEAN dirPresent=FALSE;
  char *lastLoc = binary;
  struct stat   buf;

  strcpy(binary, argv0);
  for (i=0; i<strlen(binary); i++)
    if (binary[i] == '/') {
      dirPresent = TRUE;
      lastLoc = &(binary[i]);
     }

  if (dirPresent) {
    lastLoc[1]='\0';
    strcat(binary,"readline");
  } else 
    /* If the filename used as argv[0] does not contain directory information,
     * then readline must be in the path...
     */
    strcpy(binary,"readline");

  if (stat(binary, &buf) == -1)
    {
      fprintf(stderr, "'readline' not found\n");
      fprintf(stderr, "must be at the same location as %s\n",argv0);
      exit (-1);
    }

  if (!(buf.st_mode & S_IXUSR))
    {
      fprintf(stderr, "%s not executable\n", binary);
      exit (-1);
    }
}

/* DESCRIPTION:
 * 
 * Now create an xterm for program display. Use cat of a socket to 
 * write data to that xterm, use bin/readline to read users input
 * 
 * PRECONDS:
 *
 * POSTCONDS:
 */
int spawn_xterm(int argc, char **argv)
{
  int    i, s, ss, pid, namelen; 
  char   readline_binary[1024];
  struct sockaddr         name;

  DEBUG1("plop_xterm\n");

  mungeReadlineBinary(readline_binary, argv[0]);

  pid = getpid();
  bzero((char *)&name,sizeof(name));
  name.sa_family = AF_UNIX;
  sprintf(name.sa_data,"/tmp/.xc%d", pid);

  xterm_socket = -1;
  s = xterm_comm_socket(&name);
  
  switch (xterm_pid = fork()) {
  case -1:
    fprintf(stderr, "FORK FAILURE\n"); fflush(stderr);  perror("fork");
    unlink(name.sa_data);
    return 0;
  case 0:			/* This is the child process executing */
    {
      /* Close the rest of the open files */
      for (i=3; i<NOFILE; i++) {
	close(i); /* Ignoring errors merrily */
      }
#ifdef __linux__
      execl ("/usr/X11R6/bin/xterm", 
#else
      execl ("/usr/local/bin/xterm", 
#endif
	     "xterm", 
	     "-rv",         /* I like rv*/
	     "-title", "xfMiniConsole - waiting...",
	     "+sb",         /* scroll bar good */
	     "-e", 
	     readline_binary,
	     name.sa_data,
	     NULL);
      perror("XTERM"); 
      kill(pid, 9); /* Kill the parent also... */
      exit(-1);
    }
  default:		/* This is the parent process executing */
    /* Wait for the xterm to come up ... */
    namelen = sizeof name;
    xterm_socket = accept(s,(struct sockaddr *)&name,&namelen);
    if (xterm_device == NULL)
      xterm_device = devCreateDev("Xterm device",
				  DEV_OUTPUTHND, inputCallback,
				  DEV_LISTENING, LISTENING | TALKING,
				  DEV_CLOSE_ON_ZERO, FALSE,
				  NULL);
    devConnectDev(xterm_device,xterm_socket);
  }
  return 1;
}
 
void xRunConsole(int argc, char **argv)
{
  static char buf[DEFAULT_LINE_LENGTH];
  struct timeval clickPollTime = {0, 100}; /* Every 1/10 second */

  fl_initialize(&argc, argv, "xfMiniConsole",0,0);

  stdin_connect(stdin_defaultInputHnd); 
  
  /*
   * Add a polling thingy to the stdin_device. Really should
   * create a new device using devCreate, but this is the most convient
   * method. Every "pollTime", pollHandler will be called.
   */
  devStartPolling(stdin_device, &clickPollTime, ProcessXFHandler, NULL);

  xfConsole = create_form_xfMiniConsole();

  connectWithNanny();

  fl_deactivate_object(xfConsole->killButton);
  fl_deactivate_object(xfConsole->restartButton);
  fl_deactivate_object(xfConsole->breakButton);

  fl_set_browser_fontsize(xfConsole->messageBrowser,FL_TINY_SIZE);

  setSuspendResume("Suspend");

  deactivateStatus("Ready");

  fl_show_form(xfConsole->xfMiniConsole,
	       FL_PLACE_MOUSE, FL_FULLBORDER, "xfMiniConsole");

  spawn_xterm(argc, argv);
}
