/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: xfRunConsole.c
 *
 * ABSTRACT:
 *
 * Arrrgh. Couldn't stand runConsole. Rewrote, and simplfied.
 * use fdesign to redesign
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/xfRunConsole.c,v $
 * $Revision: 1.5 $
 * $Date: 1996/07/29 05:43:07 $
 * $Author: josullvn $
 *
 * REVISION HISTORY:
 * $Log: xfRunConsole.c,v $
 * Revision 1.5  1996/07/29  05:43:07  josullvn
 * Forgot to make the necessary changes to xfConsole et all for the new version
 * of xforms
 *
 * Revision 1.4  1996/06/28  14:07:43  reids
 * Fixed quite a few bugs -- with graphics, interaction with script, and
 *   killing processes
 *
 * Revision 1.3  1996/03/29  15:57:45  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *   xRunConsole and xfRunConsole.
 * Added a way to add macro definitions to resource files ("define: <x> <y>").
 * Fixed a bug that was causing the xfRunConsole to crash when a task was
 *   restarted.
 *
 *****************************************************************************/
#include "tca/libc.h"
#include "tca/stdinDev.h"

#include "xfRunConsole.h"
#include "callbacks.h"
#include "messages.h"

void xRunConsole(int argc, char **argv)
{
  static char buf[DEFAULT_LINE_LENGTH];
  float sx = 1.0, sy = 1.0;
  struct timeval clickPollTime = {0, 100}; /* Every 1/10 second */

  if (argc > 1) {
    sscanf (argv[1], "%f", &sx);
    sscanf (argv[2], "%f", &sy);
  }

  fl_initialize(&argc, argv, "xfRunConsole", 0, 0);

  stdin_connect(stdin_defaultInputHnd); 
  
  /*
   * Add a polling thingy to the stdin_device. Really should
   * create a new device using devCreate, but this is the most convient
   * method. Every "pollTime", pollHandler will be called.
   */
  devStartPolling(stdin_device, &clickPollTime, ProcessXFHandler, NULL);

  xfConsole = create_form_xfConsole();

  connectWithNanny();

  fl_deactivate_object(xfConsole->killButton);
  fl_deactivate_object(xfConsole->restartButton);
  fl_deactivate_object(xfConsole->breakButton);
  fl_deactivate_object(xfConsole->inputForm);

  fl_set_browser_fontsize(xfConsole->processBrowser,FL_TINY_SIZE);
  fl_set_browser_fontsize(xfConsole->messageBrowser,FL_TINY_SIZE);

  fl_set_browser_fontstyle(xfConsole->processBrowser,FL_FIXED_STYLE);
  fl_set_browser_fontstyle(xfConsole->messageBrowser,FL_FIXED_STYLE);

  fl_scale_form (xfConsole->xfConsole, sx, sy);

  setSuspendResume("Suspend");

  deactivateStatus("Ready");

  fl_show_form(xfConsole->xfConsole,
	       FL_PLACE_MOUSE, FL_FULLBORDER, "xfRunConsole");
}
