/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: xRunConsole.h
 *
 * ABSTRACT:
 *
 * stole from xconsole the ability to create widgets for the management of the
 * text - this stops us having to deal with several screens...
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/xRunConsole.h,v $
 * $Revision: 1.3 $
 * $Date: 1996/08/05 16:08:16 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: xRunConsole.h,v $
 * Revision 1.3  1996/08/05  16:08:16  rich
 * Added comments to endifs.
 *
 * Revision 1.2  1996/03/29  15:57:40  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *   xRunConsole and xfRunConsole.
 * Added a way to add macro definitions to resource files ("define: <x> <y>").
 * Fixed a bug that was causing the xfRunConsole to crash when a task was
 *   restarted.
 *
 * Revision 1.1  1995/12/17  20:26:04  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.10  1995/09/28  19:32:12  josullvn
 * Lots o changes
 *
 * Revision 1.9  1995/09/26  20:35:38  rich
 * Fixed order of system specific libraries.
 * Removed extra "extern"s.
 *
 * Revision 1.8  1995/07/13  11:09:59  josullvn
 * Two bugs were present. a) syscalls were being interrupted, and b) the
 * processes button management got screwy after a while. The first is due
 * to Devutils, second fixed by removing a reliance on xclient data. Also
 * added features to newProcess whereby it is now menu driven.
 * Added tca.rc, removing those processes from the Simulator resource files.
 *
 * Revision 1.7  1995/05/15  17:16:53  rich
 * Added nanny.h and moved external declarations to the .h files.
 *
 * Revision 1.6  1995/05/15  17:07:40  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 *
 *****************************************************************************/
#ifndef XRUNCONSOLE_H
#define XRUNCONOLE_H
#include "tca/libc.h"

#include "xtUtil.h"

typedef struct _CONSOLE_GRAPHICS {
  long             editInputStart;
  Widget           wProcButtons;
  Widget           filterToggle;
} CONSOLE_GRAPHICS_TYPE, *CONSOLE_GRAPHICS_PTR;

/*
 *
 */

extern  XtAppContext app_context;

extern Widget top;
extern Widget status_bar, status_label;
extern Widget        textwindow, messwidget, labelwindow, processnamewindow;
extern Widget        processRow;
extern Display *CurDpy;

#include "runConsole.h"

#endif /* XRUNCONSOLE_H */
