/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: xRunConsole.c
 *
 * ABSTRACT:
 *
 * stole from xconsole the ability to create widgets for the management of the
 * text - this stops us having to deal with several screens...
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/xRunConsole.c,v $
 * $Revision: 1.8 $
 * $Date: 1996/06/28 14:07:41 $
 * $Author: reids $
 *
 * REVISION HISTORY:
 *
 * $Log: xRunConsole.c,v $
 * Revision 1.8  1996/06/28  14:07:41  reids
 * Fixed quite a few bugs -- with graphics, interaction with script, and
 *   killing processes
 *
 * Revision 1.7  1996/03/29  15:57:38  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *   xRunConsole and xfRunConsole.
 * Added a way to add macro definitions to resource files ("define: <x> <y>").
 * Fixed a bug that was causing the xfRunConsole to crash when a task was
 *   restarted.
 *
 * Revision 1.6  1996/02/18  21:17:56  reids
 * Put script stuff back in;
 *   Try to fix pseudo-terminal handling for UNIX and LINUX;
 *   Resize dialog windows when text gets too long.
 *
 * Revision 1.5  1996/02/12  00:46:18  rich
 * Scripting does not compile, removed.
 *
 * Revision 1.4  1996/02/10  16:52:29  rich
 * Made private functions static and fixed some forward declarations.
 *
 * Revision 1.3  1996/02/05  15:57:18  reids
 * Added scripting capabilities to nanny -- using lex/bison to parse script
 *  files according to the script.bnf standard.
 * Integrated support for running/stopping/suspending scripts into the
 *  runConsole window.
 *
 * Revision 1.2  1996/01/22  21:28:00  reids
 * Consolidated all the DEBUG and WARNING macro definitions into nannyCommon.h
 *
 * Revision 1.1  1995/12/17  20:26:02  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.25  1995/10/07  19:41:48  rich
 * Use printf rather than fprintf.
 *
 * Revision 1.24  1995/09/28  19:32:09  josullvn
 * Lots o changes
 *
 * Revision 1.23  1995/09/26  20:35:37  rich
 * Fixed order of system specific libraries.
 * Removed extra "extern"s.
 *
 * Revision 1.22  1995/08/14  22:41:01  rich
 * Changes for the new functional devUtils (8.1.6).
 * "-clean" option on nanny now prompts before killing tasks, unless the
 * "-noprompt" flag is used.
 *
 * Revision 1.21  1995/08/06  00:05:24  rich
 * Changes for new devUtils in tca-8.1.
 *
 * Revision 1.20  1995/07/13  11:09:57  josullvn
 * Two bugs were present. a) syscalls were being interrupted, and b) the
 * processes button management got screwy after a while. The first is due
 * to Devutils, second fixed by removing a reliance on xclient data. Also
 * added features to newProcess whereby it is now menu driven.
 * Added tca.rc, removing those processes from the Simulator resource files.
 *
 * Revision 1.19  1995/07/11  23:56:55  josullvn
 * Added some debugging info to COnnectionNoting
 *
 * Revision 1.18  1995/07/11  22:59:17  josullvn
 * Needed to retain the concept of who sent a message, and so had to
 * restructure all the message passing. Also, made sure we don't
 * overwrite any of the parameters due to reentry problems.
 *
 * Revision 1.17  1995/07/11  01:06:44  josullvn
 * Whesh. OK, fixed a bug in parsing lines, where by if messages get corrupted,
 * we can recover. Added a -clean option to nanny. Discovered that the old
 * double newProcess bug has returned to haunt me.
 *
 * Revision 1.16  1995/07/04  05:46:39  josullvn
 * The latest update. Some stuff vanished (???), but recovered a bit.
 * Now have improved notification of whats happening between runConsole
 * and nanny, and better starting off of processes.
 *
 * Revision 1.15  1995/06/25  01:03:53  rich
 * Moved devUtils to tca.
 *
 * Revision 1.14  1995/06/15  22:11:18  rich
 * Linux 1.2 changes. Still does not compile.
 *
 * Revision 1.12  1995/05/20  02:07:40  josullvn
 * Some more bells and whistles to the console callback.
 * Added environment variables to the resource definition.
 * Extended the still buggy children catching for time outs.
 * Added diagnositic code to analyze startup failures.
 *
 * Revision 1.11  1995/05/19  11:32:35  josullvn
 * Updated resource files to include "ready strings"
 * Debugged some protocol problems with messages.c parsing of split lines.
 * (Feel that remaining problem is in devUtils).
 * Added Highlightening to buttons.
 * Removed SIGCHLD trapping - its too flakey at the moment.
 *
 * Revision 1.10  1995/05/17  23:39:37  josullvn
 * Now restarts dead processes - need to add timeouts.
 *
 * Revision 1.9  1995/05/15  17:07:38  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 *
 *****************************************************************************/
#include "tca/libc.h"
#include "tca/ezx.h"
#include "tca/x11Dev.h"
#include "tca/stdinDev.h"

#include "xtUtil.h"
#include "xRunConsole.h"
#include "callbacks.h"
#include "xCallbacks.h"
#include "messages.h"

Widget top;
Widget processRow;
Widget status_bar, status_label;
Display *CurDpy;
Atom wm_delete_window;
Widget textwindow, messwidget, labelwindow, processnamewindow;

/*
 * Xt resource definitions for the window.
 */
static String fallback_resources[] = { 
  "*geometry: +50+50",
  "*input:			TRUE",
#if defined(linux)
  "*font: 6x9",
  "*processname*preferredPaneSize:375",
  "*editWindow*preferredPaneSize:	250",
  "*bc_label*width:		350",
#else
  "*bc_label*width:		450",
  "*processname*preferredPaneSize:525",
  "*editWindow*preferredPaneSize: 400",
#endif
  "*labelWindow*justify: center",
  "*labelWindow*label: No processes loaded",
  "*process_label*label:Processes:",
  "*quit.label:	Shutdown",
  "*quitDialog.label: Processes Running. Do you wish to kill them?",
  "*quitDialog.label.resizable: TRUE",
/*  "*quitDialog*value: ",*/
/*  "*Dialog*value.translations: #override \\n <Key>Return: Ok()",*/
  "*reload.label:			Reload",
  "*Command.shapeStype:           roundedRectangle",
  "*clearmessage.label:Clear Buffer",
  "*clearprocess.label:Clear Buffer",
  "*restartprocess.label:	        Restart",
  "*newprocess.label:	        Run->",
  "*breakprocess.label:	        Break",
  "*suspendprocess.label:	        Suspend",
  "*continueprocess.label:	Continue",
  "*destroyprocess.label:	        Destroy->",
  "*killprocess.label:	        Kill",
  "*filter.label:                 Filter...",
  "*closeX.label:  	        Close Console",
  "*help.label:	                Help",
  "*sync.label:	                Sync",
  "*script.label:               Script->",
  "*buttons*orientation:		horizontal",
  "*buttons*highlightThickness:   2",
  "*buttons1*highlightThickness:  2",
  "*buttons2*highlightThickness:  2",
  "*buttons*showGrip:		False",
  "*buttons1*orientation:		horizontal",
  "*buttons1*showGrip:		False",
  "*buttons2*orientation:		horizontal",
  "*buttons2*showGrip:		False",
  "*process*shapeStype:           roundedRectangle",
  "*process*orientation:		horizontal",
  "*process*highlightThickness:   2",
  "*process*showGrip:		False",
  "*messageWindow*preferredPaneSize:	50",
  "*Paned*Text*allowResize:	True",
  "*messageWindow.autoFill:	True",
  "*messageWindow.scrollVertical:	Always",
  "*editWindow.autoFill:		True",
  "*editWindow.scrollVertical:	Always",
  "*bc_label*label:		Messages:",
  "*woahDialog.label:             WARNING: irreversable action",
  "*processDialog.value:",
  "*processDialog.label:          Enter Process Below:",
  "*processDialog*value.translations: #override \
			<Key>Return: dialog_return()",
  "*filterDialog.value:",
  "*filterDialog.label: Enter string to filter on.",
  "*filterDialog*value.translations: #override \
			<Key>Return: filter_return()",
  "*scriptFileDialog.value:",
  "*scriptFileDialog.label: Enter script file.",
  "*scriptFileDialog*value.translations: #override \
			<Key>Return: scriptfile_return()",
  "*processname.translations: #override \
			<Key>Return: end-of-line()",
  "*processname.baseTranslations: #override \
			<Key>Return: end-of-line()",
  NULL,
};

void xRunConsole(int argc, char **argv)
{
  char   buf[DEFAULT_LINE_LENGTH];
  
  XtSetLanguageProc(NULL, NULL, NULL);
  
  stdin_connect(stdin_defaultInputHnd); 
  
  top = XtAppInitialize(&app_context, "XavierConsole", NULL, 0, 
			&argc, argv, fallback_resources, NULL, 0);
  
  addCallbackActions();
  XtOverrideTranslations
    (top, XtParseTranslationTable ("<Message>WM_PROTOCOLS: quit()"));
  
  CurDpy = XtDisplay(top);
  
  makeButtonsAndBoxes(top);
  
  EZX_initGC(top);
  XtRealizeWidget(top);
  EZX_waitForMap();
  XDefineCursor(XtDisplay(top),XtWindow(top),
		XCreateFontCursor( XtDisplay(top), XC_left_ptr));
  
  wm_delete_window = XInternAtom(XtDisplay(top), "WM_DELETE_WINDOW", False);
  
  (void) XSetWMProtocols (XtDisplay(top), XtWindow(top), &wm_delete_window, 1);
  
  x11_connect(ConnectionNumber(CurDpy));

  connectWithNanny();
  
  deactivateStatus("Ready");
}

