/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: xCallbacks.h
 *
 * ABSTRACT: Callbacks explicitly for xRunConsole
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/xCallbacks.h,v $
 * $Revision: 1.9 $
 * $Date: 1996/08/05 16:08:13 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: xCallbacks.h,v $
 * Revision 1.9  1996/08/05  16:08:13  rich
 * Added comments to endifs.
 *
 * Revision 1.8  1996/07/25  22:25:32  rich
 * Fixed uninitialized memory references.
 *
 * Revision 1.7  1996/03/29  15:57:36  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *   xRunConsole and xfRunConsole.
 * Added a way to add macro definitions to resource files ("define: <x> <y>").
 * Fixed a bug that was causing the xfRunConsole to crash when a task was
 *   restarted.
 *
 * Revision 1.6  1996/02/18  21:17:54  reids
 * Put script stuff back in;
 *   Try to fix pseudo-terminal handling for UNIX and LINUX;
 *   Resize dialog windows when text gets too long.
 *
 * Revision 1.5  1996/02/12  00:46:17  rich
 * Scripting does not compile, removed.
 *
 * Revision 1.4  1996/02/10  16:52:28  rich
 * Made private functions static and fixed some forward declarations.
 *
 * Revision 1.3  1996/02/05  15:57:16  reids
 * Added scripting capabilities to nanny -- using lex/bison to parse script
 *  files according to the script.bnf standard.
 * Integrated support for running/stopping/suspending scripts into the
 *  runConsole window.
 *
 * Revision 1.2  1996/01/22  21:32:00  reids
 * Fixed the way stdout is handled, using pseudo-terminals, so that it preserves
 *   the line-buffering mode of the real TTY.
 * Added support for running scripts (not really integrated, yet, but initial
 *   tests are working).
 *
 * Revision 1.1  1995/12/17  20:26:01  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.15  1995/09/28  19:32:08  josullvn
 * Lots o changes
 *
 * Revision 1.14  1995/09/26  20:35:35  rich
 * Fixed order of system specific libraries.
 * Removed extra "extern"s.
 *
 * Revision 1.13  1995/09/20  01:58:48  rich
 * Reduced the number of libraries needed.
 * Cleaned up warnings.
 *
 * Revision 1.12  1995/08/14  22:40:58  rich
 * Changes for the new functional devUtils (8.1.6).
 * "-clean" option on nanny now prompts before killing tasks, unless the
 * "-noprompt" flag is used.
 *
 * Revision 1.11  1995/07/21  15:13:26  josullvn
 * Added a restarts option - see the README. updated some .rc files to give
 * examples. Also fixed conflicts to that runConsole is notified about dead
 * processes.
 *
 * Revision 1.10  1995/07/13  11:09:56  josullvn
 * Two bugs were present. a) syscalls were being interrupted, and b) the
 * processes button management got screwy after a while. The first is due
 * to Devutils, second fixed by removing a reliance on xclient data. Also
 * added features to newProcess whereby it is now menu driven.
 * Added tca.rc, removing those processes from the Simulator resource files.
 *
 * Revision 1.9  1995/07/11  01:06:43  josullvn
 * Whesh. OK, fixed a bug in parsing lines, where by if messages get corrupted,
 * we can recover. Added a -clean option to nanny. Discovered that the old
 * double newProcess bug has returned to haunt me.
 *
 * Revision 1.8  1995/07/09  05:25:17  josullvn
 * Added TCA test suite to Simulator.rc - helps with debugging
 * Fixed a display inheritance bug that interfere with dependancies starting up.
 * Fixed a problem with parsing data.
 * Improved communication feedbacks to runConsole from nanny.
 *
 * Revision 1.7  1995/07/04  05:46:34  josullvn
 * The latest update. Some stuff vanished (???), but recovered a bit.
 * Now have improved notification of whats happening between runConsole
 * and nanny, and better starting off of processes.
 *
 * Revision 1.6  1995/06/15  22:11:15  rich
 * Linux 1.2 changes. Still does not compile.
 *
 * Revision 1.4  1995/05/15  17:07:36  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 *
 *****************************************************************************/
#ifndef XCALLBACKS_H_INCLUDED
#define XCALLBACKS_H_INCLUDED

void addCallbackActions (void);
void makeButtonsAndBoxes(Widget parent);
long TextLength (Widget w);

#endif /* XCALLBACKS_H_INCLUDED */
