/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: xCallbacks.c
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/xCallbacks.c,v $
 * $Revision: 1.12 $
 * $Date: 1996/07/29 05:03:21 $
 * $Author: josullvn $
 *
 * REVISION HISTORY:
 *
 * $Log: xCallbacks.c,v $
 * Revision 1.12  1996/07/29  05:03:21  josullvn
 * Bloody hell. This commiting is a bit different than under Xavier. Short
 * story is cleaned up some purify bugs, and also made changes to nanny
 * which should make it a bit better - Improving performance over multiple
 * machines, explict quietening of nondisplayed processes, replacing of
 * runConsole with xfMiniConsole, which is multithreaded, vt102 compilant,
 * adds a uniform emacs-like command line editing feature, better on small
 * screens and otherwise fab.
 *
 * Revision 1.11  1996/07/25  22:25:30  rich
 * Fixed uninitialized memory references.
 *
 * Revision 1.10  1996/07/18  02:23:12  rich
 * Fixed some memory problems found with purify.
 *
 * Revision 1.9  1996/06/28  14:07:39  reids
 * Fixed quite a few bugs -- with graphics, interaction with script, and
 *   killing processes
 *
 * Revision 1.8  1996/03/29  15:57:33  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *   xRunConsole and xfRunConsole.
 * Added a way to add macro definitions to resource files ("define: <x> <y>").
 * Fixed a bug that was causing the xfRunConsole to crash when a task was
 *   restarted.
 *
 * Revision 1.7  1996/02/18  21:17:52  reids
 * Put script stuff back in;
 *   Try to fix pseudo-terminal handling for UNIX and LINUX;
 *   Resize dialog windows when text gets too long.
 *
 * Revision 1.6  1996/02/12  00:46:15  rich
 * Scripting does not compile, removed.
 *
 * Revision 1.5  1996/02/10  16:52:27  rich
 * Made private functions static and fixed some forward declarations.
 *
 * Revision 1.4  1996/02/05  15:57:13  reids
 * Added scripting capabilities to nanny -- using lex/bison to parse script
 *  files according to the script.bnf standard.
 * Integrated support for running/stopping/suspending scripts into the
 *  runConsole window.
 *
 * Revision 1.3  1996/01/27  21:56:32  rich
 * Pre-release of 8.4.
 *
 * Revision 1.2  1996/01/22  21:31:53  reids
 * Fixed the way stdout is handled, using pseudo-terminals, so that it preserves
 *   the line-buffering mode of the real TTY.
 * Added support for running scripts (not really integrated, yet, but initial
 *   tests are working).
 *
 * Revision 1.1  1995/12/17  20:26:00  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.28  1995/09/28  19:32:04  josullvn
 * Lots o changes
 *
 * Revision 1.27  1995/09/26  20:35:33  rich
 * Fixed order of system specific libraries.
 * Removed extra "extern"s.
 *
 * Revision 1.26  1995/09/20  01:58:46  rich
 * Reduced the number of libraries needed.
 * Cleaned up warnings.
 *
 * Revision 1.25  1995/08/14  22:40:55  rich
 * Changes for the new functional devUtils (8.1.6).
 * "-clean" option on nanny now prompts before killing tasks, unless the
 * "-noprompt" flag is used.
 *
 * Revision 1.24  1995/08/06  00:05:21  rich
 * Changes for new devUtils in tca-8.1.
 *
 * Revision 1.23  1995/07/15  23:46:31  josullvn
 * Extra \n's were being appended occasioanlly to messages.
 * Running a program localhost on multiple machines is currently bad.
 * Adjusted Simulator2.rc
 *
 * Revision 1.22  1995/07/13  14:26:35  josullvn
 * Cosmetic mods (printfs etc)
 *
 * Revision 1.21  1995/07/13  11:09:54  josullvn
 * Two bugs were present. a) syscalls were being interrupted, and b) the
 * processes button management got screwy after a while. The first is due
 * to Devutils, second fixed by removing a reliance on xclient data. Also
 * added features to newProcess whereby it is now menu driven.
 * Added tca.rc, removing those processes from the Simulator resource files.
 *
 * Revision 1.20  1995/07/12  07:40:07  josullvn
 * Filled in README, updated resource file (Plus added Simulator2.rc)
 * Changed some messages on startup, and added a bugs file
 *
 * Revision 1.19  1995/07/12  02:46:43  josullvn
 * Test the result of message passing commands for failure
 *
 * Revision 1.18  1995/07/11  23:56:53  josullvn
 * Added some debugging info to COnnectionNoting
 *
 * Revision 1.17  1995/07/11  11:21:42  josullvn
 * A lot more changes to message passing to handle multiple nannys better.
 * This basically involved removing fdclient, and being smarter about what
 * nannys are in the system
 *
 * Revision 1.16  1995/07/11  01:06:41  josullvn
 * Whesh. OK, fixed a bug in parsing lines, where by if messages get corrupted,
 * we can recover. Added a -clean option to nanny. Discovered that the old
 * double newProcess bug has returned to haunt me.
 *
 * Revision 1.15  1995/07/09  05:25:13  josullvn
 * Added TCA test suite to Simulator.rc - helps with debugging
 * Fixed a display inheritance bug that interfere with dependancies starting up.
 * Fixed a problem with parsing data.
 * Improved communication feedbacks to runConsole from nanny.
 *
 * Revision 1.14  1995/07/04  05:46:33  josullvn
 * The latest update. Some stuff vanished (???), but recovered a bit.
 * Now have improved notification of whats happening between runConsole
 * and nanny, and better starting off of processes.
 *
 * Revision 1.13  1995/06/15  22:11:12  rich
 * Linux 1.2 changes. Still does not compile.
 *
 * Revision 1.11  1995/05/25  02:50:12  rich
 * Fixed lookup for nanny device and lost character problem.
 *
 * Revision 1.10  1995/05/24  15:50:53  josullvn
 * Had deleted two lines by accident in nannyUtils which prevented commands being
 * passed to processes. More support for intermachine communication. Now
 * can do rcsh to run a csh shell remotely on heart (according to new
 * Simulator.rc file)
 *
 * Revision 1.9  1995/05/23  23:58:48  josullvn
 * Yeah. Fixed the SIGCHLD problem (tured out that popen is internally
 * implemented with fork - when pclose was called, it generated a SIGCHLD
 * which intereupted the system call which lead to trouble).
 * Fixed environment variables, can now add env variables in .rc file, and
 * they are passed to appropriate child. Realized that need to also
 * provide an ability to pass the display variable from runConsole to the
 * nanny - being worked on.
 * Bug exists in devUtils (?) which large data streams. Run csh as a new process
 * and do ps auxww to cause it to occur.
 *
 * Revision 1.8  1995/05/20  02:07:39  josullvn
 * Some more bells and whistles to the console callback.
 * Added environment variables to the resource definition.
 * Extended the still buggy children catching for time outs.
 * Added diagnositic code to analyze startup failures.
 *
 * Revision 1.7  1995/05/19  11:32:33  josullvn
 * Updated resource files to include "ready strings"
 * Debugged some protocol problems with messages.c parsing of split lines.
 * (Feel that remaining problem is in devUtils).
 * Added Highlightening to buttons.
 * Removed SIGCHLD trapping - its too flakey at the moment.
 *
 * Revision 1.6  1995/05/15  17:07:35  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 *
 *****************************************************************************/
#include "tca/libc.h"
#include "tca/devUtils.h"
#include "tca/stdinDev.h"

#include "xtUtil.h"
#include "xRunConsole.h"
#include "callbacks.h"
#include "xCallbacks.h"
#include "messages.h"
#include "script.h"

/*
 * Forward declarations
 */
static void Clear (void);
static void TextReplace (Widget w, int start, int end, XawTextBlock *block);
long TextLength (Widget w);

static Widget suspendResumeW;
static Widget b2_row, B2_1, B2_2, B2_3, B2_4, B2_5, B2_6, B2_7;
static char newEditTranslations[] = 
"                      <Key>Return:  user_input() \n\
		   Ctrl<Key>P:       prev_history() \n\
		   Ctrl<Key>N:       next_history()";

extern char *_XawTextGetText(Widget w, long, long);

/* Put up a dialog box as a child of the parent widget, centered around
   the centering widget.  When "ok" is clicked, the doneCallback procedure
   is called, and sent the dialog widget and the data. */
static void centeredDialogBox (Widget parent, char *dialogName,
			       XtCallbackProc doneCallback, XtPointer data,
			       Widget centeringWidget)
{
  Widget popup, dialog;
  char popupName[80];
  Arg args[1];

  sprintf(popupName, "%sPShell", dialogName); /* Should do length checks */

  XtSetArg(args[0], XtNallowShellResize, TRUE);
  popup = XtCreatePopupShell(popupName, transientShellWidgetClass, 
			     parent, args, ONE);

  dialog = XtCreateManagedWidget(dialogName, dialogWidgetClass,
				 popup, NULL, ZERO);
  /*
   * The prompting message's size is dynamic; allow it to request resize.
   */
  XawDialogAddButton(dialog, "ok", doneCallback, data);
  XawDialogAddButton(dialog, "cancel", EZX_DestroyPopupPrompt,
		     (XtPointer)dialog);
  
  XtPopup(popup, XtGrabExclusive);
  EZX_CenterPopup(centeringWidget, popup);
}

static void woahDialogDone(Widget w, XtPointer client_data,
			   XtPointer call_data)
{
  Widget dialog = XtParent(w);
  Cardinal state = (Cardinal) client_data;

  switch (state) {
  case KILL:
    killCurrentProcess();
    break;
  case RESTART:
    restartCurrentProcess();
    break;
  case QUIT:
    shutdownProcess();
    safeExit();
    break;
#ifndef TEST_CASE_COVERAGE
  default:
    { char buf[BUFSIZ];
      sprintf(buf, "[CONSOLE] Unknown action %d to %s\n", state, 
	      consoleProc[currentProc].name);
      MessagePrintf(buf);
    }
#endif
  }
  EZX_DestroyPopupPrompt(NULL, (XtPointer) dialog, (XtPointer)NULL);
}

static void woahDialog (Widget button, Cardinal woahState)
{
  if (!checkForCurrentProc()) return;

  centeredDialogBox(button, "woahDialog", woahDialogDone,
		    (XtPointer)woahState, button);
}

static void DoQuitCallback(Widget button, 
			   XtPointer client_data, XtPointer call_data)
{
  Cardinal woahState = 0;

  if( !nConsoleProcs)
    exit(0); 
  
  Feep();

  woahState = QUIT;
  centeredDialogBox(button, "quitDialog", woahDialogDone,
		    (XtPointer)woahState, top);
}

static void user_input(Widget w)
{
  long last;
  static char userString[200];
  static char *tmpString;

  if (currentProc == -1) 
    return;

  last = TextLength(w);
  /* 
   * We want the text between last and consoleProc[currentProc].editInputStart
   * There probably should be a better function to do this, 
   * but I don't have the manual...
   */
  tmpString  = 
    _XawTextGetText(w, consoleProc[currentProc].graphics->editInputStart,
		    last);
  strcpy(userString, tmpString);
  
  historyAddCommand(&(consoleProc[currentProc].history), userString);
  
  consoleProc[currentProc].graphics->editInputStart = last;
  EditAppend("\n", 1);
  XawTextSetInsertionPoint(w, TextLength(w));

  /* Send to nanny... */
  userString[strlen(userString)+1]='\0';
  userString[strlen(userString)]='\n';
  runCommandProcess(consoleProc[currentProc].name, userString);
  if (tmpString) free(tmpString);
}

static void prevHistory(Widget w)
{
  long last;
  XawTextBlock    block;

  if (!consoleProc[currentProc].history.pos)
    return;

  last = TextLength(w);
  block.ptr =  historyPrev(&(consoleProc[currentProc].history));
  block.firstPos = 0;
  block.length = strlen(block.ptr);
  block.format = FMT8BIT;

  TextReplace (w, consoleProc[currentProc].graphics->editInputStart,
	       last, &block);
  XawTextSetInsertionPoint(textwindow, TextLength(textwindow));
}

static void nextHistory(Widget w)
{
  long last;
  XawTextBlock    block;

  if (!consoleProc[currentProc].history.pos)
    return;

  last = TextLength(w);

  block.ptr = historyNext(&(consoleProc[currentProc].history));
  block.firstPos = 0;
  block.length = strlen(block.ptr);
  block.format = FMT8BIT;

  TextReplace (w, consoleProc[currentProc].graphics->editInputStart,
	       last, &block);
  XawTextSetInsertionPoint(textwindow, TextLength(textwindow));
}

static int convertProcessWidgetToId(Widget w)
{
  int ntmp = -1;
  int i;

  for (i=0; i<nConsoleProcs; i++)
    if (consoleProc[i].graphics->wProcButtons == w)
      ntmp = i;

  return ntmp;
}

static void resetProcess (const char *name)
{
  static Arg arg;
  int ntmp;
  
  /* Figure out which of consoleProcs we wish to reset */
  if ((ntmp = convertProcessNameToId(name)) == -1) return;

  XtSetArg(arg, XtNbackground, theWhitePixel);
  XtSetValues(consoleProc[ntmp].graphics->wProcButtons, &arg, ONE);
  WFlush();
}

static void DoProcess(Widget w)
{
  static Arg args[5];
  Cardinal num_args = 0;
  static char label_buf[BUFSIZ];

  num_args = 0;
  sprintf(label_buf, "%s - Interaction", XtName(w));
  XtSetArg(args[num_args], XtNlabel, label_buf); num_args++;
  XtSetValues( labelwindow, args, num_args);

  num_args = 0;
  XtSetArg(args[num_args], XtNeditType, XawtextAppend); num_args++;
  XtSetValues( textwindow, args, num_args);
  
  Clear();
  if ((currentProc = convertProcessNameToId(XtName(w))) == -1)
    {
      MessagePrintf("[CONSOLE] Unable to connect to process\n");
      return;
    }

  resetProcess(XtName(w));

  consoleProc[currentProc].graphics->editInputStart = 0;
  historyFreeProcess(&(consoleProc[currentProc].history));
  startFlushing(XtName(w));

  Feep();

  return;
}

long TextLength(Widget w)
{
  return XawTextSourceScan (XawTextGetSource (w),
			    (XawTextPosition) 0,
			    XawstAll, XawsdRight, 1, TRUE);
}

static void Clear (void)
{
    long	    last;
    XawTextBlock    block;

    last = TextLength (textwindow);
    block.ptr = "";
    block.firstPos = 0;
    block.length = 0;
    block.format = FMT8BIT;
    TextReplace (textwindow, 0, last, &block);
}

static void TextReplace (Widget w, int start, int end, 
			 XawTextBlock *block)
{
    Arg		    arg;
    Widget	    source;
    XawTextEditType edit_mode;

    source = XawTextGetSource (w);
    XtSetArg (arg, XtNeditType, &edit_mode);
    XtGetValues (source, &arg, ONE);
    XtSetArg (arg, XtNeditType, XawtextEdit);
    XtSetValues (source, &arg, ONE);
    XawTextReplace (w, start, end, block);
    XtSetArg (arg, XtNeditType, edit_mode);
    XtSetValues (source, &arg, ONE);
}

void EditAppend(char *buffer, int n)
{
  long         current;
  XawTextBlock text;

  /* MessagePrintf("[DEBUG] append\n"); */
  current =  XawTextGetInsertionPoint (textwindow);
  text.length   = n;
  text.ptr      = buffer;
  text.firstPos = 0;
  text.format   = FMT8BIT;

  XawTextReplace(textwindow, 
		 consoleProc[currentProc].graphics->editInputStart,
		 consoleProc[currentProc].graphics->editInputStart,
		 &text);

  if (current>=consoleProc[currentProc].graphics->editInputStart)
    XawTextSetInsertionPoint( textwindow, 
			     MIN(current+n,TextLength(textwindow)));
  
  consoleProc[currentProc].graphics->editInputStart += n;
}

static void EditInsert (char *buffer, int n)
{
  XawTextBlock    block;
  long	    current;

  current = XawTextGetInsertionPoint (textwindow);
  block.ptr = buffer;
  block.firstPos = 0;
  block.length = n;
  block.format = FMT8BIT;
  TextReplace (textwindow, 0, 0, &block);
  if (current == 0)
    XawTextSetInsertionPoint(textwindow, 
			     MIN(n,TextLength(textwindow)));
}

void addProcessButton (const char *name)
{
  consoleProc[nConsoleProcs].graphics->wProcButtons = 
      MakeCommandButton(processRow, consoleProc[nConsoleProcs].name, 
			(XtCallbackProc) DoProcess);
  resetProcess(name);
}

void destroyProcessButton(int index)
{
  XtDestroyWidget(consoleProc[index].graphics->wProcButtons);
}

void resetProcessButtons (int index)
{
  static Arg args[5];
  Cardinal num_args;
  static char label_buf[BUFSIZ];

  num_args = 0;
  sprintf(label_buf, "No process selected");
  XtSetArg(args[num_args], XtNlabel, label_buf); num_args++;
  XtSetValues( labelwindow, args, num_args);

  Clear();

  num_args = 0;
  XtSetArg(args[num_args], XtNeditType, XawtextRead); num_args++;
  XtSetValues( textwindow, args, num_args);

  WFlush();
}

BOOLEAN highlightProcess(char *name)
{
  static Arg arg;
  int ntmp;
  
  /* Figure out which of consoleProcs we wish to highlight */
  if ((ntmp = convertProcessNameToId(name)) == -1) return FALSE;

  XtSetArg(arg, XtNbackground, C_YELLOW);
  XtSetValues(consoleProc[ntmp].graphics->wProcButtons, &arg, ONE);
  WFlush();

  return TRUE;
}

static void closeXCallback(Widget button, 
			   XtPointer client_data, XtPointer call_data)
{
  safeExit();
}

static void reloadCallback(Widget button, 
			   XtPointer client_data, XtPointer call_data)
{
  reloadResource("");
}

static void syncCallback(void)
{
  syncWithNanny();
}

static void helpCallback(void)
{
  MessagePrintf("[CONSOLE] Help isn't quite typed up yet\n");
}

static void filterDialogDone(Widget w, 
			     XtPointer client_data, XtPointer call_data)
{
  Widget dialog;

  dialog = XtParent(w);

  setFilterString(XawDialogGetValueString(dialog));

  EZX_DestroyPopupPrompt(NULL, (XtPointer) dialog, (XtPointer)NULL);
}

static void filterCallback(Widget button, XtPointer client_data, 
			   XtPointer call_data)
{
  centeredDialogBox(button, "filterDialog", filterDialogDone, NULL, button);
}

static void clearMessageCallback(void)
{
  long	    last;
  XawTextBlock    block;

  last = TextLength (messwidget);
  block.ptr = "";
  block.firstPos = 0;
  block.length = 0;
  block.format = FMT8BIT;
  TextReplace (messwidget, 0, last, &block);
}

static void newKillProcessCallback(Widget button, 
				   XtPointer client_data,
				   XtPointer call_data)
{
  static char buf[128];

  /* 
   * If this has been selected, that means we have no nanny connect yet...
   */
  Feep();
  MessagePrintf("[CONSOLE] Checking for nanny\n");

  messageMakePing(buf);
  if (safePassLocalMessage(buf))
    MessagePrintf("[CONSOLE] Nanny now found\n");
  else {
    /* An error message will already have been displayed... */
    return;
  }

  messageMakeList(buf,"");
  if (safePassLocalMessage(buf))
    MessagePrintf("[CONSOLE] Programs loaded from nanny, select Kill again\n");
  else
    MessagePrintf("[CONSOLE] Nanny lost\n");
}

static void killProcessCallback(Widget button,
				XtPointer client_data, XtPointer call_data)
{
  woahDialog(button, KILL);
}

static void restartProcessCallback(Widget button,
				   XtPointer client_data, XtPointer call_data)
{
  woahDialog(button, RESTART);
}

static void clearProcessCallback(void)
{
  Clear();
}

static void breakProcessCallback(Widget button, XtPointer client_data,
				 XtPointer call_data)
{
  sendBreak();
}

static void suspendProcessCallback(void)
{
  if (!checkForCurrentProc()) return;

  runSuspendProcess(consoleProc[currentProc].name);
}

static void continueProcessCallback (void)
{
  if (!checkForCurrentProc()) return;

  runContinueProcess(consoleProc[currentProc].name);
}

static void loudnessCallback (void)
{
  MessagePrintf("Loudness set to \n");
}

static void newProcessCallback(Widget button,
			       XtPointer client_data, XtPointer call_data)
{
  getProcessList("Run");
}

static void setScrollPosition (void)
{
  XawScrollbarSetThumb(status_bar, getPosition(), 0.2);
  WFlush();
}

static void updateStatus(void)
{
  updatePosition();
  setScrollPosition();
}

void activateStatus (const char *message)
{
  static Arg args[5];
  Cardinal num_args = 0;

  num_args = 0;
  XtSetArg(args[num_args], XtNlabel, message); num_args++;
  XtSetValues( status_label, args, num_args);

  initPosition();
  setScrollPosition();

  devStartPolling(stdin_device, &pollTime, (Handler) updateStatus,NULL);
}

void deactivateStatus (const char *message)
{
  static Arg args[5];
  Cardinal num_args = 0;

  num_args = 0;
  XtSetArg(args[num_args], XtNlabel, message); num_args++;
  XtSetValues( status_label, args, num_args);

  devStopPolling(stdin_device);

  initPosition();
  setScrollPosition();
}

static void MenuNewSelect(Widget w, XtPointer client_data, XtPointer call_data)
{
  runNewProcess(XtName(w));
}

static void MenuDestroySelect(Widget w, XtPointer client_data, 
			      XtPointer call_data)
{
  destroyProcess(XtName(w));
}

static void newProcessDialogDone (Widget w, 
				  XtPointer client_data, XtPointer call_data)
{
  Widget dialog; 
  String string; 
  static char buf[DEFAULT_LINE_LENGTH];

  dialog = XtParent(w);
  string = XawDialogGetValueString(dialog);

  if (strlen(string)) {
    messageMakeExec(buf, string, getenv("DISPLAY"));
    if (safePassLocalMessage(buf))
      {
	sprintf(buf,"Waiting for %s...", string);
	activateStatus(buf);
	sprintf(buf,
		"[CONSOLE] %s waiting for confirmation from nanny\n", string);
	MessagePrintf(buf);
      }
  }
  else {
    sprintf(buf,
	    "[CONSOLE] No process requested\n");
    MessagePrintf(buf);
  }
  EZX_DestroyPopupPrompt(NULL, (XtPointer) dialog, (XtPointer)NULL);
}

static void oldNewProcessCallback(Widget button, XtPointer client_data,
				  XtPointer call_data)
{
  centeredDialogBox(button, "processDialog", newProcessDialogDone, NULL, top);
}

void setSuspendResume (const char *title)
{
  Arg arg[1];

  XtSetArg(arg[0], XtNlabel, title);
  XtSetValues(suspendResumeW, arg, ONE);
}

static void rerunScriptCallback (Widget w, XtPointer data1, XtPointer data2)
{
  rerunScript();
}

/* Used for both suspend and resume */
static void suspendScriptCallback (Widget w, XtPointer data1, XtPointer data2)
{
  Arg arg[1];
  char *title;

  XtSetArg(arg[0], XtNlabel, &title);
  XtGetValues(w, arg, ONE);

  suspendResume(title);
}

static void scriptFileDone (Widget w, XtPointer client_data,
			    XtPointer call_data)
{
  Widget dialog;
  char *filename;

  dialog = XtParent(w);
  filename = XawDialogGetValueString(dialog);
  if (filename) {
    if (!scriptLoad(filename)) {
      Feep(); 
      MessagePrintf("[ERROR] File not found or syntax error in parsing\n");
    }
  }
  EZX_DestroyPopupPrompt(NULL, (XtPointer) dialog, (XtPointer)NULL);
}

static void runScriptCallback (Widget w, XtPointer data1, XtPointer data2)
{
  centeredDialogBox(XtParent(w), "scriptFileDialog", scriptFileDone, 
		    NULL, XtParent(w));
}

static void stopScriptCallback (Widget w, XtPointer data1, XtPointer data2)
{
  stopScript();
}

static Widget createScriptMenu(Widget parent)
{
  Widget scriptW, menuW, entry;
  
  scriptW = XtCreateManagedWidget("script", menuButtonWidgetClass, 
				  parent, NULL, ZERO);
  menuW = XtCreatePopupShell("menu", simpleMenuWidgetClass, 
			     scriptW, NULL, ZERO);
  entry = XtCreateManagedWidget("Run", smeBSBObjectClass, menuW, NULL, ZERO);
  XtAddCallback(entry, XtNcallback, runScriptCallback, NULL);

  entry = XtCreateManagedWidget("Rerun", smeBSBObjectClass, menuW, NULL, ZERO);
  XtAddCallback(entry, XtNcallback, rerunScriptCallback, NULL);

  suspendResumeW = entry = XtCreateManagedWidget(SUSPEND, smeBSBObjectClass,
						 menuW, NULL, ZERO);
  XtAddCallback(entry, XtNcallback, suspendScriptCallback, NULL);

  entry = XtCreateManagedWidget("Stop", smeBSBObjectClass, menuW, NULL, ZERO);
  XtAddCallback(entry, XtNcallback, stopScriptCallback, NULL);

  return scriptW;
}

void unfreeze (void)
{
}

struct _CONSOLE_GRAPHICS *createConsoleGraphics (void)
{
  return (CONSOLE_GRAPHICS_PTR)malloc(sizeof(CONSOLE_GRAPHICS_TYPE));
}

void clearConsoleGraphics (consoleProcPtr consoleProc)
{
  bzero(consoleProc->graphics, sizeof(CONSOLE_GRAPHICS_TYPE));
}

void copyConsoleGraphics (consoleProcPtr from, consoleProcPtr to)
{
  *to->graphics = *from->graphics;
}

static XtActionsRec callbackActions[] = {
  {"quit",         (XtActionProc) DoQuitCallback},
  {"dialog_return",   (XtActionProc) newProcessDialogDone},
  {"filter_return",   (XtActionProc) filterDialogDone},
  {"scriptfile_return",   (XtActionProc) scriptFileDone},
  {"user_input",   (XtActionProc) user_input},
  {"prev_history", (XtActionProc) prevHistory},
  {"next_history", (XtActionProc) nextHistory}
};

void addCallbackActions (void)
{
  XtAppAddActions(app_context, callbackActions, XtNumber(callbackActions));
}

static Widget makeB2Row(BOOLEAN newMenu, Widget *bNew, Widget *bDestroy)
{
  if (newMenu) {
    XtDestroyWidget(B2_1);
    XtDestroyWidget(B2_2);
    XtDestroyWidget(B2_3);
    XtDestroyWidget(B2_4);
    XtDestroyWidget(B2_5);
    XtDestroyWidget(B2_6);
    XtDestroyWidget(B2_7);
    *bNew = B2_1 = XtCreateManagedWidget("newprocess", 
					 menuButtonWidgetClass, 
					 b2_row, NULL, ZERO);
  } else
    B2_1 = MakeCommandButton(b2_row, "newprocess",   newProcessCallback);
  
  B2_2 = MakeCommandButton(b2_row, "killprocess",    killProcessCallback);
  B2_3 = MakeCommandButton(b2_row, "restartprocess", restartProcessCallback);
  B2_4 = MakeCommandButton(b2_row, "breakprocess",   breakProcessCallback);
  B2_5 = MakeCommandButton(b2_row, "clearprocess", 
			   (XtCallbackProc) clearProcessCallback);
  
  if (newMenu) {
    *bDestroy = B2_6 = XtCreateManagedWidget("destroyprocess", 
					     menuButtonWidgetClass, 
					     b2_row, NULL, ZERO);
  } else
    B2_6 = MakeCommandButton(b2_row, "destroyprocess",   newProcessCallback);
  
  B2_7 = createScriptMenu(b2_row);

  return B2_1;
}

void makeButtonsAndBoxes(Widget parent)
{
  Widget outer, b_row;
  Arg arglist[10];
  Cardinal num_args;
  
  outer = XtCreateManagedWidget("paned", 
				panedWidgetClass,
				parent,
				NULL, ZERO);
  
  b_row= XtCreateManagedWidget("buttons", 
			       /* panedWidgetClass, */
			       boxWidgetClass, 
			       outer, NULL, ZERO);
  {
    MakeCommandButton(b_row, "quit", DoQuitCallback);
    MakeCommandButton(b_row, "closeX", closeXCallback);
    MakeCommandButton(b_row, "reload", reloadCallback);
    MakeCommandButton(b_row, "sync",(XtCallbackProc)  syncCallback);
    MakeCommandButton(b_row, "help",(XtCallbackProc)  helpCallback);
  }
  
  XtCreateManagedWidget("bc_label", labelWidgetClass, outer, NULL, ZERO);
  
  b_row= XtCreateManagedWidget("buttons1",
			       /* panedWidgetClass, */
			       boxWidgetClass,
			       outer, NULL, ZERO);
  {
    MakeCommandButton(b_row, "filter", filterCallback);
    MakeCommandButton(b_row, "clearmessage",
		      (XtCallbackProc)clearMessageCallback);
  }
  
  num_args = 0;
  XtSetArg(arglist[num_args], XtNeditType, XawtextRead); num_args++;
  messwidget = XtCreateManagedWidget("messageWindow", 
				     asciiTextWidgetClass, outer,
				     arglist, num_args);
  
  XtCreateManagedWidget("process_label", 
			labelWidgetClass, outer, NULL, ZERO);
  
  b2_row= XtCreateManagedWidget("buttons2",
				boxWidgetClass,
				outer, NULL, ZERO);
  
  makeB2Row(FALSE, NULL, NULL);
  
  processRow= XtCreateManagedWidget("process", 
				    /*				    panedWidgetClass,*/
				    boxWidgetClass,
				    outer, NULL, ZERO);
  num_args = 0;
  labelwindow = XtCreateManagedWidget("labelWindow",labelWidgetClass, 
				      processRow, arglist, num_args);
  
  
  num_args = 0;
  XtSetArg(arglist[num_args], XtNeditType, XawtextRead); num_args++;
  {
    XtTranslations trans_table;
    
    trans_table = XtParseTranslationTable(newEditTranslations);
    textwindow =  XtCreateManagedWidget("editWindow", asciiTextWidgetClass, 
					outer, arglist, num_args);
    
    XtOverrideTranslations(textwindow, trans_table);
  }
  
  b_row = XtCreateManagedWidget("buttons3",
				boxWidgetClass,
				outer, NULL, ZERO);
  
  {
    int border = 0;
    
    num_args = 0;
    XtSetArg(arglist[num_args], XtNborderWidth, border); num_args++;
    status_label = XtCreateManagedWidget("status_label", 
					 labelWidgetClass, b_row,  NULL, ZERO);
    
    num_args = 0;
    border = 2;
    XtSetArg(arglist[num_args], XtNborderWidth, border); num_args++;
    XtSetArg(arglist[num_args], XtNorientation, XtorientHorizontal); num_args++;
    XtSetArg(arglist[num_args], XtNsensitive, False); num_args++;
    XtSetArg(arglist[num_args], XtNmappedWhenManaged, True); num_args++;
    border = 200;
    XtSetArg(arglist[num_args], XtNwidth, border); num_args++;
    status_bar = XtCreateManagedWidget("status_bar", 
				       scrollbarWidgetClass, b_row, arglist,num_args);
  }
  
  deactivateStatus("waiting...");
}

void attachProgramMenu(void)
{
  Widget menuNew, menuDestroy, entry, button, buttonDestroy;
  char *buf, program[128];
  int i;

  makeB2Row(TRUE, &button, &buttonDestroy);

  menuNew = XtCreatePopupShell("menu",
			       simpleMenuWidgetClass, 
			       button, NULL, ZERO);

  menuDestroy = XtCreatePopupShell("menu",
				   simpleMenuWidgetClass, 
				   buttonDestroy, NULL, ZERO);

  buf = messageExtractKey(possiblePrograms, program);
  for (i=0; i<numPossiblePrograms; i++) 
    {
      String item = program;

      entry = XtCreateManagedWidget(item, 
				    smeBSBObjectClass, 
				    menuNew, NULL, 0);
      XtAddCallback(entry, XtNcallback, MenuNewSelect, (XtPointer)item);
      entry = XtCreateManagedWidget(item, 
				    smeBSBObjectClass, 
				    menuDestroy, NULL, 0);
      XtAddCallback(entry, XtNcallback, MenuDestroySelect, (XtPointer)item);
      buf = messageExtractKey(buf, program);
    }
}
