%{
#include "tca/libc.h"

#include "script.h"
#include "scriptParse.h"

static int line_no = 1;
int yyerror(char *s); /* Forward reference */
int yywrap(void); /* Forward reference */
int yylex(void); /* Forward reference */

#define YYDEBUG 1
%}
%start script
%union {
  char *string;
  int   ival;
  SCRIPT_STATEMENT_PTR statement;
  SCRIPT_LIST_PTR      script;
  SCRIPT_TIME_TYPE     time;
}
%token BEGIN_TOKEN
%token END_TOKEN
%token RUN_TOKEN
%token KILL_TOKEN
%token SUSPEND_TOKEN
%token CONTINUE_TOKEN
%token SEND_TOKEN
%token WHEN_TOKEN
%token WHENREADY_TOKEN
%token WHENEVERY_TOKEN
%token AT_TOKEN
%token ATEVERY_TOKEN
%token <ival> MONTH_TOKEN
%token <ival> INT_0_23_TOKEN
%token <ival> INT_24_31_TOKEN
%token <ival> INT_32_59_TOKEN
%token <ival> INT_00_09_TOKEN
%token <string> LINE_TOKEN
%token <string> PROCESS_TOKEN
%type <statement> statement action conditional
%type <statement> run_action kill_action continue_action suspend_action
%type <statement> send_action
%type <statement> condition when_condition at_condition every_condition
%type <script>    script consequent block
%type <ival>      day minsec
%type <time>      time relative_time absolute_time hms_time
%type <time>      seconds minutes hours daytime
%expect 2
%right ':'
%%
script :
	statement { $$ = NULL; ADD_STATEMENT($1, $$); currentScript = $$; }
	| script statement { ADD_STATEMENT($2, $1); currentScript = $$ = $1; }
	;

statement :
	action
	| conditional
	;

action :
	run_action
	| kill_action
	| continue_action
	| suspend_action
	| send_action
	;

run_action :
	RUN_TOKEN PROCESS_TOKEN { $$ = scriptCreateAction(RunAction, $2); }
	;
kill_action :
	KILL_TOKEN PROCESS_TOKEN { $$ = scriptCreateAction(KillAction, $2); }
	;
continue_action :
	CONTINUE_TOKEN PROCESS_TOKEN { $$ = scriptCreateAction(ContinueAction,
							       $2); }
	;
suspend_action :
	SUSPEND_TOKEN PROCESS_TOKEN { $$ = scriptCreateAction(SuspendAction,
							      $2); }
	;

send_action :
	SEND_TOKEN PROCESS_TOKEN LINE_TOKEN { $$ = scriptCreateSend($2, $3); }
	;

conditional :
	condition consequent { $1->subStatements = $2; $$ = $1; }
	;

consequent :
	statement { $$ = NULL; ADD_STATEMENT($1, $$); currentScript = $$; }
	| block
	;

block :
	BEGIN_TOKEN script END_TOKEN { $$ = $2; }
	;

condition :
	when_condition
	| at_condition
	| every_condition
	;

when_condition :
	WHEN_TOKEN PROCESS_TOKEN LINE_TOKEN { $$ = scriptCreateWhen($2, FALSE,
								    $3); }
	| WHENREADY_TOKEN PROCESS_TOKEN { $$ = scriptCreateWhenReady($2); }
	;
at_condition :
	AT_TOKEN time { $$ = scriptCreateAt(FALSE, $2); }
	;
every_condition :
	WHENEVERY_TOKEN PROCESS_TOKEN LINE_TOKEN 
            { $$ = scriptCreateWhen($2, TRUE, $3); }
	| ATEVERY_TOKEN time { $$ = scriptCreateAt(TRUE, $2); }
	;

time :
	relative_time   { $$ = $1; $$.useRelative = TRUE; }
	| absolute_time { $$ = $1; $$.useRelative = FALSE; }
	;
minsec :
	INT_0_23_TOKEN
	| INT_24_31_TOKEN
	| INT_32_59_TOKEN
	| INT_00_09_TOKEN
	;
seconds :
	':' minsec { scriptInitTime(&$$); $$.absolute.sec = $2; }
	;
minutes :
	minsec seconds { $$ = $2; $$.absolute.min = $1; }
	;
hours :
 	INT_0_23_TOKEN ':' minutes { $$ = $3; $$.absolute.hr = $1; }
	;
hms_time :
	hours
	| minutes
	| seconds
	;
day :
 	INT_0_23_TOKEN 
	| INT_24_31_TOKEN
	;
daytime :
 	day { scriptInitTime(&$$); $$.absolute.day = $1; }
	| day hours { $$ = $2; $$.absolute.day = $1; }
	;
relative_time :
	'+' hms_time { $$ = $2; $$.relative = relTimeFromAbs(&$2.absolute); }
	;
absolute_time :
	MONTH_TOKEN '-' daytime { $$ = $3; $$.absolute.mth = $1; }
	| daytime
	| hms_time
	;
%%
static int yylook(void); /* Forward reference */
static int yyback(int *p, int m); /* Forward reference */

#include "./lex.yy.c"

int yywrap (void)
{
  return 1;
}

int yyerror(char *s)
{
  fprintf(stderr, "%s(%d): %s on line %d (%s)\n",
	  __FILE__, __LINE__, s, line_no, yytext);
}
