A [a,A]
B [b,B]
C [c,C]
D [d,D]
E [e,E]
F [f,F]
G [g,G]
H [h,H]
I [i,I]
J [j,J]
K [k,K]
L [l,L]
M [m,M]
N [n,N]
O [o,O]
P [p,P]
R [r,R]
S [s,S]
T [t,T]
U [u,U]
V [v,V]
W [w,W]
Y [y,Y]
%%
{B}{E}{G}{I}{N}:		{ return BEGIN_TOKEN; }
{E}{N}{D}:			{ return END_TOKEN; }
{R}{U}{N}:			{ return RUN_TOKEN; }
{K}{I}{L}{L}:			{ return KILL_TOKEN; }
{S}{U}{S}{P}{E}{N}{D}:		{ return SUSPEND_TOKEN; }
{C}{O}{N}{T}{I}{N}{U}{E}:	{ return CONTINUE_TOKEN; }
{S}{E}{N}{D}:			{ return SEND_TOKEN; }
{W}{H}{E}{N}:			{ return WHEN_TOKEN; }
{W}{H}{E}{N}{R}{E}{A}{D}{Y}:	{ return WHENREADY_TOKEN; }
{W}{H}{E}{N}{E}{V}{E}{R}{Y}:	{ return WHENEVERY_TOKEN; }
{A}{T}:				{ return AT_TOKEN; }
{A}{T}{E}{V}{E}{R}{Y}:		{ return ATEVERY_TOKEN; }
{J}{A}{N}			{ yylval.ival = 0; return MONTH_TOKEN; }
{F}{E}{B}			{ yylval.ival = 1; return MONTH_TOKEN; }
{M}{A}{R}			{ yylval.ival = 2; return MONTH_TOKEN; }
{A}{P}{R}			{ yylval.ival = 3; return MONTH_TOKEN; }
{M}{A}{Y}			{ yylval.ival = 4; return MONTH_TOKEN; }
{J}{U}{N}			{ yylval.ival = 5; return MONTH_TOKEN; }
{J}{U}{L}			{ yylval.ival = 6; return MONTH_TOKEN; }
{A}{U}{G}			{ yylval.ival = 7; return MONTH_TOKEN; }
{S}{E}{P}			{ yylval.ival = 8; return MONTH_TOKEN; }
{O}{C}{T}			{ yylval.ival = 9; return MONTH_TOKEN; }
{N}{O}{V}			{ yylval.ival = 10; return MONTH_TOKEN; }
{D}{E}{C}			{ yylval.ival = 11; return MONTH_TOKEN; }
[1-9]|1[0-9]|2[0-3]		{ yylval.ival = atoi(yytext); 
				  return INT_0_23_TOKEN; }
2[4-9]|3[0-1]			{ yylval.ival = atoi(yytext); 
				  return INT_24_31_TOKEN; }
3[2-9]|[4-5][0-9]		{ yylval.ival = atoi(yytext);
				  return INT_32_59_TOKEN; }
0[0-9]				{ yylval.ival = atoi(yytext);
				  return INT_00_09_TOKEN; }
\"				{ char c, line[BUFSIZ], *linePtr;
				  linePtr = &line[0];
				  while ((c = input()) != '"') {
				    if (c == '\\') {
				      c = input();
				      switch (c) {
				      case '"': c = '"'; break;
				      case 'n': c = '\n'; break;
				      case '\\': c = '\\'; break;
				      default: fprintf(stderr, "Cannot handle \%c\n", c);
				      }
				    }
				    *linePtr = c; linePtr++;
				  }
				  *linePtr = '\0'; linePtr++;
				  yylval.string = strdup(line);
				  return LINE_TOKEN; }
[_a-zA-Z][_a-zA-Z0-9]*		{ yylval.string = strdup((char *)yytext);
				  return PROCESS_TOKEN; }
[-:+]				{ return yytext[0]; } /* Single char tokens */

\#.+$				; /* Do nothing: Just eat comments */
[\ \t]+				; /* ignore except to delimit tokens */
\n				; { ++line_no; } /* ignore except to delimit tokens and inc line no */
%%
