/*****************************************************************************
 * PROJECT: TCA
 *
 * (c) Copyright 1996 Reid Simmons. All rights reserved.
 *
 * FILE: scriptParse.h
 *
 * ABSTRACT: Type definitions for running script files
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/scriptParse.h,v $
 * $Revision: 1.2 $
 * $Date: 1996/02/05 15:57:05 $
 * $Author: reids $
 *
 * REVISION HISTORY:
 *
 * $Log: scriptParse.h,v $
 * Revision 1.2  1996/02/05  15:57:05  reids
 * Added scripting capabilities to nanny -- using lex/bison to parse script
 *  files according to the script.bnf standard.
 * Integrated support for running/stopping/suspending scripts into the
 *  runConsole window.
 *
 * Revision 1.1  1996/01/22  21:31:42  reids
 * Fixed the way stdout is handled, using pseudo-terminals, so that it preserves
 *   the line-buffering mode of the real TTY.
 * Added support for running scripts (not really integrated, yet, but initial
 *   tests are working).
 *
 ****************************************************************/

#ifndef INC_SCRIPT_PARSE_H
#define INC_SCRIPT_PARSE_H

#define INDENT_INCREMENT (1)

/* Needed for script & runConsole */
void setLocalTimeFromAbsTime(struct tm *localTime, ABS_TIME_PTR absTime);
extern SCRIPT_LIST_PTR scriptParse (FILE *scriptFile);
extern void scriptPrint (SCRIPT_LIST_PTR script);

/* Needed for the bison/yacc parser */
extern SCRIPT_STATEMENT_PTR scriptCreateAction (SCRIPT_STATEMENT_ENUM type,
						char *process);
extern SCRIPT_STATEMENT_PTR scriptCreateSend (char *process, char *line);
extern SCRIPT_STATEMENT_PTR scriptCreateWhenReady (char *process);
extern SCRIPT_STATEMENT_PTR scriptCreateWhen (char *process, BOOLEAN continual,
					      char* line);
extern SCRIPT_STATEMENT_PTR scriptCreateAt (BOOLEAN continual, 
					    SCRIPT_TIME_TYPE time);
extern void scriptInitTime(SCRIPT_TIME_PTR time);
extern time_t relTimeFromAbs(ABS_TIME_PTR time);

extern SCRIPT_LIST_PTR currentScript;

#endif /* INC_SCRIPT_PARSE_H */
