/*****************************************************************************
 * PROJECT: TCA
 *
 * (c) Copyright 1996 Reid Simmons. All rights reserved.
 *
 * FILE: script.h
 *
 * ABSTRACT: Type definitions for running script files
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/script.h,v $
 * $Revision: 1.3 $
 * $Date: 1996/02/07 00:28:15 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: script.h,v $
 * Revision 1.3  1996/02/07  00:28:15  rich
 * Add prefix to VERSION_DATE and COMMIT_DATE.
 *
 * Revision 1.2  1996/02/05  15:57:00  reids
 * Added scripting capabilities to nanny -- using lex/bison to parse script
 *  files according to the script.bnf standard.
 * Integrated support for running/stopping/suspending scripts into the
 *  runConsole window.
 *
 * Revision 1.1  1996/01/22  21:31:28  reids
 * Fixed the way stdout is handled, using pseudo-terminals, so that it preserves
 *   the line-buffering mode of the real TTY.
 * Added support for running scripts (not really integrated, yet, but initial
 *   tests are working).
 *
 ****************************************************************/

#ifndef INC_SCRIPT_H
#define INC_SCRIPT_H

#include "tca/basics.h"
#include "tca.h"
#include "tca/list.h"

#define ADD_STATEMENT(statement, scriptList) \
  { if (!scriptList) scriptList = listCreate();\
    listInsertItemLast((const void *)statement, scriptList); }

#define ACTIVATE(statement) ADD_STATEMENT(statement, activeListG)

#define DEACTIVATE(statement) \
  listDeleteItem((const void *)statement, activeListG);
 
#define ITERATE_SCRIPT_LIST(function, param, scriptList) \
  listIterateFromFirst((LIST_ITER_FN)function, (const void *)param, scriptList)

#define ITERATE_ACTIVE_LIST(function, param) \
  ITERATE_SCRIPT_LIST(function, param, activeListG)

#define TIME_IS_SET(time) (time >= 0)

typedef LIST_PTR SCRIPT_LIST_PTR;

typedef enum {UnknownStatement, SendAction, RunAction, KillAction,
		SuspendAction, ContinueAction,
		WhenConditional, WhenReadyConditional, AtConditional
	    } SCRIPT_STATEMENT_ENUM;

typedef struct { short mth, day, hr, min, sec;
	       } ABS_TIME_TYPE, *ABS_TIME_PTR;

typedef struct { BOOLEAN useRelative;
		 time_t relative;
		 ABS_TIME_TYPE absolute;
		 time_t alarm;
	       } SCRIPT_TIME_TYPE, *SCRIPT_TIME_PTR;

typedef struct { SCRIPT_STATEMENT_ENUM type;
		 BOOLEAN continual;
		 char *process;
		 char *line;
		 SCRIPT_TIME_TYPE time;
		 SCRIPT_LIST_PTR subStatements;
	       } SCRIPT_STATEMENT_TYPE, *SCRIPT_STATEMENT_PTR;

typedef struct { time_t current;
		 time_t alarm;
	       } TIME_ITER_TYPE, *TIME_ITER_PTR;

typedef struct { char *process;
		 char *line;
	       } WHEN_ITER_TYPE, *WHEN_ITER_PTR;


extern void processAtConditionals (void);
extern void processWhenConditionals (char *process, char *line);
extern void processWhenReadyConditionals (char *process);

extern void    scriptClear (void);
extern BOOLEAN scriptLoad (char *filename);
extern BOOLEAN scriptRerun (void);
extern BOOLEAN scriptSuspend (void);
extern BOOLEAN scriptResume (void);

#endif /* INC_SCRIPT_H */
