/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: runConsole.h
 *
 * ABSTRACT:
 *
 * stole from xconsole the ability to create widgets for the management of the
 * text - this stops us having to deal with several screens...
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/runConsole.h,v $
 * $Revision: 1.8 $
 * $Date: 1996/08/05 16:08:12 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: runConsole.h,v $
 * Revision 1.8  1996/08/05  16:08:12  rich
 * Added comments to endifs.
 *
 * Revision 1.7  1996/06/28  14:07:36  reids
 * Fixed quite a few bugs -- with graphics, interaction with script, and
 *   killing processes
 *
 * Revision 1.6  1996/03/29  15:57:28  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *   xRunConsole and xfRunConsole.
 * Added a way to add macro definitions to resource files ("define: <x> <y>").
 * Fixed a bug that was causing the xfRunConsole to crash when a task was
 *   restarted.
 *
 * Revision 1.5  1996/02/01  04:04:18  rich
 * Generalized updateVersion and added recursion.
 *
 * Revision 1.4  1996/02/01  02:03:23  reids
 * Cleaned up/standardized command line option parsing and help messages.
 *
 * Revision 1.3  1996/01/31  22:51:58  reids
 * Added automatic updating of (micro) version control numbers
 *
 * Revision 1.2  1996/01/22  21:31:15  reids
 * Fixed the way stdout is handled, using pseudo-terminals, so that it preserves
 *   the line-buffering mode of the real TTY.
 * Added support for running scripts (not really integrated, yet, but initial
 *   tests are working).
 *
 * Revision 1.1  1995/12/17  20:25:57  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.7  1995/07/15  07:13:22  josullvn
 * ProcessDevices is _not_ reentrant - this was causing lots of problems as it
 * turns out. Restructing my blocking code fixed it.
 * Also, added a notion of dead - that is telling when something has
 * finally died.
 *
 * Revision 1.6  1995/07/13  17:04:44  josullvn
 * Added version info
 *
 * Revision 1.5  1995/07/11  01:06:40  josullvn
 * Whesh. OK, fixed a bug in parsing lines, where by if messages get corrupted,
 * we can recover. Added a -clean option to nanny. Discovered that the old
 * double newProcess bug has returned to haunt me.
 *
 * Revision 1.4  1995/05/15  17:07:29  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 * fs checkservers
 *****************************************************************************/
#ifndef RUNCONSOLE_H_INCLUDED
#define RUNCONSOLE_H_INCLUDED

#include "nannyCommon.h"
#include "history.h"

#define MAX_PROCESSES 20

typedef struct {
  char             name[DEFAULT_LINE_LENGTH];
  BOOLEAN          filterValue;
  BOOLEAN          ready;
  inputHistoryType history;
  struct _CONSOLE_GRAPHICS *graphics;
} consoleProcType, *consoleProcPtr;

extern int nConsoleProcs;
extern int currentProc;
extern consoleProcType consoleProc[MAX_PROCESSES];

extern void runNewProcess(char *process);
extern void runKillProcess(char *process);
extern void runSuspendProcess(char *process);
extern void runContinueProcess(char *process);
extern void runCommandProcess(char *process, char *command);
extern void connectWithNanny (void);

/* These are defined in xRunConsole or xfRunConsole */
extern void xRunConsole (int argc, char **argv);

#endif /* RUNCONSOLE_H_INCLUDED */
