/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: resource.h
 *
 * ABSTRACT:
 *
 * Implements a FSM for parsing resource files. Also handles creating and
 * managing the dependanciy/conflict structure stored in these files.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/resource.h,v $
 * $Revision: 1.4 $
 * $Date: 1996/08/05 16:08:10 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: resource.h,v $
 * Revision 1.4  1996/08/05  16:08:10  rich
 * Added comments to endifs.
 *
 * Revision 1.3  1996/06/28  14:07:31  reids
 * Fixed quite a few bugs -- with graphics, interaction with script, and
 *   killing processes
 *
 * Revision 1.2  1996/03/29  15:57:22  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *   xRunConsole and xfRunConsole.
 * Added a way to add macro definitions to resource files ("define: <x> <y>").
 * Fixed a bug that was causing the xfRunConsole to crash when a task was
 *   restarted.
 *
 * Revision 1.1  1995/12/17  20:25:55  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.15  1995/11/16  23:39:55  robocomp
 * Create BETA release for robot machines on noonan.
 *
 * Revision 1.14  1995/07/30  02:01:21  rich
 * Moved common defines to etc/GNUmakefile.defs.
 * Added loadRobotConfig.
 *
 * Revision 1.13  1995/07/21  15:13:24  josullvn
 * Added a restarts option - see the README. updated some .rc files to give
 * examples. Also fixed conflicts to that runConsole is notified about dead
 * processes.
 *
 * Revision 1.12  1995/07/15  07:13:20  josullvn
 * ProcessDevices is _not_ reentrant - this was causing lots of problems as it
 * turns out. Restructing my blocking code fixed it.
 * Also, added a notion of dead - that is telling when something has
 * finally died.
 *
 * Revision 1.11  1995/07/13  14:04:56  robocomp
 * Linux specific changes. ps under linux is 1 character longer, and occasionally
 * writes to stderr. Also, added a linux simulator due to the different paths
 *
 * Revision 1.10  1995/07/11  11:21:41  josullvn
 * A lot more changes to message passing to handle multiple nannys better.
 * This basically involved removing fdclient, and being smarter about what
 * nannys are in the system
 *
 * Revision 1.9  1995/07/11  01:06:39  josullvn
 * Whesh. OK, fixed a bug in parsing lines, where by if messages get corrupted,
 * we can recover. Added a -clean option to nanny. Discovered that the old
 * double newProcess bug has returned to haunt me.
 *
 * Revision 1.8  1995/05/23  23:58:44  josullvn
 * Yeah. Fixed the SIGCHLD problem (tured out that popen is internally
 * implemented with fork - when pclose was called, it generated a SIGCHLD
 * which intereupted the system call which lead to trouble).
 * Fixed environment variables, can now add env variables in .rc file, and
 * they are passed to appropriate child. Realized that need to also
 * provide an ability to pass the display variable from runConsole to the
 * nanny - being worked on.
 * Bug exists in devUtils (?) which large data streams. Run csh as a new process
 * and do ps auxww to cause it to occur.
 *
 * Revision 1.7  1995/05/20  02:07:37  josullvn
 * Some more bells and whistles to the console callback.
 * Added environment variables to the resource definition.
 * Extended the still buggy children catching for time outs.
 * Added diagnositic code to analyze startup failures.
 *
 * Revision 1.6  1995/05/19  11:32:32  josullvn
 * Updated resource files to include "ready strings"
 * Debugged some protocol problems with messages.c parsing of split lines.
 * (Feel that remaining problem is in devUtils).
 * Added Highlightening to buttons.
 * Removed SIGCHLD trapping - its too flakey at the moment.
 *
 * Revision 1.5  1995/05/15  17:07:25  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 *
 *****************************************************************************/
#ifndef RESOURCE_H_INCLUDED
#define RESOURCE_H_INCLUDED

#include "tca/libc.h"
#include "tca/basics.h"
#include "nannyCommon.h"

#define MAXBUF   2049
#define MAXTOKEN 128

typedef struct {
  int               id;
  char              name[MAXTOKEN];
  BOOLEAN           local;
  char              remoteMachine[DEFAULT_LINE_LENGTH];
  char              pathToExecuteFrom[DEFAULT_LINE_LENGTH];
  char              executable[DEFAULT_LINE_LENGTH];
  char              display[DEFAULT_LINE_LENGTH];
  char              *ready_string; 
  int               noConflicts;
  int               *conflicts;
  int               noDependencies;
  int               * dependencies ;
  int               noargs;
  char              **args;
  int               noenvs;
  char              **env;
  int               pid;
  int               executing;
  int               wantToExecute;
  BOOLEAN	    ready;
  char              stdinBuffer[MAXBUF];
  int               ibufEnd;
  char              errorBuffer[MAXBUF];
  int               ebufEnd;
  int               fdstdin;
  int               fdstdout;
  int               fdstderr;
  int               loudness;
  BOOLEAN           alwaysVerbose;
  int               timeouts;
  int               max_restarts;
} rcProgramType, *rcProgramPtr;

#define MAX_RESTARTS      10

#define rcEntMACHINE_NAME 0
#define rcEntPATH         1
#define rcEntEXECUTABLE   2
#define rcEntCONFLICTS    3
#define rcEntDEPENDENCIES 4
#define rcEntARGS         5
#define rcEntIBUF         6
#define rcEntEBUF         7
#define rcEntREADY        8
#define rcEntENVS         9
#define rcEntDISPLAY      10

#define SILENT 0
#define QUIET 1
#define VERBOSE 2

#define ERROR -1

extern int          rcNumAvailablePrograms ;
extern rcProgramPtr rcAvailableProgramList ;

#define defaultResourceFileA "./nanny.rc"
#define defaultResourceFileB "/afs/cs/project/robocomp/robot/src/robust/Simulator.rc"
#define defaultResourceFileC "/usr/local/robot/src/robust/linux.rc"

/*
 * Mainly useful for debug purposes. Allows the loaded resource file to be
 * saved in a format which can be reloaded.
 */
void rcDumpResources (FILE *stream);

/*
 * Main exported function, which accesses either filename, or 
 * if that fails/is null, the default resource file. The resources
 * are then loaded into memory...
 */
BOOLEAN rcLoadResourceFile(char *filename);

/* 
 * Maps key (eg "CTR" into a previously created id, else returns error
 */
int     rcLookupName(char *key);

/* 
 * Indexed by key (eg CTR etc). 
 * assumes that dependent and conflict are created with enough space
 * (rcNumAvailablePrograms)
 * recursively generates subdependencies/conflicts.
 * conflicts are guaranteed to be at a leaf level, so no need to recurse.
 */
BOOLEAN rcGenerateDependencies(char *key, int *dependent, int *conflict);

/*
 * To find a dependent processes to execute, set executing to FALSE, 
 * to find a conflicting processes to kill, set it to be TRUE 
 * returns -1 if none found.
 */
int rcExistDepOrCon(int *DepOrCon, BOOLEAN executing);
BOOLEAN rcDependsOnProcess (rcProgramPtr process);

/*
 * Fills in an entry in the resource table entry with key.
 * legal entries of type string are
 *     rcEntMACHINE_NAME
 *     rcEntPATH
 *     rcEntEXECUTABLE
 *     rcEntReady
 *     rcEntARGS
 *     rcEntIBUF          
 *     rcEntEBUF          
 * legal entries of type int are
 *     rcEntCONFLICTS    
 *     rcEntDEPENDENCIES 
 * Assumes that id is valid...
 */
void rcInsertStr (int id, int entry, char *key);
void rcInsertId (int id, int entry, int id1);

#endif /* RESOURCE_H_INCLUDED */
