/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: simple_term.c
 *
 * ABSTRACT:
 *
 * In the everending question for perfection, replacing the scrollbox with
 * an xterm display, or the display tool of the users choice (Hell, even emacs 
 * is possible)
 *
 * All this program does is reads input from stdin using readline to a socket.
 * Some perks are, emacs editing on input thanks to readline,
 *                 multithreading, so can click etc while streams of data
 *                 are arriving
 *                 vt102 compilant
 *
 * Still to do - ensure that its 8bit clean.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/readline.c,v $
 * $Revision: 1.1 $
 * $Date: 1996/07/29 05:03:15 $
 * $Author: josullvn $
 *
 * REVISION HISTORY:
 * $Log: readline.c,v $
 * Revision 1.1  1996/07/29  05:03:15  josullvn
 * Bloody hell. This commiting is a bit different than under Xavier. Short
 * story is cleaned up some purify bugs, and also made changes to nanny
 * which should make it a bit better - Improving performance over multiple
 * machines, explict quietening of nondisplayed processes, replacing of
 * runConsole with xfMiniConsole, which is multithreaded, vt102 compilant,
 * adds a uniform emacs-like command line editing feature, better on small
 * screens and otherwise fab.
 *
 *
 *****************************************************************************/
#include "tca/libc.h"
#include "tca/devUtils.h"
#include "tca/stdinDev.h"

#include <readline/readline.h>
#include <readline/history.h>

/* A static variable for holding the line. */
static char *line_read = (char *)NULL;
int  s; 

void interrupted()
{
  char CTRLC[]  = "\n";

  if (!safe_write(s, CTRLC)) 
    exit (-1);
}

void do_nothing()
{
  return;
}

/* Read a string, and return a pointer to it.  Returns NULL on EOF. */
char *rl_gets ()
{
  /* If the buffer has already been allocated, return the memory
     to the free pool. */
  if (line_read)
    {
      free (line_read);
      line_read = (char *)NULL;
    }

  /* Get a line from the user. */
  line_read = readline ("");

  /* If the line has any text in it, save it on the history. */
  if (line_read && *line_read)
    add_history (line_read);

  return (line_read);
}

/* Can't guarantee that readline knows our current directory for
   filename completion - so must disable that... */
void initialize_readline()
{
  rl_bind_key ('\t', rl_insert);
}

/* DESCRIPTION:
 *
 * PRECONDS:
 * fd: A file descriptor open for writing.
 * text: a non-null length of text
 *
 * POSTCONDS:
 * returns 0 if fd closes.
 * returns 1 if everything is OK;
 */
int safe_write(int fd, char *text)
{
  int nbytes, nwritten;
  int ret;
  nbytes = strlen(text); nwritten = 0;
  do {
    if ((ret= write(fd, &(text[nwritten]), nbytes-nwritten)) == -1)
      {
	switch (errno) {
	case EINTR:
	case EIO: 
	case EAGAIN:
	  break;
	default:
	  return 0;
	}
      }
    nwritten += ret;
  } while (nbytes != nwritten);
  
  return 1;
}

/* DESCRIPTION:
 *
 * PRECONDS:
 * fd: A file descriptor open for reading
 *
 * POSTCONDS:
 * returns 0 if fd closes.
 * returns 1 if everything is OK;
 */
int safe_read(int fd)
{
  int nbytes, nread;
  int ret;
  char buffer[1024];

  nbytes = devCharsAvailable(fd);nread = 0;
  if (nbytes>=1024) nbytes = 1023;
  do {
    if ((ret= read(fd, &(buffer[nread]), nbytes-nread)) == -1)
      {
	switch (errno) {
	case EINTR:
	case EIO: 
	case EAGAIN:
	  break;
	default:
	  return 0;
	}
      }
    nread += ret;
  } while (nbytes != nread);
  buffer[nbytes]=0;
  safe_write(STDOUT_FILENO, buffer);
  return 1;
}

/* DESCRIPTION:
 * wait for an input from a fd
 * 
 * PRECONDS:
 *  a fds, opened for reading.
 * 
 * POSTCONDS:
 *  1: input from 1st fd;
 *  0: timeout has elapsed
 */
int wait_for_action(int first, struct timeval *timeout)
{
  int stat = 0;
  fd_set readMaskData;
  fd_set *readMask = &readMaskData;

  /* 
   * Select will sleep until one of the fd's set in the readmask 
   * has data to be read, or until the time out has elapsed.
   */
  FD_ZERO(readMask);        
  FD_SET(first,readMask);   
  stat = select(FD_SETSIZE, readMask, NULL, NULL, timeout);

  if (stat > 0) 
    {
      if (FD_ISSET(first,readMask))
	return 1;
    }

  return 0;
}

/* DESCRIPTION:
 *
 * PRECONDS:
 *
 * POSTCONDS:
 */
int spawn_reader(int fd)
{
  switch (fork()) {
  case -1:
    fprintf(stderr, "FORK FAILURE\n"); fflush(stderr);  perror("fork");
    return 0;
  case 0:			/* This is the child process executing */
    {
      /* Loop around, reading data from fd to stdout */
      printf("No processes have been selected...\n");
      do {
	if (wait_for_action(fd, NULL))
	  if (!safe_read (fd))
	    exit (-1);
      } while (1);
      exit (-1); /* should never get to here */
    }
  default:		/* This is the parent process executing */
    break;
  }
  return 1;
}
 
/* DESCRIPTION:
 *
 * PRECONDS:
 *
 * POSTCONDS:
 */
void main(int argc, char **argv)
{ 
  struct sockaddr name;
  char *input=NULL;
  char CR[]  = "\n";

  if (argc != 2) /* just need the name of the socket... */
    exit (-1);
  
  if ((s = socket(PF_UNIX,SOCK_STREAM,0)) == -1) {
    perror("socket");
    exit(1);
  }

  bzero((char *)&name,sizeof(name));
  name.sa_family = AF_UNIX;
  strcpy(name.sa_data,argv[1]);

  if (connect(s,(struct sockaddr *) &name,sizeof(name)) == -1) {
    fprintf(stderr, "%d", errno);
    perror("connect");
    exit(1);
  }

  (void) signal(SIGINT,do_nothing);

  if (!spawn_reader(s))
    exit (-1);

  (void) signal(SIGINT,interrupted);

  initialize_readline();
  do {
    input = rl_gets();
    if (input) 
      {
	if (!safe_write(s, input)) exit (-1);
	/* add a CR */
	if (!safe_write(s, CR)) exit (-1);
      }
  } while (1);
}
