/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1994 Joseph O'Sullivan. All rights reserved.
 *
 * FILE: nannyUtils.h
 *
 * ABSTRACT:
 * Sleeps waiting for processes to connect via a socket. When a process 
 * connects, the connecting process describes one of...
 *   a) what program to run on this machine. we then runs said program.
 *   b) what program to kill on this machine. we then try to kill said program
 *   c) ???
 *
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/nannyUtils.h,v $
 * $Revision: 1.2 $
 * $Date: 1996/08/05 16:08:09 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: nannyUtils.h,v $
 * Revision 1.2  1996/08/05  16:08:09  rich
 * Added comments to endifs.
 *
 * Revision 1.1  1995/12/17  20:25:52  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.12  1995/09/29  05:58:10  rich
 * Added prototypes.
 *
 * Revision 1.11  1995/08/14  22:40:53  rich
 * Changes for the new functional devUtils (8.1.6).
 * "-clean" option on nanny now prompts before killing tasks, unless the
 * "-noprompt" flag is used.
 *
 * Revision 1.10  1995/07/13  11:09:51  josullvn
 * Two bugs were present. a) syscalls were being interrupted, and b) the
 * processes button management got screwy after a while. The first is due
 * to Devutils, second fixed by removing a reliance on xclient data. Also
 * added features to newProcess whereby it is now menu driven.
 * Added tca.rc, removing those processes from the Simulator resource files.
 *
 * Revision 1.9  1995/07/12  02:46:34  josullvn
 * Test the result of message passing commands for failure
 *
 * Revision 1.8  1995/07/11  11:21:38  josullvn
 * A lot more changes to message passing to handle multiple nannys better.
 * This basically involved removing fdclient, and being smarter about what
 * nannys are in the system
 *
 * Revision 1.7  1995/07/11  06:58:53  josullvn
 * Added capabilities for inter-nanny communication.
 * Mainly, there is now a list of connections, and each new executable is
 * announced to the whole list - may need to work on the kill part...
 *
 * Revision 1.6  1995/07/11  01:06:36  josullvn
 * Whesh. OK, fixed a bug in parsing lines, where by if messages get corrupted,
 * we can recover. Added a -clean option to nanny. Discovered that the old
 * double newProcess bug has returned to haunt me.
 *
 * Revision 1.5  1995/07/04  05:46:32  josullvn
 * The latest update. Some stuff vanished (???), but recovered a bit.
 * Now have improved notification of whats happening between runConsole
 * and nanny, and better starting off of processes.
 *
 * Revision 1.4  1995/06/02  23:02:54  rich
 * Added support for OSF 2.
 *
 * Revision 1.3  1995/05/15  17:07:22  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 *
 *****************************************************************************/
#ifndef NANNYUTILS_H_INCLUDE
#define NANNYUTILS_H_INCLUDE

#include "tca/libc.h"
#include "tca/basics.h"
#include "nannyCommon.h"

typedef struct{
  float CPU;
  float MEM;
  int   SZ;
  char  STATE[5];
} processInfoType, *processInfoPtr;

typedef struct{
  BOOLEAN remote;
  char machine[DEFAULT_LINE_LENGTH];
  int  fd;
} connectInfoType, *connectInfoPtr;

BOOLEAN nannyPs(int pid, processInfoPtr p);
BOOLEAN nannyExecProgram(char *name);
BOOLEAN nannyKillProgram(char *name);

void nannyConnectNote(BOOLEAN remote, char *name, int fd);
void nannyConnectUnnote(BOOLEAN remote, char *name, int fd);
BOOLEAN nannyConnectNotedp(BOOLEAN remote, char *name, int fd);
void nannyConnectList(FILE *fd);

void nannyCatchChild(int signal);
void nannyShutdown(void);
void nannyCheckEmptySystem(BOOLEAN clean, BOOLEAN prompt);

void nannyReportMessage(char *message);
void nannyReportRemoteMessage(char *message);
void nannyReportLocalMessage(char *message);
void nannyReportDualMessage(char *message);

void robustPassMessage(char *machine, char *message);
void robustPassLocalReply(int id, char *message);

BOOLEAN nannyDestroyProgram(char *name);

#endif /* NANNYUTILS_H_INCLUDE */

