
/*****************************************************************************
 * PROJECT: XAVIER
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: nannyDev.h
 *
 * ABSTRACT:
 * 
 * This file provides routines for connecting Nanny to other nanny processes
 * or interface processes.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/nannyDev.h,v $ 
 * $Revision: 1.4 $
 * $Date: 1996/08/05 16:08:07 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: nannyDev.h,v $
 * Revision 1.4  1996/08/05  16:08:07  rich
 * Added comments to endifs.
 *
 * Revision 1.3  1996/02/20  11:40:36  josullvn
 * Made extensive changes:
 *    added xfRunConsole, an xforms based interface which was quick
 *    To change the interface, from the nanny dir run
 *    /afs/cs/user/josullvn/xforms/DESIGN/fdesign xfConsole
 *    to get going, and made debugging easier.
 *    added tons of comments.
 *    Debug spews a lot more info back, so just compile
 *    with DEBUG=DEBUG if you really need it.
 *    I've added some timeouts to the code, which will
 *    probably be tweaked later. There are in xfCallbacks.c
 *    Its become better at keeping processes going, and
 *    so its harder to quit. Using shutdown can be
 *    painful. Killing the processes individually is
 *    probably better. Need to do a reverse dependancy when quitting.
 *    Multiple machines are again poor. It doesn't wait sufficently
 *    for dependencies - so you need to run things explicitly...
 *
 * Revision 1.2  1996/01/22  21:26:13  reids
 * Created function "theLocalDevice"
 *
 * Revision 1.1  1995/12/17  20:25:48  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.13  1995/08/14  22:40:46  rich
 * Changes for the new functional devUtils (8.1.6).
 * "-clean" option on nanny now prompts before killing tasks, unless the
 * "-noprompt" flag is used.
 *
 * Revision 1.12  1995/08/06  00:05:07  rich
 * Changes for new devUtils in tca-8.1.
 *
 * Revision 1.11  1995/07/11  06:58:49  josullvn
 * Added capabilities for inter-nanny communication.
 * Mainly, there is now a list of connections, and each new executable is
 * announced to the whole list - may need to work on the kill part...
 *
 * Revision 1.10  1995/06/25  01:03:47  rich
 * Moved devUtils to tca.
 *
 * Revision 1.9  1995/06/06  01:01:35  rich
 * Added return types to local message passing routines.
 *
 * Revision 1.8  1995/05/12  18:48:34  rich
 * Changed program output parser to break lines on \n
 *
 * Revision 1.7  1995/05/12  12:58:26  josullvn
 * Wheee. Running locally, its just about ready.
 * Catching and restarting children isn't fully implemented yet, reloading
 * leaves to be desired, and there is still those new widget and filter bugs.
 * The simulator.c is also updated. Since the -s optoin to the simulator can't
 * handle localhost, it is now geared up for stomach. starting, say, navigate
 * will cause a chain of dependencies to be fired.
 *
 * Revision 1.6  1995/05/11  19:02:47  rich
 * Fixed some communications problems.
 *
 * Revision 1.5  1995/05/11  02:13:31  rich
 * Added routine for nanny to reply to local client.
 *
 * Revision 1.4  1995/05/11  01:22:54  rich
 * Both now compile.
 *
 * Revision 1.3  1995/05/10  18:33:10  rich
 * Added the routines to handle program output.
 *
 * Revision 1.2  1995/05/10  06:38:09  josullvn
 * More fiddling - added some stubs to nannyDev.h...
 *
 * Revision 1.1  1995/05/10  02:39:35  rich
 * Forgot to add the nanny files.
 *
 *
 *****************************************************************************/

#ifndef NANNY_DEV_LOADED
#define NANNY_DEV_LOADED

#include "tca/devUtils.h"

#define NANNY_SERVER_PORT 9002
#define NANNY_SERVER_NAME ":NANNY"

/* Max of 100 devices. */
#define MAX_NANNY_DEVS 100

typedef void 
(*INIT_FN)(void);

typedef void 
(*REMOTE_PARSER_FN)(const char *, char*);

typedef void 
(*PARSER_FN)(int, char*);

/* structure for nannyulated devices */

typedef struct {
  DEV_PTR dev;
  DEV_LINE_BUFFER_PTR lineBuf;
  PARSER_FN parser;
  REMOTE_PARSER_FN remoteParser;
}  NANNY_DEV_TYPE, *NANNY_DEV_PTR;

/* structure for the server device. */

typedef struct {
  DEV_PTR dev;
  int numDevs;
  NANNY_DEV_PTR devs[MAX_NANNY_DEVS];
}  NANNY_TYPE, *NANNY_PTR;

void Nanny_outputHnd(int fd, long ignore);
BOOLEAN nannyServerInitialize(PARSER_FN outputParser,
			      PARSER_FN localParser,
			      REMOTE_PARSER_FN remoteParser);


void nanny_connect(PARSER_FN localParser);
void Nanny_addDevice(NANNY_DEV_PTR dev);

/*
   To handle output from processes created by nanny, we inform
   the nanny monitoring loop that a fd exists, and thereafter information 
   arriving on that fd will cause a function 
      processOutputMessage(char *name, char *message)
   to be executed.
*/
/*
   fd = file descriptor to monitor.
   name = a string to be use for identifying messages 
         (a typical string could be "CTR")
 */
NANNY_DEV_PTR Nanny_addFd(int stdinFd, int stdoutFd, int stderrFd, char *name);
BOOLEAN Nanny_removeFd(int fd);

BOOLEAN passMessage(char *machine, char *message);
BOOLEAN passLocalMessage(char *message);
BOOLEAN passLocalReply(int id,char *message);

extern NANNY_DEV_PTR theLocalDevice(void);

#endif /* NANNY_DEV_LOADED */
