/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: nanny.h
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/nannyCommon.h,v $
 * $Revision: 1.4 $
 * $Date: 1996/08/05 16:08:06 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: nannyCommon.h,v $
 * Revision 1.4  1996/08/05  16:08:06  rich
 * Added comments to endifs.
 *
 * Revision 1.3  1996/02/20  11:40:33  josullvn
 * Made extensive changes:
 *    added xfRunConsole, an xforms based interface which was quick
 *    To change the interface, from the nanny dir run
 *    /afs/cs/user/josullvn/xforms/DESIGN/fdesign xfConsole
 *    to get going, and made debugging easier.
 *    added tons of comments.
 *    Debug spews a lot more info back, so just compile
 *    with DEBUG=DEBUG if you really need it.
 *    I've added some timeouts to the code, which will
 *    probably be tweaked later. There are in xfCallbacks.c
 *    Its become better at keeping processes going, and
 *    so its harder to quit. Using shutdown can be
 *    painful. Killing the processes individually is
 *    probably better. Need to do a reverse dependancy when quitting.
 *    Multiple machines are again poor. It doesn't wait sufficently
 *    for dependencies - so you need to run things explicitly...
 *
 * Revision 1.2  1996/01/22  21:27:50  reids
 * Consolidated all the DEBUG and WARNING macro definitions into nannyCommon.h
 *
 * Revision 1.1  1995/12/17  20:25:45  rich
 * Moved Nanny to the tca release.
 *
 *
 *****************************************************************************/

#ifndef NANNY_COMMON_H_INCLUDED
#define NANNY_COMMON_H_INCLUDED

#define DEFAULT_LINE_LENGTH 80

#ifdef DEBUG
#define DEBUG1(x) fprintf(stderr,x)
#define DEBUG2(x,y) fprintf(stderr,x,y)
#define DEBUG3(x,y,z) fprintf(stderr,x,y,z)
#define DEBUG5(x,y,z,a,b) fprintf(stderr,x,y,z,a,b)
#else
#define DEBUG1(x) 
#define DEBUG2(x,y) 
#define DEBUG3(x,y,z) 
#define DEBUG5(x,y,z,a,b) 
#endif
#define RDEBUG2(x,y) DEBUG2(x,y)

#define WARNING1(x) fprintf(stderr,x)
#define WARNING2(x,y) fprintf(stderr,x,y)
#define WARNING3(x,y,z) fprintf(stderr,x,y,z)

#endif /* NANNY_COMMON_H_INCLUDED */
