/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: messages.h
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/messages.h,v $
 * $Revision: 1.3 $
 * $Date: 1996/08/05 16:08:03 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: messages.h,v $
 * Revision 1.3  1996/08/05  16:08:03  rich
 * Added comments to endifs.
 *
 * Revision 1.2  1996/06/28  14:07:20  reids
 * Fixed quite a few bugs -- with graphics, interaction with script, and
 *   killing processes
 *
 * Revision 1.1  1995/12/17  20:25:42  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.15  1995/09/28  19:31:59  josullvn
 * Lots o changes
 *
 * Revision 1.14  1995/08/06  00:04:59  rich
 * Changes for new devUtils in tca-8.1.
 *
 * Revision 1.13  1995/07/15  22:40:48  josullvn
 * Had deleted the line which announce new processes by mistake
 *
 * Revision 1.12  1995/07/13  11:09:45  josullvn
 * Two bugs were present. a) syscalls were being interrupted, and b) the
 * processes button management got screwy after a while. The first is due
 * to Devutils, second fixed by removing a reliance on xclient data. Also
 * added features to newProcess whereby it is now menu driven.
 * Added tca.rc, removing those processes from the Simulator resource files.
 *
 * Revision 1.11  1995/07/11  22:59:12  josullvn
 * Needed to retain the concept of who sent a message, and so had to
 * restructure all the message passing. Also, made sure we don't
 * overwrite any of the parameters due to reentry problems.
 *
 * Revision 1.10  1995/07/11  11:21:32  josullvn
 * A lot more changes to message passing to handle multiple nannys better.
 * This basically involved removing fdclient, and being smarter about what
 * nannys are in the system
 *
 * Revision 1.9  1995/07/11  01:06:30  josullvn
 * Whesh. OK, fixed a bug in parsing lines, where by if messages get corrupted,
 * we can recover. Added a -clean option to nanny. Discovered that the old
 * double newProcess bug has returned to haunt me.
 *
 * Revision 1.8  1995/07/04  05:46:26  josullvn
 * The latest update. Some stuff vanished (???), but recovered a bit.
 * Now have improved notification of whats happening between runConsole
 * and nanny, and better starting off of processes.
 *
 * Revision 1.7  1995/05/23  23:58:35  josullvn
 * Yeah. Fixed the SIGCHLD problem (tured out that popen is internally
 * implemented with fork - when pclose was called, it generated a SIGCHLD
 * which intereupted the system call which lead to trouble).
 * Fixed environment variables, can now add env variables in .rc file, and
 * they are passed to appropriate child. Realized that need to also
 * provide an ability to pass the display variable from runConsole to the
 * nanny - being worked on.
 * Bug exists in devUtils (?) which large data streams. Run csh as a new process
 * and do ps auxww to cause it to occur.
 *
 * Revision 1.6  1995/05/15  17:07:16  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 *
 *****************************************************************************/
#ifndef MESSAGES_H_INCLUDED
#define MESSAGES_H_INCLUDED
#include "tca/libc.h"

char *messageExtractKey(char *buf, char *key);
BOOLEAN parseLine(BOOLEAN l, const char *r, int id, char *buf);

void messageMakeExec(char *buf, char *name, char *display);
void messageMakeRestart(char *buf, char *name);
void messageMakeQuiet(char *buf, char *name);
void messageMakeDestroy(char *buf, char *name);
void messageMakeEnquire(char *buf, char *name);
void messageMakeStatus(char *buf, char *name, char *status);
void messageMakeSilent(char *buf, char *name);
void messageMakeVerbose(char *buf, char *name);
void messageMakeKill(char *buf, char *name);
void messageMakeCommand(char *buf, char *name, char *command);
void messageMakeAnnounce(char *buf, char *ack, BOOLEAN readyP);
void messageMakeFlush(char *buf, char *name);
void messageMakeBreak(char *buf, char *name);
void messageMakePause(char *buf, char *name);
void messageMakeContinue(char *buf, char *name);
void messageMakeReload(char *buf);
void messageMakePing(char *buf);
void messageMakeAck(char *buf, char *);
void messageMakeNAck(char *buf, char *);
void messageMakeInfo(char *buf, char *name, int stderrp, char *info);
void messageMakeBeat(char *buf, char *name);
void messageMakeList(char *buf, char *list);
void messageMakeDead(char *buf, char *list);

#endif /* MESSAGES_H_INCLUDED */
