
/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: messages.c
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/messages.c,v $
 * $Revision: 1.4 $
 * $Date: 1996/06/28 14:07:18 $
 * $Author: reids $
 *
 * REVISION HISTORY:
 *
 * $Log: messages.c,v $
 * Revision 1.4  1996/06/28  14:07:18  reids
 * Fixed quite a few bugs -- with graphics, interaction with script, and
 *   killing processes
 *
 * Revision 1.3  1996/02/10  16:52:14  rich
 * Made private functions static and fixed some forward declarations.
 *
 * Revision 1.2  1996/01/22  21:27:45  reids
 * Consolidated all the DEBUG and WARNING macro definitions into nannyCommon.h
 *
 * Revision 1.1  1995/12/17  20:25:40  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.27  1995/09/28  19:31:57  josullvn
 * Lots o changes
 *
 * Revision 1.26  1995/08/06  00:04:57  rich
 * Changes for new devUtils in tca-8.1.
 *
 * Revision 1.25  1995/07/15  23:46:29  josullvn
 * Extra \n's were being appended occasioanlly to messages.
 * Running a program localhost on multiple machines is currently bad.
 * Adjusted Simulator2.rc
 *
 * Revision 1.24  1995/07/15  07:13:06  josullvn
 * ProcessDevices is _not_ reentrant - this was causing lots of problems as it
 * turns out. Restructing my blocking code fixed it.
 * Also, added a notion of dead - that is telling when something has
 * finally died.
 *
 * Revision 1.23  1995/07/13  11:09:43  josullvn
 * Two bugs were present. a) syscalls were being interrupted, and b) the
 * processes button management got screwy after a while. The first is due
 * to Devutils, second fixed by removing a reliance on xclient data. Also
 * added features to newProcess whereby it is now menu driven.
 * Added tca.rc, removing those processes from the Simulator resource files.
 *
 * Revision 1.22  1995/07/12  02:01:02  josullvn
 * Made hostname matching more lenient
 *
 * Revision 1.21  1995/07/12  01:39:10  josullvn
 * Dooh. Had local and remote reversed.
 *
 * Revision 1.20  1995/07/12  01:29:06  josullvn
 * Added host information to my messages, as not happy with
 * what nannydev is doing.
 *
 * Revision 1.19  1995/07/11  22:59:11  josullvn
 * Needed to retain the concept of who sent a message, and so had to
 * restructure all the message passing. Also, made sure we don't
 * overwrite any of the parameters due to reentry problems.
 *
 * Revision 1.18  1995/07/11  11:49:17  josullvn
 * Needed to notify any new nanny immediately upon noticing them.
 * Otherwise, run into trouble during exec...
 *
 * Revision 1.17  1995/07/11  11:21:30  josullvn
 * A lot more changes to message passing to handle multiple nannys better.
 * This basically involved removing fdclient, and being smarter about what
 * nannys are in the system
 *
 * Revision 1.16  1995/07/11  01:06:25  josullvn
 * Whesh. OK, fixed a bug in parsing lines, where by if messages get corrupted,
 * we can recover. Added a -clean option to nanny. Discovered that the old
 * double newProcess bug has returned to haunt me.
 *
 * Revision 1.15  1995/07/09  05:25:10  josullvn
 * Added TCA test suite to Simulator.rc - helps with debugging
 * Fixed a display inheritance bug that interfere with dependancies starting up.
 * Fixed a problem with parsing data.
 * Improved communication feedbacks to runConsole from nanny.
 *
 * Revision 1.14  1995/07/04  05:46:25  josullvn
 * The latest update. Some stuff vanished (???), but recovered a bit.
 * Now have improved notification of whats happening between runConsole
 * and nanny, and better starting off of processes.
 *
 * Revision 1.13  1995/05/25  02:50:05  rich
 * Fixed lookup for nanny device and lost character problem.
 *
 * Revision 1.12  1995/05/23  23:58:34  josullvn
 * Yeah. Fixed the SIGCHLD problem (tured out that popen is internally
 * implemented with fork - when pclose was called, it generated a SIGCHLD
 * which intereupted the system call which lead to trouble).
 * Fixed environment variables, can now add env variables in .rc file, and
 * they are passed to appropriate child. Realized that need to also
 * provide an ability to pass the display variable from runConsole to the
 * nanny - being worked on.
 * Bug exists in devUtils (?) which large data streams. Run csh as a new process
 * and do ps auxww to cause it to occur.
 *
 * Revision 1.11  1995/05/20  02:07:31  josullvn
 * Some more bells and whistles to the console callback.
 * Added environment variables to the resource definition.
 * Extended the still buggy children catching for time outs.
 * Added diagnositic code to analyze startup failures.
 *
 * Revision 1.10  1995/05/19  11:32:25  josullvn
 * Updated resource files to include "ready strings"
 * Debugged some protocol problems with messages.c parsing of split lines.
 * (Feel that remaining problem is in devUtils).
 * Added Highlightening to buttons.
 * Removed SIGCHLD trapping - its too flakey at the moment.
 *
 * Revision 1.9  1995/05/17  23:39:31  josullvn
 * Now restarts dead processes - need to add timeouts.
 *
 * Revision 1.8  1995/05/15  17:07:14  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 *
 *****************************************************************************/
#include "tca/libc.h"

#include "nannyUtils.h"
#include "messages.h"
#include "messageHandle.h"
#include "resource.h"

static BOOLEAN messageEndLinep(char *buf)
{
  return (*buf == '\0');
}

static char *messageSkipWhitespace(char *buf)
{
  while ((!messageEndLinep(buf)) && (isspace(*buf)))
      buf++;

  return buf;
}

char *messageExtractKey(char *buf, char *key)
{
  int i=0;
  
  buf = messageSkipWhitespace(buf);
  while (!messageEndLinep(buf) && !isspace(*buf) )
    key[i++] = *(buf++);

  key[i++] = '\0';
  return buf;
}

/*
 * Pretty much the key communiction protocol implementor. 
 * It gets in a message via the socket, where this message can
 * contain several parsable lines. It must remember whether 
 * a previous message is short characters, split up the 
 * incoming data, and remember unterminate messages for
 * future handling.
 * The one assumption to make is that each message is atomic
 * Jul 10th: 
 * Bug noticed if we lose part of message, or message gets overwritten.
 * No recovery is currently possible. 
 */
BOOLEAN parseLine(BOOLEAN l, const char *r, int id, char *buf)
{
  static char oldbuf[MAXBUF+1]; 
  static int  oldlen;
  static BOOLEAN weHaveAnUnterminatedMessage = FALSE;
  BOOLEAN     foundErrorinMessages = FALSE;
  char        key[MAXTOKEN], len[MAXTOKEN], host[MAXTOKEN];
  char        copy[MAXBUF+1], *cptr; 
  char        *bufp = buf; 
  int         i, ret, length;
  static char *thisHost = NULL;

  if (thisHost == NULL) {
    thisHost = (char *)malloc(80);
    gethostname(thisHost, 80);  
    for (i = 0; i<80; i++)
      if (thisHost[i] == '.')
	thisHost[i]='\0';
  }

  while ((strlen(bufp)) && (!foundErrorinMessages))
    {
      if (weHaveAnUnterminatedMessage)
	{
	  /* 
	   * 2 cases:
	   * 1) The new buf is long enough to have the rest of the data
	   * 2) Its not!
	   */
	  if (strlen(bufp) >= oldlen-strlen(oldbuf))
	    {
	      weHaveAnUnterminatedMessage = FALSE;

	      /* Move it out of buf, into the local copy */
	      for (i = 0; i<strlen(oldbuf); i++)
		copy[i] = oldbuf[i];

	      for (; i<oldlen; i++)
		copy[i] = *(bufp++); 
	      copy[i]='\0';
	    }
	  else 
	    {
	      int oldbuflen = strlen(oldbuf);

	      /* not enough string, going to have to wait for more text */
	      for (i=0; i<strlen(bufp); i++)
		oldbuf[oldbuflen++] = *(bufp++); 
	      oldbuf[oldbuflen]='\0';
	      weHaveAnUnterminatedMessage = TRUE;
	    }
	}
      else {
	/* Get the length of this message */
	bufp = messageExtractKey(bufp, len);
	length = atoi(len);

	if (strlen(bufp) >= length)
	  {
	    /* Make a local copy */
	    for (i = 0; i<length; i++)
	      copy[i] = *(bufp++); 
	    copy[i]='\0';
	  }
	else {
	    oldlen = length;

	    /* strlen had been in the loop as the termination cond.
	     * This had a nasty side effect since bufp was incremented 
	     * within the loop 
	     */
	    length = strlen(bufp); 
	    for (i=0; i<length; i++)
	      oldbuf[i] = *(bufp++); 
	    oldbuf[i]='\0';

	    weHaveAnUnterminatedMessage = TRUE;
	  }
      }

      if (!weHaveAnUnterminatedMessage)
	{ 
	  /* 
	   * We do not remove the key from the string here
	   * - we leave that up to the handler 
	   */
	  cptr = messageExtractKey(copy, host);
	  if (strstr(host,thisHost) != NULL)
	    l = TRUE;
	  else
	    l = FALSE;

	  messageExtractKey(cptr, key);

	  if (!strcmp(key, "EXEC:")) ret =  parseExec(l,host,id,cptr);
	  else if (!strcmp(key, "STDIN:")) ret = parseStdin(l,host,id,cptr);
	  else if (!strcmp(key, "STDOUT:")) ret = parseStdout(l,host,id,cptr);
	  else if (!strcmp(key, "ERROR:")) ret = parseError(l,host,id,cptr);
	  else if (!strcmp(key, "KILL:")) ret = parseKill(l,host,id,cptr);
	  else if (!strcmp(key, "QUIET:")) ret = parseQuiet(l,host,id,cptr);
	  else if (!strcmp(key, "SILENT:")) ret = parseSilent(l,host,id,cptr);
	  else if (!strcmp(key, "VERBOSE:")) ret = parseVerbose(l,host,id,cptr);
	  else if (!strcmp(key, "ENQUIRE:")) ret = parseEnquire(l,host,id,cptr);
	  else if (!strcmp(key, "STATUS:")) ret = parseStatus(l,host,id,cptr);
	  else if (!strcmp(key, "RELOAD:")) ret = parseReload(l,host,id,cptr);
	  /* else if (!strcmp(key, "RESTART:")) ret = parseRestart(l,host,id,cptr);*/
	  else if (!strcmp(key, "ANNOUNCE:")) ret = parseAnnounce(l,host,id,cptr);
	  else if (!strcmp(key, "PING:")) ret = parsePing(l,host,id,cptr);
	  else if (!strcmp(key, "DESTROY:")) ret = parseDestroy(l,host,id,cptr);
	  else if (!strcmp(key, "ACK:")) ret = parseAck(l,host,id,cptr);
	  else if (!strcmp(key, "NACK:")) ret = parseNack(l,host,id,cptr);
	  else if (!strcmp(key, "FLUSH:")) ret = parseFlush(l,host,id,cptr);
	  else if (!strcmp(key, "BREAK:")) ret = parseBreak(l,host,id,cptr);
	  else if (!strcmp(key, "BEAT:")) ret = parseBeat(l,host,id,cptr);
	  else if (!strcmp(key, "PAUSE:")) ret = parsePause(l,host,id,cptr);
	  else if (!strcmp(key, "CONT:")) ret = parseContinue(l,host,id,cptr);
	  else if (!strcmp(key, "DEAD:")) ret = parseDead(l,host,id,cptr);
	  else if (!strcmp(key, "LIST:")) ret = parseList(l,host,id,cptr);
	  else{
	    WARNING2("PARSE: received %s which \n", buf);
	    WARNING2("PARSE: expanded to --%s--\n", copy);
	    WARNING2("PARSE: containing unknown key --%s--\n", key);
	    WARNING1("PARSE: trying to recover (messages may be lost)\n");
	    foundErrorinMessages = TRUE;
	  }
	}
    }

  return FALSE;
} 

static void messageAddr(char *buf)
{
  char newbuf[MAXBUF+1];
  static char *thisHost= NULL;
  int  i, len = strlen(buf);

  if (thisHost == NULL) {
    thisHost = (char *)malloc(80);
    gethostname(thisHost, 80);  
    for (i = 0; i<80; i++)
      if (thisHost[i] == '.')
	thisHost[i]='\0';
  }

  for (i=0; i<len+1; i++)
    newbuf[i] = buf[i];

  sprintf(buf, "%s %s", thisHost, newbuf);
}

static void messageCount(char *buf)
{
  char newbuf[MAXBUF+1];
  int  i, len; 

  messageAddr(buf);
  len = strlen(buf);
  for (i=0; i<len+1; i++)
    newbuf[i] = buf[i];
  sprintf(buf, "%d %s", len+1, newbuf);
}

void messageMakeExec(char *buf, char *name, char *display)
{
  static char realDisplay[DEFAULT_LINE_LENGTH];
  
  if (display[0] == ':') {
    gethostname(realDisplay, DEFAULT_LINE_LENGTH);
    strcat(realDisplay, ":0.0");
    sprintf(buf, "EXEC: %s %s", name, realDisplay);
  } else {
    sprintf(buf, "EXEC: %s %s", name, display);
  }
  messageCount(buf);
}

void messageMakeDestroy(char *buf, char *name)
{
  sprintf(buf, "DESTROY: %s", name);
  messageCount(buf);
}

/*void messageMakeRestart(char *buf, char *name)*/
/*{*/
/*  sprintf(buf, "RESTART: %s", name);*/
/*  messageCount(buf);*/
/*}*/

void messageMakeQuiet(char *buf, char *name)
{
  sprintf(buf, "QUIET: %s", name);
  messageCount(buf);
}

void messageMakeEnquire(char *buf, char *name)
{
  sprintf(buf, "ENQUIRE: %s", name);
  messageCount(buf);
}

void messageMakeStatus(char *buf, char *name, char *status)
{
  sprintf(buf, "STATUS: %s %s", name, status);
  messageCount(buf);
}

void messageMakeSilent(char *buf, char *name)
{
  sprintf(buf, "SILENT: %s", name);
  messageCount(buf);
}

void messageMakeVerbose(char *buf, char *name)
{
  sprintf(buf, "VERBOSE: %s", name);
  messageCount(buf);
}

void messageMakeKill(char *buf, char *name)
{
  sprintf(buf, "KILL: %s", name);
  messageCount(buf);
}

void messageMakeCommand(char *buf, char *name, char *command)
{
  sprintf(buf, "STDOUT: %s %s", name, command);
  messageCount(buf);
}

void messageMakeInfo(char *buf, char *name, int stderrp, char *info)
{
  if (stderrp)
    sprintf(buf, "ERROR: %s %s", name, info);
  else
    sprintf(buf, "STDIN: %s %s", name, info);
  messageCount(buf);
}

void messageMakeAnnounce(char *buf, char *ack, BOOLEAN readyP)
{
  sprintf(buf, "ANNOUNCE: %s%s", ack, (readyP ? "" : " wait"));
  messageCount(buf);
}

void messageMakeDead(char *buf, char *ack)
{
  sprintf(buf, "DEAD: %s", ack);
  messageCount(buf);
}

void messageMakeAck(char *buf, char *ack)
{
  sprintf(buf, "ACK: %s", ack);
  messageCount(buf);
}

void messageMakeNAck(char *buf, char *ack)
{
  sprintf(buf, "NACK: %s", ack);
  messageCount(buf);
}

void messageMakeFlush(char *buf, char *name)
{
  sprintf(buf, "FLUSH: %s", name);
  messageCount(buf);
}

void messageMakeBreak(char *buf, char *name)
{
  sprintf(buf, "BREAK: %s", name);
  messageCount(buf);
}

void messageMakePause(char *buf, char *name)
{
  sprintf(buf, "PAUSE: %s", name);
  messageCount(buf);
}

void messageMakeContinue(char *buf, char *name)
{
  sprintf(buf, "CONT: %s", name);
  messageCount(buf);
}

void messageMakePing(char *buf)
{
  sprintf(buf, "PING: ");
  messageCount(buf);
}

void messageMakeReload(char *buf)
{
  sprintf(buf, "RELOAD: ");
  messageCount(buf);
}

void messageMakeList(char *buf, char *list)
{
  sprintf(buf, "LIST: %s", list);
  messageCount(buf);
}
