/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: messageNannyHandle.c
 *
 * ABSTRACT: Handle messages sent to the nanny.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/messageNannyHandle.c,v $
 * $Revision: 1.6 $
 * $Date: 1996/07/29 05:03:07 $
 * $Author: josullvn $
 *
 * REVISION HISTORY:
 *
 * $Log: messageNannyHandle.c,v $
 * Revision 1.6  1996/07/29  05:03:07  josullvn
 * Bloody hell. This commiting is a bit different than under Xavier. Short
 * story is cleaned up some purify bugs, and also made changes to nanny
 * which should make it a bit better - Improving performance over multiple
 * machines, explict quietening of nondisplayed processes, replacing of
 * runConsole with xfMiniConsole, which is multithreaded, vt102 compilant,
 * adds a uniform emacs-like command line editing feature, better on small
 * screens and otherwise fab.
 *
 * Revision 1.5  1996/06/28  14:07:17  reids
 * Fixed quite a few bugs -- with graphics, interaction with script, and
 *   killing processes
 *
 * Revision 1.4  1996/02/20  11:40:29  josullvn
 * Made extensive changes:
 *    added xfRunConsole, an xforms based interface which was quick
 *    To change the interface, from the nanny dir run
 *    /afs/cs/user/josullvn/xforms/DESIGN/fdesign xfConsole
 *    to get going, and made debugging easier.
 *    added tons of comments.
 *    Debug spews a lot more info back, so just compile
 *    with DEBUG=DEBUG if you really need it.
 *    I've added some timeouts to the code, which will
 *    probably be tweaked later. There are in xfCallbacks.c
 *    Its become better at keeping processes going, and
 *    so its harder to quit. Using shutdown can be
 *    painful. Killing the processes individually is
 *    probably better. Need to do a reverse dependancy when quitting.
 *    Multiple machines are again poor. It doesn't wait sufficently
 *    for dependencies - so you need to run things explicitly...
 *
 * Revision 1.3  1996/02/10  16:52:13  rich
 * Made private functions static and fixed some forward declarations.
 *
 * Revision 1.2  1996/01/22  21:27:43  reids
 * Consolidated all the DEBUG and WARNING macro definitions into nannyCommon.h
 *
 * Revision 1.1  1995/12/17  20:25:39  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.28  1995/09/28  19:31:55  josullvn
 * Lots o changes
 *
 * Revision 1.27  1995/07/15  23:46:27  josullvn
 * Extra \n's were being appended occasioanlly to messages.
 * Running a program localhost on multiple machines is currently bad.
 * Adjusted Simulator2.rc
 *
 * Revision 1.26  1995/07/15  22:40:46  josullvn
 * Had deleted the line which announce new processes by mistake
 *
 * Revision 1.25  1995/07/15  07:13:03  josullvn
 * ProcessDevices is _not_ reentrant - this was causing lots of problems as it
 * turns out. Restructing my blocking code fixed it.
 * Also, added a notion of dead - that is telling when something has
 * finally died.
 *
 * Revision 1.24  1995/07/13  14:26:27  josullvn
 * Cosmetic mods (printfs etc)
 *
 * Revision 1.23  1995/07/13  11:09:40  josullvn
 * Two bugs were present. a) syscalls were being interrupted, and b) the
 * processes button management got screwy after a while. The first is due
 * to Devutils, second fixed by removing a reliance on xclient data. Also
 * added features to newProcess whereby it is now menu driven.
 * Added tca.rc, removing those processes from the Simulator resource files.
 *
 * Revision 1.22  1995/07/12  13:53:42  josullvn
 * See previous.
 *
 * Revision 1.21  1995/07/12  13:43:34  josullvn
 * Doh, had introduced a bug when an unknown process name wsa entered.
 *
 * Revision 1.20  1995/07/12  02:46:06  josullvn
 * Test the result of message passing commands for failure
 *
 * Revision 1.19  1995/07/11  22:59:09  josullvn
 * Needed to retain the concept of who sent a message, and so had to
 * restructure all the message passing. Also, made sure we don't
 * overwrite any of the parameters due to reentry problems.
 *
 * Revision 1.18  1995/07/11  12:10:25  josullvn
 * Needed Execing and Killing to wait for remote dependancies properly.
 *
 * Revision 1.17  1995/07/11  11:21:29  josullvn
 * A lot more changes to message passing to handle multiple nannys better.
 * This basically involved removing fdclient, and being smarter about what
 * nannys are in the system
 *
 * Revision 1.16  1995/07/11  06:58:45  josullvn
 * Added capabilities for inter-nanny communication.
 * Mainly, there is now a list of connections, and each new executable is
 * announced to the whole list - may need to work on the kill part...
 *
 * Revision 1.15  1995/07/11  01:06:21  josullvn
 * Whesh. OK, fixed a bug in parsing lines, where by if messages get corrupted,
 * we can recover. Added a -clean option to nanny. Discovered that the old
 * double newProcess bug has returned to haunt me.
 *
 * Revision 1.14  1995/07/09  05:25:08  josullvn
 * Added TCA test suite to Simulator.rc - helps with debugging
 * Fixed a display inheritance bug that interfere with dependancies starting up.
 * Fixed a problem with parsing data.
 * Improved communication feedbacks to runConsole from nanny.
 *
 * Revision 1.13  1995/07/04  05:46:23  josullvn
 * The latest update. Some stuff vanished (???), but recovered a bit.
 * Now have improved notification of whats happening between runConsole
 * and nanny, and better starting off of processes.
 *
 * Revision 1.12  1995/06/25  01:03:37  rich
 * Moved devUtils to tca.
 *
 * Revision 1.11  1995/06/15  22:11:03  rich
 * Linux 1.2 changes. Still does not compile.
 *
 * Revision 1.9  1995/05/25  02:50:01  rich
 * Fixed lookup for nanny device and lost character problem.
 *
 * Revision 1.8  1995/05/24  15:50:42  josullvn
 * Had deleted two lines by accident in nannyUtils which prevented commands being
 * passed to processes. More support for intermachine communication. Now
 * can do rcsh to run a csh shell remotely on heart (according to new
 * Simulator.rc file)
 *
 * Revision 1.7  1995/05/23  23:58:32  josullvn
 * Yeah. Fixed the SIGCHLD problem (tured out that popen is internally
 * implemented with fork - when pclose was called, it generated a SIGCHLD
 * which intereupted the system call which lead to trouble).
 * Fixed environment variables, can now add env variables in .rc file, and
 * they are passed to appropriate child. Realized that need to also
 * provide an ability to pass the display variable from runConsole to the
 * nanny - being worked on.
 * Bug exists in devUtils (?) which large data streams. Run csh as a new process
 * and do ps auxww to cause it to occur.
 *
 * Revision 1.6  1995/05/20  02:07:29  josullvn
 * Some more bells and whistles to the console callback.
 * Added environment variables to the resource definition.
 * Extended the still buggy children catching for time outs.
 * Added diagnositic code to analyze startup failures.
 *
 * Revision 1.5  1995/05/19  11:32:23  josullvn
 * Updated resource files to include "ready strings"
 * Debugged some protocol problems with messages.c parsing of split lines.
 * (Feel that remaining problem is in devUtils).
 * Added Highlightening to buttons.
 * Removed SIGCHLD trapping - its too flakey at the moment.
 *
 * Revision 1.4  1995/05/15  17:16:44  rich
 * Added nanny.h and moved external declarations to the .h files.
 *
 * Revision 1.3  1995/05/15  17:07:12  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 *
 *****************************************************************************/
#include "tca/libc.h"

#include "nannyDev.h"
#include "nannyUtils.h"
#include "messages.h"
#include "messageHandle.h"
#include "resource.h"
#include "nanny.h"
#include "tca/devUtils.h"


/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseExec(BOOLEAN local, char *remote, int id, char *buf)
{
  char  name[MAXTOKEN]; 
  char  display[MAXTOKEN]; 
  char  displayenv[DEFAULT_LINE_LENGTH]; 
  char  exec[DEFAULT_LINE_LENGTH]; 
  char  ack[MAXBUF];
  char  _remote[MAXBUF];

  strcpy(_remote,remote);

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, display);

  sprintf(displayenv, "DISPLAY=%s", display);

  if (rcLookupName(name) != -1) {
    rcInsertStr(rcLookupName(name), rcEntENVS, displayenv);
    rcInsertStr(rcLookupName(name), rcEntDISPLAY, display);
  }

  if (local) {
    nannyConnectNote(FALSE, NULL, id);
    if (rcLookupName(name) != -1) {
      rcProgramPtr r;
      
      r = &(rcAvailableProgramList[rcLookupName(name)]);
      nannyConnectNote(!r->local, r->remoteMachine,id);
    }
  } else {
    if (rcLookupName(name) != -1) 
      nannyConnectNote(TRUE, _remote,-1);
  }
  
  messageMakeExec(exec, name, display);
  if (nannyExecProgram(name))
    /* We see what sub processes have started up... */
    return parsePing(local,_remote,id,NULL);
  else
    messageMakeNAck(ack, exec);
  
  if ((rcLookupName(name) == -1) ||
      rcAvailableProgramList[rcLookupName(name)].local) {
    if (local)
      robustPassLocalReply(id, ack);
    else
      robustPassMessage(_remote, ack);
  }
  
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseKill(BOOLEAN local, char *remote, int id, char *buf)
{
  char  name[MAXTOKEN]; 
  char  kill[DEFAULT_LINE_LENGTH]; 
  char  ack[MAXBUF]; 
  char  _remote[MAXBUF];
  BOOLEAN ok;

  strcpy(_remote,remote);

  buf = messageExtractKey(buf, name);
  messageExtractKey(buf, name);

  messageMakeKill(kill, name);
  ok = nannyKillProgram(name);

  if (ok)
    messageMakeAck(ack, kill);
  else 
    messageMakeNAck(ack, kill);

  if ((rcLookupName(name) == -1) ||
      rcAvailableProgramList[rcLookupName(name)].local) {
    if (local)
      robustPassLocalReply(id, ack);
    else
      robustPassMessage(_remote, ack);
  }
  
  if (ok) {
    messageMakeDead(ack, name);
    nannyReportDualMessage(ack);
  }
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseDestroy(BOOLEAN local, char *remote, int id, char *buf)
{
  char  name[MAXTOKEN]; 
  char  destroy[DEFAULT_LINE_LENGTH]; 
  char  ack[MAXBUF]; 
  char  _remote[MAXBUF];
  BOOLEAN ok;

  strcpy(_remote,remote);

  buf = messageExtractKey(buf, name);
  messageExtractKey(buf, name);

  messageMakeDestroy(destroy, name);
  ok = nannyDestroyProgram(name);

  if (ok)
    messageMakeAck(ack, destroy);
  else 
    messageMakeNAck(ack, destroy);

  if ((rcLookupName(name) == -1) ||
      rcAvailableProgramList[rcLookupName(name)].local) {
    if (local)
      robustPassLocalReply(id, ack);
    else
      robustPassMessage(_remote, ack);
  }
  
  if (ok) {
    messageMakeDead(ack, name);
    nannyReportDualMessage(ack);
  }
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
static BOOLEAN fdwrite(int fd, char *buf, int nChars)
{
  int amountWritten = 0;
  
  if (fd == NO_FD) {
    return FALSE;
  }
  
  while (nChars > 0) {
    amountWritten = write(fd, buf, nChars);
    if (amountWritten < 0) {
      if (errno == EWOULDBLOCK) {
	WARNING1("\nWARNING: fdwrite: EWOULDBLOCK: trying again!\n");
	PAUSE_MIN_DELAY();
      } else {
	return FALSE;
      }
    } else {
      nChars -= amountWritten;
      buf += amountWritten;
    }
  }
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseStdout(BOOLEAN local, char *remote, int id, char *buf)
{
  rcProgramPtr r;
  char bufp[MAXBUF], name[MAXTOKEN];
  char  _remote[MAXBUF];

  strcpy(_remote,remote);

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);
  buf++; 

  rcInsertStr(rcLookupName(name), rcEntIBUF, buf); 

  r = &(rcAvailableProgramList[rcLookupName(name)]);
  if (r->local)
    return fdwrite(r->fdstdin, buf, strlen(buf));
  else {
    messageMakeCommand(bufp, name, buf);
    robustPassMessage(r->remoteMachine, bufp);
  }
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseStdin(BOOLEAN local, char *remote, int id, char *buf)
{
  rcProgramPtr r;
  int r_id;
  char bufp[MAXBUF];
  char name[MAXTOKEN];
  char  _remote[MAXBUF];

  strcpy(_remote,remote);

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);
  buf++; 

  if ( (r_id = rcLookupName(name)) != -1)
    {
      r = &(rcAvailableProgramList[r_id]);
      rcInsertStr(r_id, rcEntIBUF, buf);
      messageMakeInfo(bufp, r->name, FALSE, buf);

      if (r->loudness & VERBOSE)
	nannyReportLocalMessage(bufp);
    }
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseError(BOOLEAN local, char *remote, int id, char *buf)
{
  rcProgramPtr r;
  int r_id;
  char bufp[MAXBUF];
  char name[MAXTOKEN];

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);
  buf++; 

  if ( (r_id = rcLookupName(name)) != -1)
    {
      r = &(rcAvailableProgramList[r_id]);
      rcInsertStr(r_id, rcEntEBUF, buf);
      messageMakeInfo(bufp, r->name, TRUE, buf);

      if (r->loudness & QUIET)
	nannyReportLocalMessage(bufp);
    }
  else
    {
      /* 
       * If we got this, then the message is from down a chain, and we should
       * treat it as if this process created the error itself...
       * Not right yet
       */
      messageMakeInfo(bufp, name, TRUE, buf);
      nannyReportLocalMessage(bufp);
    }
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseReload(BOOLEAN local, char *remote, int id, char *buf)
{
  char  ack[MAXBUF]; 
  char  reload[MAXBUF]; 
  char  _remote[MAXBUF];

  strcpy(_remote,remote);

  if (!rcLoadResourceFile(rcFileName))
    exit (0);

  messageMakeReload(reload);
  messageMakeAck(ack, reload);

  if (local)
    robustPassLocalReply(id, ack);
  else
    robustPassMessage(_remote, ack);

  return TRUE;
}

#if 0
BOOLEAN parseRestart(BOOLEAN local, char *remote, int id, char *buf)
{
  rcProgramPtr r;
  char  name[MAXTOKEN], buffer[MAXBUF]; 

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);

  r = &(rcAvailableProgramList[rcLookupName(name)]);

  if (r->local) {
    nannyKillProgram(name);
    nannyExecProgram(name);
  } else {
    messageMakeRestart(buffer, name);
    robustPassMessage(r->remoteMachine, buffer);
  }
  return TRUE;
}
#endif

/*
 * DESCRIPTION:
 *   set the program to be executing, and pass it on..
 * 
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseAnnounce(BOOLEAN local, char *remote, int id, char *buf)
{
  rcProgramPtr r;
  char  name[MAXTOKEN];
  char  ack[MAXBUF]; 

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);

  r = &(rcAvailableProgramList[rcLookupName(name)]);
  r->ready = (strlen(buf) == 0);
  if (!r->executing && !r->local) {
    /* 
     * nope this meant that when a program died, a remote machine might
     * make us think it was still running 
     */
       if (r->local && 0) {
      WARNING3("%s Program %s being run remotely dead\n", remote, name);
      r ->local = FALSE;
      strcpy(r->remoteMachine,remote);
    }
       
    r->executing = TRUE;
    r->wantToExecute = FALSE;
    nannyConnectNote(TRUE, r->remoteMachine,-1);
    messageMakeAnnounce(ack, name, r->ready);
    nannyReportLocalMessage(ack);
  }

  return TRUE;
}

/*
 * DESCRIPTION:
 *   set the program to be executing, and pass it on..
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseDead(BOOLEAN local, char *remote, int id, char *buf)
{
  rcProgramPtr r;
  char  name[MAXTOKEN];
  char  ack[MAXBUF]; 

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);
  buf++; 

  r = &(rcAvailableProgramList[rcLookupName(name)]);
  if (r->executing) {
    if (r->local) {
      WARNING2("%s didn't die\n", name);
      messageMakeAnnounce(ack, name, r->ready);
      nannyReportDualMessage(ack);
    } else {
      r->executing = FALSE;
      nannyConnectNote(TRUE, r->remoteMachine,-1);
    }
  }
  
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 *
 * Ask Joseph: Why does the "ping" announce all the running programs?
 */
BOOLEAN parsePing(BOOLEAN local, char *remote, int id, char *buf)
{
  rcProgramPtr r;
  int r_id;
  char  ack[MAXBUF]; 
  char  _remote[MAXBUF];

  strcpy(_remote,remote);

  for (r_id=0; r_id< rcNumAvailablePrograms; r_id++) {
    r = &(rcAvailableProgramList[r_id]);
    if (r->executing) {
      if (local)
	nannyConnectNote(!r->local, r->remoteMachine,id);
      else
	if (!r->local) 
	  nannyConnectNote(TRUE, _remote, -1);
      
      messageMakeAnnounce(ack, r->name, r->ready);
      nannyReportDualMessage(ack);
    }
  }

  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseBeat(BOOLEAN local, char *remote, int id, char *buf)
{
  char  name[MAXTOKEN];

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);
  buf++; 

  nannyConnectNote(TRUE, name, -1);

  return TRUE;
}

/*
 * DESCRIPTION:
 *   This will be passed to local runconsoles 
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseAck(BOOLEAN local, char *remote, int id, char *buf)
{
  char dummy[MAXTOKEN], buffer[MAXBUF];

  buf = messageExtractKey(buf, dummy);
  messageMakeAck(buffer,buf);

  nannyReportLocalMessage(buffer);
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseNack(BOOLEAN local, char *remote, int id, char *buf)
{
  char dummy[MAXTOKEN], buffer[MAXBUF];

  buf = messageExtractKey(buf, dummy);
  messageMakeNAck(buffer,buf);

  nannyReportLocalMessage(buffer);
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseFlush(BOOLEAN local, char *remote, int id, char *buf)
{
  int i;
  rcProgramPtr r;
  char name[MAXTOKEN], buffer[MAXBUF], message[MAXBUF];
  char  ack[MAXBUF]; 
  char  _remote[MAXBUF];

  strcpy(_remote,remote);

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);
  buf++; 
    
  /* Reset previous thoughts about who is shouting... */
  for (i=0; i<rcNumAvailablePrograms; i++) {
    r = &(rcAvailableProgramList[i]);
    
    if (r->executing && r->local)
      r->loudness = (r->alwaysVerbose ? VERBOSE | QUIET : QUIET); 
  }
  
  r = &(rcAvailableProgramList[rcLookupName(name)]);
  r->loudness = VERBOSE | QUIET;
  if (r->local) {
    int i, j=0;
    
    /* Handle wraparound of the buffer */
    if (r->ibufEnd > MAXBUF)
      i = r->ibufEnd - MAXBUF;
    else
      i = 0;
    
    for (; i<r->ibufEnd; i++) {
      buffer[j] = r->stdinBuffer[i%MAXBUF];
      if (buffer[j++] == '\n') {
	buffer[j]='\0';
	if (strlen(buffer)) {
	  messageMakeInfo(message, r->name, FALSE, buffer);
	  if (local)
	    robustPassLocalReply(id, message);
	  else
	    robustPassMessage(_remote, message);
	}
	j = 0;
      }
    }
    buffer[j]='\0';
    if (strlen(buffer)) {
      messageMakeInfo(message, r->name, FALSE, buffer);
      if (local)
	robustPassLocalReply(id, message);
      else
	robustPassMessage(_remote, message);
    }
    j = 0;
  } else {
    messageMakeFlush(buffer, name);
    robustPassMessage(r->remoteMachine, buffer);
  }
  
  messageMakeFlush(buffer, name);
  messageMakeAck(ack, buffer);
  
  if (local)
    robustPassLocalReply(id, ack);
  else
    robustPassMessage(_remote, ack);

  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseBreak(BOOLEAN local, char *remote, int id, char *buf)
{
  rcProgramPtr r;
  char bufp[MAXBUF], name[MAXTOKEN]; 
  char syscall[DEFAULT_LINE_LENGTH];

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);
  buf++; 

  r = &(rcAvailableProgramList[rcLookupName(name)]);
  if (r->local) {
    sprintf(syscall, "kill -INT %d", r->pid);
    system(syscall);
  }
  else {
    messageMakeBreak(bufp, name);
    robustPassMessage(r->remoteMachine, bufp);
  }
  return TRUE;
}

/*
 * DESCRIPTION:
 *   Return available programs 
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseList(BOOLEAN local, char *remote, int id, char *buf)
{
  char  list[MAXBUF]; 
  char  tmp[MAXBUF]; 
  char  ack[MAXBUF];
  int   i;

  if (!local)  return FALSE;

  nannyConnectNote(FALSE, NULL, id);

  /* Reset previous thoughts about who is shouting... */
  strcpy(list, "");
  for (i=0; i<rcNumAvailablePrograms; i++)
    {
      rcProgramPtr r = &(rcAvailableProgramList[i]);
      
      strcpy(tmp,list);
      sprintf(list, "%s %s", tmp, r->name);
    }

  messageMakeList(ack, list);
  robustPassLocalReply(id, ack);

  return TRUE;
}

/*****************************************************************/
/*****************************************************************/
/* I don't think these are used any more... */
/*****************************************************************/
/*****************************************************************/
/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parsePause(BOOLEAN local, char *remote, int id, char *buf)
{
  rcProgramPtr r;
  char bufp[MAXBUF], name[MAXTOKEN]; 
  char syscall[DEFAULT_LINE_LENGTH];

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);
  buf++; 

  r = &(rcAvailableProgramList[rcLookupName(name)]);
  if (r->local) {
    sprintf(syscall, "kill -STOP %d", r->pid);
    system(syscall);
  }
  else {
    messageMakePause(bufp, name);
    robustPassMessage(r->remoteMachine, bufp);
  }
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseContinue(BOOLEAN local, char *remote, int id, char *buf)
{
  rcProgramPtr r;
  char bufp[MAXBUF], name[MAXTOKEN]; 
  char syscall[DEFAULT_LINE_LENGTH];

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);
  buf++; 

  r = &(rcAvailableProgramList[rcLookupName(name)]);
  if (r->local) {
    sprintf(syscall, "kill -CONT %d", r->pid);
    system(syscall);
  }
  else {
    messageMakeContinue(bufp, name);
    robustPassMessage(r->remoteMachine, bufp);
  }
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseQuiet(BOOLEAN local, char *remote, int id, char *buf)
{
  char  name[MAXTOKEN]; 
  char  original[DEFAULT_LINE_LENGTH]; 
  char  ack[MAXBUF]; 
  rcProgramPtr r;

  buf = messageExtractKey(buf, name);
  messageExtractKey(buf, name);

  messageMakeQuiet(original, name);
  if (rcLookupName(name) == -1) 
    messageMakeNAck(ack, original);
  else {
    r = &(rcAvailableProgramList[rcLookupName(name)]);
    r->loudness = QUIET;
    r->alwaysVerbose = FALSE;
    messageMakeAck(ack, original);
  }

  nannyReportDualMessage(ack);
  
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseSilent(BOOLEAN local, char *remote, int id, char *buf)
{
  char  name[MAXTOKEN]; 
  char  original[DEFAULT_LINE_LENGTH]; 
  char  ack[MAXBUF]; 
  rcProgramPtr r;

  buf = messageExtractKey(buf, name);
  messageExtractKey(buf, name);

  messageMakeSilent(original, name);
  if (rcLookupName(name) == -1) 
    messageMakeNAck(ack, original);
  else {
    r = &(rcAvailableProgramList[rcLookupName(name)]);
    r->loudness = SILENT;
    r->alwaysVerbose = FALSE;
    messageMakeAck(ack, original);
  }

  nannyReportDualMessage(ack);
  
  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseVerbose(BOOLEAN local, char *remote, int id, char *buf)
{
  char  name[MAXTOKEN]; 
  char  original[DEFAULT_LINE_LENGTH]; 
  char  ack[MAXBUF]; 
  rcProgramPtr r;

  buf = messageExtractKey(buf, name);
  messageExtractKey(buf, name);

  messageMakeVerbose(original, name);
  if (rcLookupName(name) == -1) 
    messageMakeNAck(ack, original);
  else {
    r = &(rcAvailableProgramList[rcLookupName(name)]);
    r->loudness = VERBOSE | QUIET;
    r->alwaysVerbose = TRUE;
    messageMakeAck(ack, original);
  }

  nannyReportDualMessage(ack);

  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseEnquire(BOOLEAN local, char *remote, int id, char *buf)
{
  char name[MAXTOKEN];

  buf = messageExtractKey(buf, name);
  messageExtractKey(buf, name);

  return TRUE;
}

/*
 * DESCRIPTION:
 *
 * INPUTS:
 *
 * OUTPUTS:
 */
BOOLEAN parseStatus(BOOLEAN local, char *remote, int id, char *buf)
{
  char name[MAXTOKEN]; 
  char status[MAXBUF];

  buf = messageExtractKey(buf, name);
  buf = messageExtractKey(buf, name);
  messageExtractKey(buf, status);

  return TRUE;
}

