/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: runControl.c
 *
 * ABSTRACT:
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/messageHandle.h,v $
 * $Revision: 1.2 $
 * $Date: 1996/08/05 16:08:02 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: messageHandle.h,v $
 * Revision 1.2  1996/08/05  16:08:02  rich
 * Added comments to endifs.
 *
 * Revision 1.1  1995/12/17  20:25:38  rich
 * Moved Nanny to the tca release.
 *
 * Revision 1.9  1995/09/28  19:31:53  josullvn
 * Lots o changes
 *
 * Revision 1.8  1995/09/26  20:35:32  rich
 * Fixed order of system specific libraries.
 * Removed extra "extern"s.
 *
 * Revision 1.7  1995/07/15  07:12:59  josullvn
 * ProcessDevices is _not_ reentrant - this was causing lots of problems as it
 * turns out. Restructing my blocking code fixed it.
 * Also, added a notion of dead - that is telling when something has
 * finally died.
 *
 * Revision 1.6  1995/07/13  11:09:39  josullvn
 * Two bugs were present. a) syscalls were being interrupted, and b) the
 * processes button management got screwy after a while. The first is due
 * to Devutils, second fixed by removing a reliance on xclient data. Also
 * added features to newProcess whereby it is now menu driven.
 * Added tca.rc, removing those processes from the Simulator resource files.
 *
 * Revision 1.5  1995/07/11  22:59:08  josullvn
 * Needed to retain the concept of who sent a message, and so had to
 * restructure all the message passing. Also, made sure we don't
 * overwrite any of the parameters due to reentry problems.
 *
 * Revision 1.4  1995/07/11  11:21:28  josullvn
 * A lot more changes to message passing to handle multiple nannys better.
 * This basically involved removing fdclient, and being smarter about what
 * nannys are in the system
 *
 * Revision 1.3  1995/07/11  06:58:43  josullvn
 * Added capabilities for inter-nanny communication.
 * Mainly, there is now a list of connections, and each new executable is
 * announced to the whole list - may need to work on the kill part...
 *
 * Revision 1.2  1995/05/15  17:07:10  rich
 * Updated interface to createLineBuffer so you can get partial lines and
 * the delimit character is not replaced.
 * Imporved layout of the X11 window of the console.
 *
 *
 *****************************************************************************/
#ifndef MESSAGEHANDLE_H_INCLUDED
#define MESSAGEHANDLE_H_INCLUDED

#include "tca/libc.h"

BOOLEAN parseExec(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseKill(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseQuiet(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseSilent(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseVerbose(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseEnquire(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseStatus(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseStdout(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseStdin(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseError(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseReload(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseAnnounce(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parsePing(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseDestroy(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseAck(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseNack(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseFlush(BOOLEAN local, char *remote, int id, char *buf);
/*BOOLEAN parseRestart(BOOLEAN local, char *remote, int id, char *buf);*/
BOOLEAN parseBreak(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parsePause(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseContinue(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseBeat(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseList(BOOLEAN local, char *remote, int id, char *buf);
BOOLEAN parseDead(BOOLEAN local, char *remote, int id, char *buf);

extern char *filterString;

#endif /* MESSAGEHANDLE_H_INCLUDED */
