#include "history.h"

/*****************************************************************************/
              /* Input History management */
/*****************************************************************************/

/*
 */
void historyFreeProcess(inputHistoryPtr h)
{
  int i;

  if (h->buffer==NULL)
    return;

  for (i=0; i< h->pos; i++)
    free(h->buffer[i]);
  free(h->buffer);

  h->buffer  = (char **)NULL;
  h->current = h->pos = 0;
}

/*
 */
void historyAddCommand(inputHistoryPtr h, char *command)
{
  if (!command) return;

  if (h->pos == 0)
    h->buffer = (char **) malloc (sizeof(char *));
  else
    h->buffer = (char **) realloc (h->buffer, 
				   (h->pos+1)*sizeof(char *));
  h->buffer[h->pos] = (char *) malloc (strlen(command)+1);
  strcpy(h->buffer[h->pos], command);
  h->pos++;
  h->current = h->pos; 
}

/*
 *
 */
char *historyPrev(inputHistoryPtr h)
{
  if (h->current > 0)
    h->current--;

  return h->buffer[h->current];
}

/*
 * 
 */
char *historyNext(inputHistoryPtr h)
{
  if (h->current <  (h->pos-1))
    h->current++;

  return h->buffer[h->current];
}

