/*****************************************************************************
 * PROJECT: Xavier
 *
 * (c) Copyright 1993 Richard Goodwin & Joseph O'Sullivan. All rights reserved.
 *
 * FILE: callbacks.h
 *
 * ABSTRACT: General callback code (used by both xCallbacks and xfCallbacks).
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/nanny/callbacks.h,v $
 * $Revision: 1.4 $
 * $Date: 1996/08/05 16:07:59 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: callbacks.h,v $
 * Revision 1.4  1996/08/05  16:07:59  rich
 * Added comments to endifs.
 *
 * Revision 1.3  1996/07/29  05:03:01  josullvn
 * Bloody hell. This commiting is a bit different than under Xavier. Short
 * story is cleaned up some purify bugs, and also made changes to nanny
 * which should make it a bit better - Improving performance over multiple
 * machines, explict quietening of nondisplayed processes, replacing of
 * runConsole with xfMiniConsole, which is multithreaded, vt102 compilant,
 * adds a uniform emacs-like command line editing feature, better on small
 * screens and otherwise fab.
 *
 * Revision 1.2  1996/06/28  14:07:14  reids
 * Fixed quite a few bugs -- with graphics, interaction with script, and
 *   killing processes
 *
 * Revision 1.1  1996/03/29  16:08:11  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *    xRunConsole and xfRunConsole.
 *
 * ABSTRACT:
 *
 * REVISION HISTORY:
 *
 * $Log: callbacks.h,v $
 * Revision 1.4  1996/08/05  16:07:59  rich
 * Added comments to endifs.
 *
 * Revision 1.3  1996/07/29  05:03:01  josullvn
 * Bloody hell. This commiting is a bit different than under Xavier. Short
 * story is cleaned up some purify bugs, and also made changes to nanny
 * which should make it a bit better - Improving performance over multiple
 * machines, explict quietening of nondisplayed processes, replacing of
 * runConsole with xfMiniConsole, which is multithreaded, vt102 compilant,
 * adds a uniform emacs-like command line editing feature, better on small
 * screens and otherwise fab.
 *
 * Revision 1.2  1996/06/28  14:07:14  reids
 * Fixed quite a few bugs -- with graphics, interaction with script, and
 *   killing processes
 *
 * Revision 1.1  1996/03/29  16:08:11  reids
 * Consolidated the common code between xCallbacks and xfCallbacks, and
 *    xRunConsole and xfRunConsole.
 *
 *****************************************************************************/
#ifndef CALLBACKS_H_INCLUDED
#define CALLBACKS_H_INCLUDED

#define KILL 1
#define QUIT 2
#define RESTART 3

#define SUSPEND "Suspend"
#define RESUME  "Resume"

#define POLLING_PERIOD 10  /* Poll 10 times per second */

extern BOOLEAN flushing;
extern int flushing_count;
extern int numPossiblePrograms;
extern char possiblePrograms[BUFSIZ];
extern struct timeval pollTime;

extern void safeExit (void);
extern void cpyList (const char *list);
extern int convertProcessNameToId (const char *name);
extern BOOLEAN safePassLocalMessage(const char *message);
extern void reloadResource (const char *reloadName);
extern void syncWithNanny (void);
extern void setFilterString (const char *newFilter);
extern void killCurrentProcess (void);
extern void restartCurrentProcess (void);
extern BOOLEAN checkForCurrentProc (void);
extern void sendBreak (void);
extern void getProcessList (const char *action);
extern void destroyProcess (const char *procName);
extern void shutdownProcess (void);
extern void startFlushing (const char *processName);
extern void addProcess (const char *name);
extern void removeProcess (const char *name);
extern double getPosition (void);
extern void initPosition (void);
extern void updatePosition (void);
extern void rerunScript (void);
extern void suspendResume (const char *currentState);
extern void stopScript (void);

/* These are defined in either xCallbacks or xfCallbacks */
extern void addProcessButton (const char *name);
extern void destroyProcessButton (int index);
extern void resetProcessButtons (int index);
extern BOOLEAN highlightProcess (char *name);
extern void Feep (void);
extern void WFlush (void);
extern void MessagePrintf (const char *str);
extern void unfreeze (void);
extern void activateStatus (const char *message);
extern void deactivateStatus (const char *message);
extern void setSuspendResume (const char *title);
extern void EditAppend(char *buffer, int n);
extern void attachProgramMenu (void);
extern struct _CONSOLE_GRAPHICS *createConsoleGraphics (void);
extern void clearConsoleGraphics (consoleProcPtr consoleProc);
extern void copyConsoleGraphics (consoleProcPtr from, consoleProcPtr to);
extern void sendLoud (char *name);
extern void sendQuiet (char *name);

#endif /* CALLBACKS_H_INCLUDED */
