/*****************************************************************************
 * (c) Copyright 1996 Greg Whelan and Reid Simmons.  All rights reserved.
 *
 * FILE: tcl-framework.c
 *
 * ABSTRACT: Message visualization tool
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/tools/comview/tcl-framework.c,v $ 
 * $Revision: 1.6 $
 * $Date: 1996/07/25 18:24:53 $
 * $Author: whelan $
 *
 * REVISION HISTORY
 * $Log: tcl-framework.c,v $
 * Revision 1.6  1996/07/25  18:24:53  whelan
 * Added a "colors" menu that describes what kind of message each of the
 * colors corresponds to, and allows the user to modify the colors.
 *
 * Revision 1.5  1996/07/19  21:04:43  whelan
 * A file can now be opened from within Comview -- does not have to be
 * specified on the command line.
 *
 * Revision 1.4  1996/07/19  14:26:55  whelan
 * Comview directory specified from compilation directory.
 *
 * Revision 1.3  1996/07/18  16:04:31  reids
 * Changes for the New Millennium environment (NMP_IPC) (plus log history)
 *
 ****************************************************************/

/*  Compile with: gcc -s -ansi -Wall -o appl appl.c -ltk -ltcl -lX11 -lm 

gcc -s -ansi -Wall -o appl2 appl2.c -L/afs/cs/misc/tcl/build/tk4.0 -L/afs/cs/misc/tcl/build/tcl7.4 -I/afs/cs/misc/tcl/common/beta/include -ltk -ltcl -lX11 -lm 

*/

#include <stdio.h>
#include <stdlib.h>
#include "tca/libc.h"
#include <tcl.h>
#include <tk.h>
#include <string.h>
#include <math.h>

#include "comview.h"
#include "tcl-framework.h"
#include "Top.h"

#define STARTUP_FILE "comview.tcl"

static char *tcl_RcFileName =  NULL;
char *s_filename;
char zoom_init_str[255];
char startup_string[255];
char set_dir_string[255];
char file_sel_string[255];

static Tcl_Interp *tcl_interp;
static Tk_Window tcl_mainwindow;

extern int COMVIEW_DEBUG;

/* -------------------- local prototypes ----------------------------- */

int Get_TCA_Data(ClientData, Tcl_Interp *, int, char *[]);

/* ------------------------------------------------------------------- */

int Get_TCA_Data(ClientData clientData, Tcl_Interp *interp,
		 int argc, char *argv[])
{
  interp->result=uno_step(interp);

  return TCL_OK;
}


int init_grafx(int argc, char **argv, char *set_filename, 
	       int file_selected, char *zoom, int zoom_found, 
	       char *comview_directory)
{
  int c=1; /* bogus hack because we don't want Tk to see the command */
	   /* line arguments (they're not for Tk) */
  
  s_filename=set_filename;
  if (zoom_found) { sprintf(zoom_init_str,"set Scale_Factor %s", zoom); } 
  else { sprintf(zoom_init_str,"set Scale_Factor -1"); } 

  sprintf(set_dir_string, "set COMVIEW_DIRECTORY %s", comview_directory);
  sprintf(file_sel_string, "set FILE_SELECTED %d", file_selected);
  sprintf(startup_string,"source %s/%s", 
	  comview_directory, STARTUP_FILE);

  if (COMVIEW_DEBUG) {
    /* For debugging purposes this will result in a wish prompt */
    Tk_Main(c, argv, (Tcl_AppInitProc*) Tcl_AppInit);
  } else {
    /* For normal usage, use the Tk main event loop (no prompt) */
    tcl_interp = Tcl_CreateInterp();
    tcl_mainwindow = Tk_CreateMainWindow(tcl_interp,(char *)NULL,
					 argv[0],argv[0]);
    Tcl_AppInit(tcl_interp);
    Tk_MainLoop();
  }

  exit(0);

  return 0;
}

int create_new_module(Tcl_Interp *interp, int number, char *name)
{
  char foo[255];

  if (COMVIEW_DEBUG) {
    fprintf(stderr, "C Creating New_Module %d \"%s\"\n", number,
	    name);
  }
  sprintf(foo, "New_Module %d \"%s\"\n", number, name);
  Tcl_Eval(interp, foo);

  return TCL_OK;
}

/*
 * Tcl_AppInit is called from Tcl_Main
 * after the Tcl interpreter has been created,
 * and before the script file
 * or interactive command loop is entered.
 */
int Tcl_AppInit(Tcl_Interp *interp)
{

  /* Initialize packages * Tcl_Init sets up the Tcl library facility. */
  if (Tcl_Init(interp) == TCL_ERROR) {
    return TCL_ERROR;
  }
  if (Tk_Init(interp) == TCL_ERROR) {
    return TCL_ERROR;
  }

  /* Define application-specific commands here. */
  Tcl_CreateCommand(interp, "C_Get_TCA_Data", Get_TCA_Data,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

  Tcl_CreateCommand(interp, "C_Update_Listbox", update_listbox,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
  
  Tcl_CreateCommand(interp, "C_Load_File", load_file,
		    (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);
  
  /*
   * Define startup filename. This file is read in
   * case the program is run interactively.
   */
  tcl_RcFileName = STARTUP_FILE;

  Tcl_Eval(interp, s_filename);
  Tcl_Eval(interp, file_sel_string);
  Tcl_Eval(interp, zoom_init_str);
  Tcl_Eval(interp, set_dir_string);
  Tcl_Eval(interp, startup_string);

  return TCL_OK;
}
