/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * MODULE: 
 *
 * FILE: 
 *
 * ABSTRACT: Windows NT test program by Iain Shigeoka.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/test/winnt_b.c,v $ 
 * $Revision: 1.2 $
 * $Date: 1996/02/10 23:35:35 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: winnt_b.c,v $
 * Revision 1.2  1996/02/10  23:35:35  rich
 * Fixed main calls.
 *
 * Revision 1.1  1996/02/06  19:25:53  rich
 * Adding windows NT examples.
 *
 *
 *****************************************************************************/

#include <stdio.h>
#include <winsock.h>
#include "tca.h"
#include "wnntprim.h"

void
intMsgHnd(TCA_REF_PTR ref, INT_PTR x)
{
  printf("*x: %d\n", *x);
  tcaSuccess(ref);
  tcaFreeData(tcaReferenceName(ref),x);
}

void
floatMsgHnd(TCA_REF_PTR ref, FLOAT_PTR f)
{
  printf("*f: %f\n", *f);
  tcaSuccess(ref);
  tcaFreeData(tcaReferenceName(ref),f);
}

void
doubleMsgHnd(TCA_REF_PTR ref, DOUBLE_PTR d)
{
  printf("*d: %f\n", *d);
  tcaSuccess(ref);
  tcaFreeData(tcaReferenceName(ref),d);
}

void
charMsgHnd(TCA_REF_PTR ref, CHAR_PTR c)
{
  printf("*c: %c\n", *c);
  tcaSuccess(ref);
  tcaFreeData(tcaReferenceName(ref),c);
}

void
stringMsgHnd(TCA_REF_PTR ref, STRING_PTR str)
{
  printf("*str: %s\n", *str);
  tcaSuccess(ref);
  tcaFreeData(tcaReferenceName(ref),str);
}

void main(int argc, char **argv)
{
  
  /* We must start up the Winsock first */
  /* Begin winsock startup */
  WORD wVersionRequested;
  WSADATA wsaData;
  int err;
  
  wVersionRequested = MAKEWORD( 1, 1);
  err = WSAStartup( wVersionRequested, &wsaData);
  if(err!=0){
    switch (err) {
    case WSASYSNOTREADY:
      printf("Network subsystem not ready for network communication\n");
      printf("Cannot continue\n");
      break;
    case WSAVERNOTSUPPORTED:
      printf("You do not have a version 1.1 Winsock or greater\n");
      printf("Cannot continue\n");
      break;
    case WSAEINVAL:
      printf("You winsock.dll is not 100% Winsock compatible\n");
      printf("Cannot continue\n");
      break;
    default:
      printf("Unknown Winsock start up error #%d",err);
      printf("Cannot continue\n");
    }
    return;
  }
  
  if (LOBYTE(wVersionRequested) != 1 || HIBYTE(wVersionRequested) != 1) {
    printf("Your winsock.dll does not support version 1.1");
    printf("Cannot continue\n");
    WSACleanup();
    return;
  }
  
  /* End winsock startup */
  printf("Winsock successfully loaded\n");
  /* If we made it here, version 1.1 is supported and has been loaded */
  
  printf("Connecting...\n");
  
  tcaConnectModule("Module B", tcaServerMachine());
  printf("Connected!\n");
  
  tcaRegisterCommandMessage("intMsg",INT_FORMAT);
  tcaRegisterHandler("intMsg","intMsgHnd",intMsgHnd);
  printf("Registering intMsg handler\n");
  
  tcaRegisterCommandMessage("floatMsg",FLOAT_FORMAT);
  tcaRegisterHandler("floatMsg","floatMsgHnd",floatMsgHnd);
  printf("Registering floatMsg handler\n");
  
  tcaRegisterCommandMessage("doubleMsg",DOUBLE_FORMAT);
  tcaRegisterHandler("doubleMsg","doubleMsgHnd",doubleMsgHnd);
  printf("Registering doubleMsg handler\n");
  
  tcaRegisterCommandMessage("charMsg",CHAR_FORMAT);
  tcaRegisterHandler("charMsg","charMsgHnd",charMsgHnd);
  printf("Registering charMsg handler\n");
  
  tcaRegisterCommandMessage("stringMsg",STRING_FORMAT);
  tcaRegisterHandler("stringMsg","stringMsgHnd",stringMsgHnd);
  printf("Registering stringMsg handler\n");
  
  printf("\nWaiting for module A...\n");
  tcaWaitUntilReady();
  
  printf("Activated!\n");
  tcaModuleListen();
  printf("Done.");
  
  WSACleanup();
  printf("Socket cleaned up.");
}
