/*****************************************************************************
 * PROJECT: Carnegie Mellon Planetary Rover Project
 *          Task Control Architecture
 *
 * MODULE: 
 *
 * FILE: 
 *
 * ABSTRACT: Windows NT test program by Iain Shigeoka.
 *
 * $Source: /afs/cs.cmu.edu/project/TCA/Master/tcaV8/test/winnt_a.c,v $ 
 * $Revision: 1.2 $
 * $Date: 1996/02/10 23:35:34 $
 * $Author: rich $
 *
 * REVISION HISTORY:
 *
 * $Log: winnt_a.c,v $
 * Revision 1.2  1996/02/10  23:35:34  rich
 * Fixed main calls.
 *
 * Revision 1.1  1996/02/06  19:25:52  rich
 * Adding windows NT examples.
 *
 *
 *****************************************************************************/

#include <stdio.h>
#include <winsock.h>
#include "tca.h"
#include "wnntprim.h"

void main(int argc, char **argv)
{
  INT_TYPE 	x;
  FLOAT_TYPE 	f;
  DOUBLE_TYPE d;
  CHAR_TYPE	c;
  STRING_TYPE	str;
  
  /* We must start up the Winsock first */
  /* Begin winsock startup */
  WORD wVersionRequested;
  WSADATA wsaData;
  int err;
  
  wVersionRequested = MAKEWORD( 1, 1);
  err = WSAStartup( wVersionRequested, &wsaData);
  if(err!=0){
    switch (err) {
    case WSASYSNOTREADY:
      printf("Network subsystem not ready for network communication\n");
      printf("Cannot continue\n");
      break;
    case WSAVERNOTSUPPORTED:
      printf("You do not have a version 1.1 Winsock or greater\n");
      printf("Cannot continue\n");
      break;
    case WSAEINVAL:
      printf("You winsock.dll is not 100% Winsock compatible\n");
      printf("Cannot continue\n");
      break;
    default:
      printf("Unknown Winsock start up error #%d",err);
      printf("Cannot continue\n");
    }
    return;
  }
  
  if (LOBYTE(wVersionRequested) != 1 || HIBYTE(wVersionRequested) != 1) {
    printf("Your winsock.dll does not support version 1.1");
    printf("Cannot continue\n");
    WSACleanup();
    return;
  }
  
  /* End winsock startup */
  printf("Winsock successfully loaded\n");
  /* If we made it here, version 1.1 is supported and has been loaded */
  
  printf("Connecting...\n");
  tcaConnectModule("Module A", tcaServerMachine());
  printf("Connected.  Waiting for module B.\n");
  
  tcaWaitUntilReady();
  printf("Ready...\n");
  
  x =  17;
  f = 1.0;
  d = 2.0;
  c = 'A';
  str = (STRING_TYPE)malloc(sizeof(char)*4);
  str[0] = 'a';
  str[1] = 'b';
  str[2] = 'c';
  str[3] = '\0';
  
  printf("Beginning command execution\n");
  printf("Sending intMsg...\n");
  tcaExecuteCommand("intMsg",&x);
  printf("intMsg sent\n");
  printf("Sending floatMsg...\n");
  tcaExecuteCommand("floatMsg",&f);
  printf("floatMsg sent\n");
  printf("Sending doubleMsg...\n");
  tcaExecuteCommand("doubleMsg",&d);
  printf("doubleMsg sent\n");
  printf("Sending charMsg...\n");
  tcaExecuteCommand("charMsg",&c);
  printf("charMsg sent\n");
  printf("Sending stringMsg...\n");
  tcaExecuteCommand("stringMsg",&str);
  printf("stringMsg sent\n\nDone!\n");
  
  WSACleanup();
  printf("Socket cleaned up.");
}
