
#include "tca/libc.h"
#include "tca.h"

typedef struct { int i;
		 double d;
	       } TEST_TYPE, *TEST_PTR;

#define TEST_NAME   "test"
#define TEST_FORMAT "{int, double}"

static void testHnd (TCA_REF_PTR ref, TEST_PTR data)
{
  fprintf(stderr, "Data received: %d, %f\n", data->i, data->d);
  fflush(stdout);
  tcaFreeData(tcaReferenceName(ref), data);
}

void main (void)
{
  TEST_TYPE testData;

  tcaConnectModule("test", tcaServerMachine());

  tcaRegisterInform(TEST_NAME, TEST_FORMAT, testHnd);

  tcaWaitUntilReady();

  testData.i = 1; testData.d = 90.0;
  fprintf(stderr, "Data sent: %d, %f\n", testData.i, testData.d);
  tcaInform(TEST_NAME, &testData);
  tcaModuleListen();
}
